package voxeet.com.sdk.core.services;

import retrofit2.adapter.rxjava.HttpException;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.network.IUserRService;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.events.error.GetUploadTokenErrorEvent;
import voxeet.com.sdk.events.error.NewLoginRequiredEvent;
import voxeet.com.sdk.events.success.GetTokenUploadSuccessEvent;

/**
 * Created by RomainB on 5/12/16.
 */
public class UserService extends voxeet.com.sdk.core.AbstractVoxeetService<IUserRService> {

    /**
     * Instantiates a new User service.
     *
     * @param instance the parent instance
     */
    public UserService(VoxeetSdkTemplate instance) {
        super(instance, IUserRService.class);
    }

    /**
     * The interface User service listener.
     */
    public interface UserServiceListener {
        /**
         * On login success.
         *
         * @param id the id
         */
        void onLoginSuccess(String id);

        /**
         * On logout sucesss.
         */
        void onLogoutSucesss();
    }


    /**
     * Gets upload token.
     */
    public final void getUploadToken() {
        final rx.Observable<GetTokenUploadSuccessEvent> user = getService().getUploadToken();
        user.subscribeOn(Schedulers.newThread())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Subscriber<GetTokenUploadSuccessEvent>() {
                    @Override
                    public void onCompleted() {
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (e instanceof HttpException && ((HttpException) e).response().code() == 403) {
                            getEventBus().post(new NewLoginRequiredEvent("New login required"));
                        }

                        getEventBus().post(new GetUploadTokenErrorEvent(handleError(e)));
                    }

                    @Override
                    public void onNext(GetTokenUploadSuccessEvent response) {
                        getEventBus().post(response);

                        VoxeetPreferences.setUploadToken(response.getUploadToken());
                    }
                });
    }
}