package voxeet.com.sdk.core.services;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.widget.Toast;

import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;

/**
 * Created by kevinleperf on 16/07/2018.
 */

public class ScreenShareService extends AbstractVoxeetService {
    private static final int REQUEST_SCREEN_CAPTURE = 672;
    private static final String TAG = ScreenShareService.class.getSimpleName();

    private VoxeetSdkTemplate mInstance;

    private int mLastResultCode;
    private Intent mLastData;


    public ScreenShareService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);

        mInstance = instance;
    }

    public void toggleScreenShare() {
        mInstance.getConferenceService().toggleScreenShare();
    }

    public Promise<Boolean> startScreenShare(@NonNull Intent intent) {
        AbstractConferenceSdkService service = mInstance.getConferenceService();

        return service.startScreenShare(intent);
    }

    public Promise<Boolean> stopScreenShare() {
        return mInstance.getConferenceService().stopScreenShare();
    }

    public void sendRequestStartScreenShare() {
        getEventBus().post(new RequestScreenSharePermissionEvent());
    }

    public boolean sendUserPermissionRequest(@NonNull Activity activity) {
        if (Build.VERSION_CODES.LOLLIPOP <= Build.VERSION.SDK_INT) {
            MediaProjectionManager manager = (MediaProjectionManager)
                    activity.getSystemService(Context.MEDIA_PROJECTION_SERVICE);
            Intent request = manager.createScreenCaptureIntent();
            activity.startActivityForResult(request, ScreenShareService.REQUEST_SCREEN_CAPTURE);
            return true;
        }
        return false;
    }

    public void consumeRightsToScreenShare() {
        if (mLastResultCode == Activity.RESULT_OK && null != mLastData) {
            startScreenShare(mLastData)
                    .then(new PromiseExec<Boolean, Object>() {
                        @Override
                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                            Log.d(TAG, "onCall: starting screen share");
                        }
                    })
                    .error(new ErrorPromise() {
                        @Override
                        public void onError(@NonNull Throwable error) {
                            Log.d(TAG, "onError: error while starting screen share");
                            error.printStackTrace();
                        }
                    });
            mLastData = null;
        }
    }

    /**
     * Manage the Activity result in the context of the Screen Share Feature
     * <p>
     * returns true if the logic was managed
     * false, otherwise
     *
     * @param requestCode the resultCode obtained it should match
     * @param resultCode
     * @param data
     * @return
     */
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        //Toast.makeText(mInstance.getApplicationContext(), "requestCode := " + requestCode + " " + resultCode, Toast.LENGTH_SHORT).show();
        if (requestCode == REQUEST_SCREEN_CAPTURE) {
            if (Activity.RESULT_OK != resultCode) {
                mInstance.getConferenceService().onUserCanceledScreenShare();
            } else {
                mLastResultCode = resultCode;
                mLastData = data;
            }
        }
        return false;
    }

    public static class RequestScreenSharePermissionEvent {
        public RequestScreenSharePermissionEvent() {
            //empty constructor
        }
    }
}
