package voxeet.com.sdk.core.services;

import android.support.annotation.NonNull;

import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.android.media.audio.AudioManager;
import com.voxeet.android.media.audio.AudioRoute;

import java.util.List;

import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.utils.Validate;

/**
 * Created by kevinleperf on 11/07/2018.
 */

public class AudioService extends AbstractVoxeetService {
    private final AudioManager mAudioManager;
    private final MediaPowerManager mMediaPowerManager;

    /**
     * Instantiate a new Audio Service
     *
     * @param instance the voxeet parent instance
     */
    public AudioService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);

        mAudioManager = new AudioManager(instance.getApplicationContext());
        mMediaPowerManager = new MediaPowerManager(instance.getApplicationContext(),
                currentRoute());
    }

    /**
     * Get the current available routes
     *
     * @return a non null route
     */
    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return mAudioManager.availableRoutes();
    }

    public AudioRoute currentRoute() {
        return mAudioManager.outputRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        mAudioManager.setOutputRoute(route);
        return true;
    }

    public void setSpeakerMode(boolean isSpeaker) {
        mAudioManager.setSpeakerMode(isSpeaker);
    }

    public boolean isSpeakerOn() {
        return AudioRoute.ROUTE_SPEAKER.equals(mAudioManager.outputRoute());
    }

    public void acquireLocks() {
        mMediaPowerManager.acquire();
    }

    public void releaseLocks() {
        mMediaPowerManager.release();
    }
}
