package voxeet.com.sdk.core.network;

import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;
import rx.Observable;

public interface ISdkVideoPresentationRService {

    @POST("/v1/conferences/{confId}/videopresentation/start")
    Observable<Response<ResponseBody>> startVideoPresentation(@Path("confId") String conferenceId,
                                                              @Body VideoPresentationUrl url);


    @POST("/v1/conferences/{confId}/videopresentation/stop")
    Observable<Response<ResponseBody>> stopVideoPresentation(@Path("confId") String conferenceId);


    @POST("/v1/conferences/{confId}/filepresentation/play")
    Observable<Response<ResponseBody>> playVideoPresentation(@Path("confId") String conferenceId);

    @POST("/v1/conferences/{confId}/filepresentation/pause")
    Observable<Response<ResponseBody>> pauseVideoPresentation(@Path("confId") String conferenceId,
                                                              @Body VideoPresentationSeek body);

    @POST("/v1/conferences/{confId}/filepresentation/seek")
    Observable<Response<ResponseBody>> seekVideoPresentation(@Path("confId") String conferenceId,
                                                             @Body VideoPresentationSeek body);


    public class VideoPresentationUrl {
        public String url;

        private VideoPresentationUrl() {

        }

        public VideoPresentationUrl(String url) {
            this();

            this.url = url;
        }
    }

    public class VideoPresentationSeek {
        public long timestamp;

        private VideoPresentationSeek() {

        }

        public VideoPresentationSeek(long timestamp) {
            this();
            
            this.timestamp = timestamp;
        }
    }
}
