/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.network;

import com.voxeet.android.media.peer.SdpDescription;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import rx.Observable;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.CreateConferenceParams;
import voxeet.com.sdk.json.DeviceEvent;
import voxeet.com.sdk.json.GrandTypeEvent;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartScreenSharingResponse;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopScreenSharingResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.SubscribeConference;
import voxeet.com.sdk.models.TokenResponse;

public interface ISdkConferenceRService {
    @POST(value="v1/conferences/create")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Observable<ConferenceResponse> createConference(@Body CreateConferenceParams var1);

    @GET(value="v1/conferences/demo")
    public Observable<ConferenceResponse> createDemo();

    @POST(value="v1/conferences/{id}/replay")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Observable<ReplayConferenceEvent> replay(@Path(value="id") String var1, @Body SdkConferenceReplayBody var2);

    @GET(value="v1/conferences/{id}/recording/stop")
    public Observable<Response<ResponseBody>> stopRecording(@Path(value="id") String var1);

    @GET(value="/v1/conferences/{id}/status")
    public Observable<GetConferenceStatusEvent> conferenceStatus(@Path(value="id") String var1);

    @DELETE(value="/v1/conferences/{id}/subscribe")
    public Observable<Response<ResponseBody>> unSubscribe(@Path(value="id") String var1);

    @GET(value="/v1/conferences/{id}/subscribe")
    public Observable<SubscribeConference> subscribe(@Path(value="id") String var1);

    @GET(value="/v1/conferences/{id}/history")
    public Observable<List<HistoryConference>> conferenceHistory(@Path(value="id") String var1);

    @GET(value="v1/conferences/{id}/recording/start")
    public Observable<Response<ResponseBody>> startRecording(@Path(value="id") String var1);

    @POST(value="v1/conferences/{conferenceId}/send")
    public Observable<Response<ResponseBody>> broadcastMessage(@Path(value="conferenceId") String var1, @Body BroadcastEvent var2);

    @POST(value="v1/conferences/{conferenceId}/join")
    public Observable<ResumeConference> joinConference(@Path(value="conferenceId") String var1, @Body DeviceEvent var2);

    @POST(value="v1/conferences/{conferenceId}/leave")
    public Observable<Response<ResponseBody>> leaveConference(@Path(value="conferenceId") String var1);

    @POST(value="v1/conferences/{conferenceId}/answer/{user_id}")
    public Observable<Response<ResponseBody>> answerConference(@Path(value="conferenceId") String var1, @Path(value="user_id") String var2, @Body SdpDescription var3);

    @POST(value="v1/conferences/{conferenceId}/invite")
    public Observable<Response<ResponseBody>> invite(@Path(value="conferenceId") String var1, @Body SdkConferenceInvitation var2);

    @POST(value="v1/oauth2/token")
    public Observable<TokenResponse> getToken(@Header(value="Authorization") String var1, @Body GrandTypeEvent var2);

    @POST(value="v1/users/logout")
    public Observable<Response<ResponseBody>> logout(@Header(value="Authorization") String var1);

    @GET(value="v1/conferences/{id}/video/{uid}/start")
    public Observable<StartVideoResponse> startVideo(@Path(value="id") String var1, @Path(value="uid") String var2);

    @GET(value="v1/conferences/{id}/video/{uid}/stop")
    public Observable<StopVideoResponse> stopVideo(@Path(value="id") String var1, @Path(value="uid") String var2);

    @GET(value="v1/conferences/{id}/sharing/start")
    public Observable<StartScreenSharingResponse> startScreenShare(@Path(value="id") String var1);

    @GET(value="v1/conferences/{id}/sharing/stop")
    public Observable<StopScreenSharingResponse> stopScreenShare(@Path(value="id") String var1);

    @POST(value="v1/conferences/{id}/decline")
    public Observable<Response<ResponseBody>> decline(@Path(value="id") String var1);

    @GET(value="v1/conferences/{id}/call/subscribe")
    public Observable<Response<ResponseBody>> subscribeForCall(@Path(value="id") String var1);

    @DELETE(value="v1/conferences/{id}/call/subscribe")
    public Observable<Response<ResponseBody>> unsubscribeFromCall(@Path(value="id") String var1);
}

