/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.audio.AudioRoute;
import com.voxeet.android.media.peer.PendingPeerCallback;
import com.voxeet.android.media.peer.SdpCandidate;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.video.CameraEnumerator;
import com.voxeet.kernel.R;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.VideoRenderer;
import retrofit2.Response;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import voxeet.com.sdk.audio.MessagingEnvironment;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.ConferenceSimpleState;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.core.services.AudioService;
import voxeet.com.sdk.core.services.SdkConferenceService;
import voxeet.com.sdk.core.services.TimeoutRunnable;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.events.error.CameraSwitchErrorEvent;
import voxeet.com.sdk.events.error.ConferenceCreatedError;
import voxeet.com.sdk.events.error.ConferenceJoinedError;
import voxeet.com.sdk.events.error.ConferenceLeftError;
import voxeet.com.sdk.events.error.GetConferenceHistoryErrorEvent;
import voxeet.com.sdk.events.error.GetConferenceStatusErrorEvent;
import voxeet.com.sdk.events.error.ParticipantAddedErrorEvent;
import voxeet.com.sdk.events.error.PermissionRefusedEvent;
import voxeet.com.sdk.events.error.ReplayConferenceErrorEvent;
import voxeet.com.sdk.events.error.SdkLogoutErrorEvent;
import voxeet.com.sdk.events.error.SubscribeConferenceErrorEvent;
import voxeet.com.sdk.events.error.SubscribeForCallConferenceErrorEvent;
import voxeet.com.sdk.events.error.UnsubscribeFromCallConferenceErrorEvent;
import voxeet.com.sdk.events.promises.InConferenceException;
import voxeet.com.sdk.events.promises.NotInConferenceException;
import voxeet.com.sdk.events.promises.PromiseConferenceJoinedErrorException;
import voxeet.com.sdk.events.promises.PromiseDeclineConferenceResultEventException;
import voxeet.com.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import voxeet.com.sdk.events.promises.PromiseParticipantAddedErrorEventException;
import voxeet.com.sdk.events.promises.PromisePermissionRefusedEventException;
import voxeet.com.sdk.events.success.AddConferenceParticipantResultEvent;
import voxeet.com.sdk.events.success.CameraSwitchSuccessEvent;
import voxeet.com.sdk.events.success.ConferenceCreationSuccess;
import voxeet.com.sdk.events.success.ConferenceDestroyedPushEvent;
import voxeet.com.sdk.events.success.ConferenceEndedEvent;
import voxeet.com.sdk.events.success.ConferenceJoinedSuccessEvent;
import voxeet.com.sdk.events.success.ConferenceLeftSuccessEvent;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.events.success.ConferenceRefreshedEvent;
import voxeet.com.sdk.events.success.ConferenceStatsEvent;
import voxeet.com.sdk.events.success.ConferenceUserAddedEvent;
import voxeet.com.sdk.events.success.ConferenceUserCallDeclinedEvent;
import voxeet.com.sdk.events.success.ConferenceUserJoinedEvent;
import voxeet.com.sdk.events.success.ConferenceUserLeftEvent;
import voxeet.com.sdk.events.success.ConferenceUserQualityUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUserUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUsersInvitedEvent;
import voxeet.com.sdk.events.success.DeclineConferenceResultEvent;
import voxeet.com.sdk.events.success.GetConferenceHistoryEvent;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.InvitationReceived;
import voxeet.com.sdk.events.success.OfferCreatedEvent;
import voxeet.com.sdk.events.success.OwnConferenceStartedEvent;
import voxeet.com.sdk.events.success.ParticipantAddedEvent;
import voxeet.com.sdk.events.success.ParticipantUpdatedEvent;
import voxeet.com.sdk.events.success.QualityIndicators;
import voxeet.com.sdk.events.success.QualityUpdatedEvent;
import voxeet.com.sdk.events.success.RecordingStatusUpdate;
import voxeet.com.sdk.events.success.RenegociationEndedEvent;
import voxeet.com.sdk.events.success.RenegociationUpdate;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.events.success.ScreenStreamAddedEvent;
import voxeet.com.sdk.events.success.ScreenStreamRemovedEvent;
import voxeet.com.sdk.events.success.SdkLogoutSuccessEvent;
import voxeet.com.sdk.events.success.SendBroadcastResultEvent;
import voxeet.com.sdk.events.success.StartRecordingResultEvent;
import voxeet.com.sdk.events.success.StartScreenShareAnswerEvent;
import voxeet.com.sdk.events.success.StartVideoAnswerEvent;
import voxeet.com.sdk.events.success.StopRecordingResultEvent;
import voxeet.com.sdk.events.success.StopScreenShareAnswerEvent;
import voxeet.com.sdk.events.success.StopVideoAnswerEvent;
import voxeet.com.sdk.events.success.SubscribeConferenceEvent;
import voxeet.com.sdk.events.success.SubscribeForCallConferenceAnswerEvent;
import voxeet.com.sdk.events.success.UnSubscribeConferenceAnswerEvent;
import voxeet.com.sdk.events.success.UnSubscribeFromConferenceAnswerEvent;
import voxeet.com.sdk.factories.VoxeetIntentFactory;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.ConferenceStats;
import voxeet.com.sdk.json.ConferenceUserAdded;
import voxeet.com.sdk.json.CreateConferenceParams;
import voxeet.com.sdk.json.DeviceEvent;
import voxeet.com.sdk.json.InvitationReceivedEvent;
import voxeet.com.sdk.json.OfferCreated;
import voxeet.com.sdk.json.RecordingStatusUpdateEvent;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartScreenSharingResponse;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopScreenSharingResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.ConferenceQuality;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.ConferenceType;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.NormalConferenceResponse;
import voxeet.com.sdk.models.OfferCandidate;
import voxeet.com.sdk.models.OfferDescription;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.SubscribeConference;
import voxeet.com.sdk.models.abs.ConferenceUser;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultInvitation;
import voxeet.com.sdk.models.impl.DefaultParticipant;
import voxeet.com.sdk.networking.DeviceType;
import voxeet.com.sdk.utils.ConferenceListener;
import voxeet.com.sdk.utils.Twig;
import voxeet.com.sdk.utils.Validate;

public abstract class AbstractConferenceSdkService<T, COP extends AbstractConferenceSdkObservableProvider<T, DemoEvent>, DemoEvent>
extends AbstractVoxeetService<T>
implements SdkConferenceService,
ConferenceListener {
    private static final String TAG = AbstractConferenceSdkService.class.getSimpleName();
    private VoxeetSdkTemplate mSDK;
    private ConferenceListener mListener;
    private AbstractConferenceSdkObservableProvider mConferenceObservableProvider;
    private Twig mTwig;
    private DefaultConference mConference;
    private String mConferenceId = null;
    private String mConferenceAlias = null;
    private EventBus mEventBus;
    private MediaSDK media;
    private EglBase mEglBase = EglBase.create();
    private final MessagingEnvironment mEnvironment;
    private boolean isListenerMode = false;
    private boolean isVideoOn = false;
    private boolean isScreenshareOn = false;
    private boolean isRecording = false;
    private boolean mInConference = false;
    private long mTimeOutTimer = -1L;
    protected Context mContext;
    private ConferenceSimpleState mConferenceType;
    @Nullable
    private TimeoutRunnable timeoutRunnable = null;
    private MediaEngine.StreamListener mediaStreamListener = new MediaEngine.StreamListener(){

        public void onStreamAdded(final String peer, final MediaStream stream) {
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.getTwig().i("New mConference user joined with id: " + peer + " checking... (ours is " + VoxeetPreferences.id(), new Object[0]);
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.updateConferenceParticipants(peer, ConferenceUserStatus.ON_AIR);
                    if (user != null) {
                        AbstractConferenceSdkService.this.getTwig().i("New mConference user joined with id: " + user.getUserId(), new Object[0]);
                        if (!peer.equalsIgnoreCase(VoxeetPreferences.id()) && AbstractConferenceSdkService.this.mTimeOutTimer != -1L) {
                            AbstractConferenceSdkService.this.mTwig.i("Cancelling timeout timer", new Object[0]);
                            AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
                    }
                }
            });
        }

        public void onStreamUpdated(final String peer, final MediaStream stream) {
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.getTwig().i("Conference user updated with id: " + peer + " checking... (ours is " + VoxeetPreferences.id(), new Object[0]);
                    AbstractConferenceSdkService.this.getTwig().i("stream updated having video ? " + (stream.videoTracks().size() > 0), new Object[0]);
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.findUserById(peer);
                    if (user != null) {
                        AbstractConferenceSdkService.this.getTwig().i("Conference user updated with id: " + user.getUserId(), new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                    }
                }
            });
        }

        public void onStreamRemoved(final String peer) {
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.onUserLeft(peer);
                }
            });
        }

        public void onScreenStreamAdded(String peer, MediaStream stream) {
            AbstractConferenceSdkService.this.getTwig().i("Screen share stream added: " + peer, new Object[0]);
            AbstractConferenceSdkService.this.mEventBus.post((Object)new ScreenStreamAddedEvent(peer, stream));
        }

        public void onScreenStreamRemoved(String peer) {
            AbstractConferenceSdkService.this.getTwig().i("Screen share stream removed: " + peer, new Object[0]);
            AbstractConferenceSdkService.this.mEventBus.post((Object)new ScreenStreamRemovedEvent(peer));
        }

        public void onShutdown() {
        }
    };
    private String mDefaultCamera;
    private Map<String, String> mCacheUserIds = new HashMap<String, String>();
    private ArrayList<DefaultConferenceUser> mLastInvitationReceived;
    private boolean mEnableStats = false;
    private boolean isDefaultOnSpeaker;

    public AbstractConferenceSdkService(VoxeetSdkTemplate instance, COP conference_observable_provider, long timeout, @NonNull ServiceProviderHolder<T> holder) {
        super(instance, holder);
        this.mDefaultCamera = new CameraEnumerator(instance.getApplicationContext()).getNameOfFrontFacingDevice();
        this.mConferenceObservableProvider = conference_observable_provider;
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider(this.getService());
        this.mListener = instance;
        this.mSDK = instance;
        this.mTimeOutTimer = timeout;
        this.mTwig = instance.getTwig();
        this.mEventBus = EventBus.getDefault();
        this.mContext = instance.getApplicationContext();
        this.setDefaultBuiltInSpeaker(true);
        this.mEnvironment = new MessagingEnvironment.Builder(this.mContext).setServerHost(R.string.session_manager_url).setServerPort(R.string.connectionManagerPort).setStunHost(R.string.stunHost).setStunPort(R.string.stunPort).build();
        this.register();
    }

    @Deprecated
    public boolean muteConference(boolean mute) {
        return this.mute(mute);
    }

    @Override
    public boolean mute(boolean mute) {
        if (null != this.media) {
            if (!mute && this.media.isMuted()) {
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getTwig().i("No permission for mic... please check it", new Object[0]);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                this.getTwig().i("Conference unmuted", new Object[0]);
                this.media.unMute();
            } else if (mute) {
                this.getTwig().i("Conference muted", new Object[0]);
                this.media.mute();
            }
        }
        return true;
    }

    @Override
    public boolean isMuted() {
        return this.media != null && this.media.isMuted();
    }

    @Override
    public boolean isUserMuted(String userId) {
        DefaultConferenceUser user = this.findUserById(userId);
        return user != null && user.isMuted();
    }

    @Override
    public void setListenerMode(boolean isListener) {
        if (null != this.media) {
            if (this.media.isMuted()) {
                this.media.unMute();
            } else {
                this.media.mute();
            }
        }
    }

    @Override
    public boolean attachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (this.media != null) {
            this.media.attachMediaStream(render, stream);
        }
        return null != this.media;
    }

    @Override
    public boolean unAttachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (this.media != null) {
            this.media.unattachMediaStream(render, stream);
        }
        return null != this.media;
    }

    @Override
    public void register() {
        this.registerEventBus();
    }

    @Override
    public void unregister() {
        this.unRegisterEventBus();
    }

    public void setDefaultCamera(String cameraName) {
        this.mDefaultCamera = cameraName;
    }

    @Override
    public void toggleVideo() {
        Promise<Boolean> promise = this.isVideoOn() ? this.stopVideo() : this.startVideo();
        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggleVideo " + result));
            }
        }).error(new ErrorPromise(){

            public void onError(Throwable error) {
                error.printStackTrace();
            }
        });
    }

    public void toggleScreenShare() {
        if (this.isScreenShareOn()) {
            this.stopScreenShare().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onSuccess: toggleScreenShare " + result));
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    Log.d((String)TAG, (String)"onError: toggleScreenShare");
                    error.printStackTrace();
                }
            });
        } else {
            this.getVoxeetSDK().getScreenShareService().sendRequestStartScreenShare();
        }
    }

    @Override
    public String getCurrentConferenceId() {
        Validate.runningOnUiThread();
        return this.mConference != null && this.mConference.getConferenceId() != null ? this.mConference.getConferenceId() : this.mConferenceId;
    }

    @Override
    public int getConferenceRoomSize() {
        return this.mConference != null ? this.mConference.getConferenceRoomSize() : 0;
    }

    @Override
    public String currentSpeaker() {
        if (this.media == null || this.mConference == null || this.mConference.getConferenceUsers() == null) {
            return VoxeetPreferences.id();
        }
        String currentSpeaker = null;
        for (DefaultConferenceUser user : this.mConference.getConferenceUsers()) {
            if (user.getUserId() == null) continue;
            int peerVuMeter = this.media.getPeerVuMeter(user.getUserId());
            if (currentSpeaker != null && (peerVuMeter <= 100 || this.media.getPeerVuMeter(currentSpeaker) >= peerVuMeter)) continue;
            currentSpeaker = user.getUserId();
        }
        return currentSpeaker;
    }

    @NonNull
    private String currentUserOrEmpty() {
        String currentUserId = VoxeetPreferences.id();
        return null != currentUserId ? currentUserId : "";
    }

    @Override
    public int getSdkPeerVuMeter(String peerId) {
        Validate.runningOnUiThread();
        return this.media != null ? this.media.getPeerVuMeter(peerId) : 0;
    }

    public DefaultConferenceUser findUserById(final String userId) {
        Log.d((String)TAG, (String)("findUserById: looking for USER " + userId));
        Validate.notNull(userId, "user id");
        if (this.mConference != null && this.mConference.getConferenceUsers() != null) {
            DefaultConferenceUser user = (DefaultConferenceUser)Iterables.find((Iterable)this.mConference.getConferenceUsers(), (Predicate)new Predicate<DefaultConferenceUser>(){

                public boolean apply(DefaultConferenceUser input) {
                    return userId.equalsIgnoreCase(input.getUserId());
                }
            }, null);
            Log.d((String)TAG, (String)("findUserById: looking for USER " + userId + " found ? " + user));
            return user;
        }
        return null;
    }

    @Override
    public String getAliasId() {
        return this.mConferenceAlias;
    }

    @Override
    public String getConferenceId() {
        return this.mConferenceId;
    }

    @Deprecated
    public List<AudioRoute> getAvailableRoutes() {
        return this.getAudioService().getAvailableRoutes();
    }

    @Deprecated
    public AudioRoute currentRoute() {
        return this.getAudioService().currentRoute();
    }

    @Override
    public EglBase.Context getEglContext() {
        return this.mEglBase.getEglBaseContext();
    }

    @Override
    public long getTimeout() {
        return this.mTimeOutTimer;
    }

    @Override
    public void toggleRecording() {
        Promise<Boolean> promise = this.isRecording ? this.stopRecording() : this.startRecording();
        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggle done " + result));
            }
        }).error(new ErrorPromise(){

            public void onError(Throwable error) {
                error.printStackTrace();
            }
        });
    }

    @Override
    public boolean muteUser(@NonNull String userId, boolean shouldMute) {
        Validate.runningOnUiThread();
        DefaultConferenceUser user = this.findUserById(userId);
        if (user != null) {
            this.getTwig().i("Setting mute property for mConference participant with id " + userId + " to " + shouldMute, new Object[0]);
            this.startTransactionConferenceUser();
            user.setMuted(shouldMute);
            this.media.changePeerGain(userId, shouldMute ? 10000.0f : 1.0f);
            this.commitTransactionConferenceUser();
        }
        return user != null;
    }

    public boolean isVideoOn() {
        return this.isVideoOn;
    }

    public boolean isScreenShareOn() {
        return this.isScreenshareOn;
    }

    @Deprecated
    public boolean setAudioRoute(AudioRoute route) {
        return this.getAudioService().setAudioRoute(route);
    }

    public boolean setDefaultBuiltInSpeaker(boolean default_state) {
        this.isDefaultOnSpeaker = default_state;
        return true;
    }

    @Override
    public boolean setTimeOut(long timeout) {
        this.getTwig().i("Timeout set to " + timeout, new Object[0]);
        this.mTimeOutTimer = timeout;
        return true;
    }

    @Override
    public boolean setUserPosition(String userId, double angle, double distance) {
        if (this.media != null) {
            this.media.changePeerPosition(userId, angle, distance);
        }
        return null != this.media;
    }

    @NonNull
    public ConferenceSimpleState getConferenceType() {
        if (null == this.getConference() || null == this.mConferenceType) {
            return ConferenceSimpleState.NONE;
        }
        return this.mConferenceType;
    }

    @Nullable
    public DefaultConference getConference() {
        return this.mConference;
    }

    public boolean isInConference() {
        return this.mInConference;
    }

    protected void setIsInConference(boolean status) {
        this.mInConference = status;
    }

    public int getPeerVuMeter(String peerId) {
        Validate.runningOnUiThread();
        if (this.media != null) {
            return this.media.getPeerVuMeter(peerId);
        }
        return 0;
    }

    @Override
    @Nullable
    public List<DefaultConferenceUser> getConferenceUsers() {
        return this.mConference.getConferenceUsers();
    }

    @NonNull
    public List<DefaultConferenceUser> getLastInvitationUsers() {
        return this.mLastInvitationReceived;
    }

    @Override
    public boolean isLive() {
        return this.mConference != null;
    }

    @Override
    public boolean isListenerMode() {
        return this.isListenerMode;
    }

    @Nullable
    public ConferenceUser getUser(final String userId) {
        if (this.mConference != null && this.mConference.getConferenceUsers() != null) {
            return (ConferenceUser)Iterables.find((Iterable)this.mConference.getConferenceUsers(), (Predicate)new Predicate<ConferenceUser>(){

                public boolean apply(ConferenceUser input) {
                    return userId.equals(input.getUserId());
                }
            }, null);
        }
        return null;
    }

    @NonNull
    public HashMap<String, MediaStream> getMapOfStreams() {
        return new HashMap<String, MediaStream>();
    }

    public AbstractConferenceSdkService<T, COP, DemoEvent> cancelTimeout() {
        this.removeTimeoutCallbacks();
        return this;
    }

    protected abstract Promise<Boolean> onCreateDemoSuccess(DemoEvent var1);

    @Override
    public Promise<Boolean> listenConference(String conferenceId) {
        this.isListenerMode = true;
        this.getTwig().i("Listener mode set to true", new Object[0]);
        return this.joinVoxeetConference(conferenceId);
    }

    @Override
    public Promise<DeclineConferenceResultEvent> decline(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<DeclineConferenceResultEvent>(){

            public void onCall(final @NonNull Solver<DeclineConferenceResultEvent> solver) {
                Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getDeclineObservable(conferenceId);
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e(e);
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(AbstractConferenceSdkService.this.handleError(e), false);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        solver.reject((Throwable)new PromiseDeclineConferenceResultEventException(event));
                    }

                    public void onNext(Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().i("IConference declined with id: " + conferenceId, new Object[0]);
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(response.code() == 200);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        solver.resolve((Object)event);
                    }
                });
            }
        });
    }

    public void sendRequestStartScreenShare() {
        this.getVoxeetSDK().getScreenShareService().sendRequestStartScreenShare();
    }

    public void onUserCanceledScreenShare() {
        this.media.stopScreenCapturer();
        this.isScreenshareOn = false;
    }

    public Promise<Boolean> startScreenShare(final Intent intent) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    if (AbstractConferenceSdkService.this.isScreenShareOn()) {
                        solver.resolve((Object)true);
                    }
                    if (null == AbstractConferenceSdkService.this.media) {
                        Log.d((String)TAG, (String)"startScreenShare: media is null");
                        throw new MediaEngineException("Media is null, invalid state");
                    }
                    AbstractConferenceSdkService.this.isScreenshareOn = true;
                    AbstractConferenceSdkService.this.media.startScreenCapturer(intent);
                    Observable<StartScreenSharingResponse> startScreenShare = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStartScreenShareObservable(AbstractConferenceSdkService.this.mConferenceId, VoxeetPreferences.id());
                    startScreenShare.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<StartScreenSharingResponse>(){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            AbstractConferenceSdkService.this.mTwig.e(e);
                            AbstractConferenceSdkService.this.isScreenshareOn = false;
                            StartScreenShareAnswerEvent event = new StartScreenShareAnswerEvent(false);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            solver.reject(e);
                        }

                        public void onNext(StartScreenSharingResponse response) {
                            AbstractConferenceSdkService.this.isScreenshareOn = true;
                            StartScreenShareAnswerEvent event = new StartScreenShareAnswerEvent(true);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            AbstractConferenceSdkService.this.createVideoAnswer(response.getUserId(), response.getDescription(), response.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onCall: createVideoAnswer := having result " + aBoolean));
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Promise<Boolean> stopScreenShare() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    String conferenceId = AbstractConferenceSdkService.this.getCurrentConferenceId();
                    if (!AbstractConferenceSdkService.this.isInConference()) {
                        Log.d((String)TAG, (String)"stopScreenShare: not in conf");
                        if (null != AbstractConferenceSdkService.this.media) {
                            AbstractConferenceSdkService.this.media.stopScreenCapturer();
                        }
                        throw new NotInConferenceException();
                    }
                    if (null == AbstractConferenceSdkService.this.media) {
                        Log.d((String)TAG, (String)"stopScreenShare: media is null");
                        throw new MediaEngineException("media is null");
                    }
                    AbstractConferenceSdkService.this.media.stopScreenCapturer();
                    Observable<StopScreenSharingResponse> stopVideo = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStopScreenShareObservable(conferenceId, VoxeetPreferences.id());
                    stopVideo.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<StopScreenSharingResponse>(){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            AbstractConferenceSdkService.this.getTwig().e(e);
                            AbstractConferenceSdkService.this.isScreenshareOn = false;
                            StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(false);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            solver.reject(e);
                        }

                        public void onNext(StopScreenSharingResponse response) {
                            AbstractConferenceSdkService.this.media.stopScreenCapturer();
                            AbstractConferenceSdkService.this.isScreenshareOn = false;
                            StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(true);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            AbstractConferenceSdkService.this.createVideoAnswer(response.getUserId(), response.getDescription(), response.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }
                    });
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (Exception exception) {
                    solver.reject((Throwable)exception);
                }
            }
        });
    }

    public Promise<Boolean> startVideo() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    if (!Validate.hasCameraPermissions(AbstractConferenceSdkService.this.mContext)) {
                        PermissionRefusedEvent event = new PermissionRefusedEvent(PermissionRefusedEvent.Permission.CAMERA);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        throw new PromisePermissionRefusedEventException(event);
                    }
                    if (null == AbstractConferenceSdkService.this.media) {
                        Log.d((String)TAG, (String)"startVideo: media is null");
                        throw new MediaEngineException("Media is null, invalid state");
                    }
                    if (AbstractConferenceSdkService.this.isVideoOn()) {
                        Log.d((String)"SDKMEDIA", (String)"startVideo: already started... please wait if you wanted to stop");
                        solver.resolve((Object)true);
                        return;
                    }
                    AbstractConferenceSdkService.this.media.startVideo(AbstractConferenceSdkService.this.mDefaultCamera);
                    Observable<StartVideoResponse> startVideo = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStartVideoObservable(AbstractConferenceSdkService.this.mConferenceId, VoxeetPreferences.id());
                    startVideo.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<StartVideoResponse>(){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            AbstractConferenceSdkService.this.mTwig.e(e);
                            AbstractConferenceSdkService.this.isVideoOn = false;
                            StartVideoAnswerEvent event = new StartVideoAnswerEvent(false);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            solver.reject(e);
                        }

                        public void onNext(StartVideoResponse response) {
                            AbstractConferenceSdkService.this.isVideoOn = true;
                            StartVideoAnswerEvent event = new StartVideoAnswerEvent(true);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            AbstractConferenceSdkService.this.createVideoAnswer(response.getUserId(), response.getDescription(), response.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }
                    });
                }
                catch (PromisePermissionRefusedEventException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (Exception exception) {
                    solver.reject((Throwable)exception);
                }
            }
        });
    }

    public Promise<Boolean> stopVideo() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    String conferenceId = AbstractConferenceSdkService.this.getCurrentConferenceId();
                    if (!AbstractConferenceSdkService.this.isInConference()) {
                        Log.d((String)TAG, (String)"stopVideo: not in conf");
                        if (null != AbstractConferenceSdkService.this.media) {
                            AbstractConferenceSdkService.this.media.stopVideo();
                        }
                        throw new NotInConferenceException();
                    }
                    if (null == AbstractConferenceSdkService.this.media) {
                        Log.d((String)TAG, (String)"startVideo: media is null");
                        throw new MediaEngineException("media is null");
                    }
                    AbstractConferenceSdkService.this.media.stopVideo();
                    Observable<StopVideoResponse> stopVideo = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStopVideoObservable(conferenceId, VoxeetPreferences.id());
                    stopVideo.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<StopVideoResponse>(){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            AbstractConferenceSdkService.this.getTwig().e(e);
                            StopVideoAnswerEvent event = new StopVideoAnswerEvent(false);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            solver.reject(e);
                        }

                        public void onNext(StopVideoResponse response) {
                            AbstractConferenceSdkService.this.media.stopVideo();
                            AbstractConferenceSdkService.this.isVideoOn = false;
                            StopVideoAnswerEvent event = new StopVideoAnswerEvent(true);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            AbstractConferenceSdkService.this.createVideoAnswer(response.getUserId(), response.getDescription(), response.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }
                    });
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (Exception exception) {
                    solver.reject((Throwable)exception);
                }
            }
        });
    }

    private Promise<Boolean> createVideoAnswer(final String userId, final OfferDescription offerDescription, final List<OfferCandidate> offerCandidates) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)("createVideoAnswer: " + userId + " " + offerDescription.getSdp() + " " + offerDescription.getType()));
                Log.d((String)"SDKMEDIA", (String)("createVideoAnswer: " + userId + " " + offerDescription.getSdp() + " " + offerDescription.getType()));
                try {
                    if (null == AbstractConferenceSdkService.this.media) {
                        throw new MediaEngineException("media is null");
                    }
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                SdpDescription description = new SdpDescription(offerDescription.getType(), offerDescription.getSdp());
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                if (offerCandidates != null) {
                    for (OfferCandidate candidate : offerCandidates) {
                        candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                    }
                }
                try {
                    AbstractConferenceSdkService.this.media.createAnswerForPeer(userId, description.getSsrc(), description, candidates, VoxeetPreferences.id().equalsIgnoreCase(userId), new PendingPeerCallback(){

                        public void onMessage(@Nullable SdpMessage message) {
                            Log.d((String)TAG, (String)("onMessage: having a message " + message));
                            AbstractConferenceSdkService.this.answer(userId, message).then((PromiseExec)new PromiseExec<Integer, Object>(){

                                public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onSuccess: " + result));
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    if (error instanceof PromiseParticipantAddedErrorEventException) {
                                        AbstractConferenceSdkService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                    } else {
                                        error.printStackTrace();
                                    }
                                    solver.resolve((Object)false);
                                }
                            });
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }

    @Override
    public Promise<Boolean> create() {
        return this.join(null);
    }

    @Override
    public Promise<Boolean> join(final @Nullable String alias) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.mConferenceType = ConferenceSimpleState.CONFERENCE;
                AbstractConferenceSdkService.this.getTwig().i("Attempting to create mConference " + alias, new Object[0]);
                CreateConferenceParams params = new CreateConferenceParams().setStats(AbstractConferenceSdkService.this.mEnableStats).setAlias(alias);
                Observable<ConferenceResponse> observable = AbstractConferenceSdkService.this.mConferenceObservableProvider.getCreateConferenceObservable(params);
                observable.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<ConferenceResponse>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.mTwig.e(e);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreatedError(AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }

                    public void onNext(ConferenceResponse response) {
                        Log.d((String)TAG, (String)("onNext: join with := " + response.getConfId() + " " + response.getConfAlias()));
                        solver.resolve(AbstractConferenceSdkService.this.onConferenceCreated(response.getConfId(), response.getConfAlias(), null));
                    }
                });
            }
        });
    }

    protected Promise<ResumeConference> extendedJoin(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<ResumeConference>(){

            public void onCall(final @NonNull Solver<ResumeConference> solver) {
                Observable<ResumeConference> observable = AbstractConferenceSdkService.this.mConferenceObservableProvider.joinConference(conferenceId, new DeviceEvent(DeviceType.ANDROID, AbstractConferenceSdkService.this.isListenerMode()));
                observable.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<ResumeConference>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        solver.reject(e);
                    }

                    public void onNext(ResumeConference resumeConference) {
                        solver.resolve((Object)resumeConference);
                    }
                });
            }
        });
    }

    protected Promise<Boolean> onConferenceCreated(final @NonNull String conferenceId, final @NonNull String conferenceAlias, @Nullable NormalConferenceResponse other) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.mConference = AbstractConferenceSdkService.this.createConference();
                AbstractConferenceSdkService.this.mConferenceId = conferenceId;
                AbstractConferenceSdkService.this.mConferenceAlias = conferenceAlias;
                AbstractConferenceSdkService.this.mConference.setConferenceId(AbstractConferenceSdkService.this.mConferenceId);
                AbstractConferenceSdkService.this.mConference.setConferenceAlias(AbstractConferenceSdkService.this.mConferenceAlias);
                AbstractConferenceSdkService.this.getTwig().i("IConference created with id: " + AbstractConferenceSdkService.this.mConferenceId + " " + AbstractConferenceSdkService.this.mConferenceAlias, new Object[0]);
                AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreationSuccess(conferenceId, conferenceAlias));
                AbstractConferenceSdkService.this.joinVoxeetConference(conferenceId).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> demo() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.mConferenceType = ConferenceSimpleState.CONFERENCE;
                AbstractConferenceSdkService.this.getTwig().i("Attempting to create demo mConference", new Object[0]);
                Observable user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getCreateDemoObservable();
                user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<DemoEvent>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e(e);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreatedError(AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }

                    public void onNext(DemoEvent response) {
                        AbstractConferenceSdkService.this.onCreateDemoSuccess(response).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                            public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                solver.resolve((Object)true);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(Throwable error) {
                                solver.reject(error);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @NonNull
    public Promise<List<ConferenceRefreshedEvent>> invite(final List<String> ids) {
        return new Promise((PromiseSolver)new PromiseSolver<List<ConferenceRefreshedEvent>>(){

            public void onCall(final @NonNull Solver<List<ConferenceRefreshedEvent>> solver) {
                AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                AbstractConferenceSdkService.this.sendTimeoutCallbacks();
                boolean sdk = AbstractConferenceSdkService.this.isSDK();
                ArrayList<String> voxeetIds = sdk ? null : new ArrayList<String>();
                final ArrayList<String> externalIds = new ArrayList<String>();
                externalIds.addAll(ids);
                if (!sdk) {
                    voxeetIds.addAll(ids);
                }
                Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getInviteObservable(AbstractConferenceSdkService.this.mConferenceId, new SdkConferenceInvitation(voxeetIds, externalIds));
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e(e);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new AddConferenceParticipantResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.reject(e);
                    }

                    public void onNext(Response<ResponseBody> response) {
                        ArrayList<ConferenceRefreshedEvent> list = new ArrayList<ConferenceRefreshedEvent>();
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new AddConferenceParticipantResultEvent(response.code() == 200));
                        try {
                            String body = ((ResponseBody)response.body()).string();
                            Log.d((String)TAG, (String)("onNext: " + body));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (response.code() == 200) {
                            for (String userId : externalIds) {
                                if (userId.equals(VoxeetPreferences.id())) continue;
                                AbstractConferenceSdkService.this.getTwig().i("Conference participant with id: " + userId + " invited", new Object[0]);
                                ConferenceRefreshedEvent event = new ConferenceRefreshedEvent(userId, AbstractConferenceSdkService.this.updateConferenceParticipants(userId, ConferenceUserStatus.IN_PROGRESS));
                                AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                                list.add(event);
                            }
                        }
                        solver.resolve(list);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> logout() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                if (null != VoxeetPreferences.id()) {
                    AbstractConferenceSdkService.this.mTwig.i("Attempting to logout", new Object[0]);
                    Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getLogOutObservable(VoxeetPreferences.token());
                    user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            AbstractConferenceSdkService.this.getTwig().e(e);
                            String message = "Logout failed";
                            AbstractConferenceSdkService.this.getTwig().e(message, new Object[0]);
                            VoxeetPreferences.onLogout();
                            AbstractConferenceSdkService.this.getVoxeetSDK().closeSocket();
                            AbstractConferenceSdkService.this.mEventBus.post((Object)new SdkLogoutErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                            solver.reject(e);
                        }

                        public void onNext(Response<ResponseBody> response) {
                            if (response.code() == 200) {
                                String message = "Logout success";
                                AbstractConferenceSdkService.this.getTwig().i(message, new Object[0]);
                                VoxeetPreferences.onLogout();
                                AbstractConferenceSdkService.this.getVoxeetSDK().closeSocket();
                                AbstractConferenceSdkService.this.mEventBus.post((Object)new SdkLogoutSuccessEvent(message));
                                solver.resolve((Object)true);
                            } else {
                                String message = "Logout failed";
                                AbstractConferenceSdkService.this.getTwig().e(message, new Object[0]);
                                VoxeetPreferences.onLogout();
                                AbstractConferenceSdkService.this.getVoxeetSDK().closeSocket();
                                AbstractConferenceSdkService.this.mEventBus.post((Object)new SdkLogoutErrorEvent(message));
                                solver.resolve((Object)false);
                            }
                        }
                    });
                } else {
                    String message = "Already logged out";
                    AbstractConferenceSdkService.this.getTwig().e("Already logged out", new Object[0]);
                    AbstractConferenceSdkService.this.mEventBus.post((Object)new SdkLogoutSuccessEvent("Already logged out"));
                    solver.resolve((Object)true);
                }
            }
        });
    }

    @Override
    public Promise<Boolean> replay(final String conferenceId, final long offset) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.mConferenceType = ConferenceSimpleState.REPLAY;
                AbstractConferenceSdkService.this.isListenerMode = true;
                AbstractConferenceSdkService.this.setListenerMode(false);
                Observable<ReplayConferenceEvent> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getReplayObservable(conferenceId, new SdkConferenceReplayBody(offset));
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<ReplayConferenceEvent>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to replay mConference", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ReplayConferenceErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                        e.printStackTrace();
                        solver.resolve((Object)false);
                    }

                    public void onNext(ReplayConferenceEvent response) {
                        AbstractConferenceSdkService.this.getTwig().i("Success server answer for replaying mConference with id: " + conferenceId + "at offset: " + offset, new Object[0]);
                        AbstractConferenceSdkService.this.joinVoxeetConference(response.getConferenceId()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                                solver.resolve((Object)result);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(Throwable error) {
                                error.printStackTrace();
                                solver.resolve((Object)false);
                            }
                        });
                    }
                });
            }
        });
    }

    public Promise<Boolean> startRecording() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull(AbstractConferenceSdkService.this.mConferenceId, "mConference Id");
                Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStartRecordingObservable(AbstractConferenceSdkService.this.mConferenceId);
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to start mConference recording", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new StartRecordingResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.reject(e);
                    }

                    public void onNext(Response<ResponseBody> response) {
                        if (response.code() == 200) {
                            AbstractConferenceSdkService.this.getTwig().i("IConference recording started ", new Object[0]);
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new StartRecordingResultEvent(response.code() == 200));
                        try {
                            Log.d((String)TAG, (String)("onNext: " + ((ResponseBody)response.body()).string()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        solver.resolve((Object)(response.code() == 200 ? 1 : 0));
                    }
                });
            }
        });
    }

    public Promise<Boolean> stopRecording() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull(AbstractConferenceSdkService.this.mConferenceId, "mConference Id");
                Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStopRecordingObservable(AbstractConferenceSdkService.this.mConferenceId);
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to cancel mConference recording", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new StopRecordingResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.reject(e);
                    }

                    public void onNext(Response<ResponseBody> response) {
                        if (response.code() == 200) {
                            AbstractConferenceSdkService.this.getTwig().i("Conference recording stopped", new Object[0]);
                        }
                        try {
                            Log.d((String)TAG, (String)("onNext: " + ((ResponseBody)response.body()).string()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new StopRecordingResultEvent(response.code() == 200));
                        solver.resolve((Object)(response.code() == 200 ? 1 : 0));
                    }
                });
            }
        });
    }

    @Override
    public Promise<GetConferenceStatusEvent> getConferenceStatus(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<GetConferenceStatusEvent>(){

            public void onCall(final @NonNull Solver<GetConferenceStatusEvent> solver) {
                Observable<GetConferenceStatusEvent> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getConferenceStatusObservable(conferenceId);
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<GetConferenceStatusEvent>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Error while getting mConference history", new Object[0]);
                        try {
                            GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(AbstractConferenceSdkService.this.handleError(e));
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            throw new PromiseGetConferenceStatusErrorEventException(event, e);
                        }
                        catch (PromiseGetConferenceStatusErrorEventException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }

                    public void onNext(GetConferenceStatusEvent response) {
                        for (DefaultConferenceUser conferenceUser : response.getConferenceUsers()) {
                            AbstractConferenceSdkService.this.getTwig().e(conferenceUser.getUserId() + " / " + conferenceUser.getStatus(), new Object[0]);
                        }
                        AbstractConferenceSdkService.this.getTwig().i("Dispatching mConference status result", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)response);
                        solver.resolve((Object)response);
                    }
                });
            }
        });
    }

    @Override
    public Promise<GetConferenceHistoryEvent> conferenceHistory(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<GetConferenceHistoryEvent>(){

            public void onCall(final @NonNull Solver<GetConferenceHistoryEvent> solver) {
                Observable<List<HistoryConference>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getConferenceHistoryObservable(conferenceId);
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<List<HistoryConference>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Error while retrieving mConference history", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new GetConferenceHistoryErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }

                    public void onNext(List<HistoryConference> response) {
                        AbstractConferenceSdkService.this.getTwig().i("Dispatching mConference history response", new Object[0]);
                        GetConferenceHistoryEvent event = new GetConferenceHistoryEvent(response);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        solver.resolve((Object)event);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> switchCamera() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull(AbstractConferenceSdkService.this.media, "media");
                AbstractConferenceSdkService.this.media.switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                    public void onCameraSwitchDone(boolean isFrontCamera) {
                        AbstractConferenceSdkService.this.getTwig().i("Successfully switched camera", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new CameraSwitchSuccessEvent(isFrontCamera));
                        solver.resolve((Object)true);
                    }

                    public void onCameraSwitchError(String errorDescription) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to switch camera " + errorDescription, new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new CameraSwitchErrorEvent(errorDescription));
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> subscribe(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Observable<SubscribeConference> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getSubscribeObservable(conferenceId);
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<SubscribeConference>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to subscribe to this mConference's events", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SubscribeConferenceErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }

                    public void onNext(SubscribeConference response) {
                        AbstractConferenceSdkService.this.getTwig().i("You are no subscribed to this mConference's events", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SubscribeConferenceEvent(response));
                        solver.resolve((Object)true);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> unSubscribe() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.mConferenceObservableProvider.getUnSubscribeObservable(AbstractConferenceSdkService.this.mConferenceId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to unsubscribe from this mConference's events", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new UnSubscribeConferenceAnswerEvent(false, AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }

                    public void onNext(Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().i("You are no longer subscribed to this mConference's events", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new UnSubscribeConferenceAnswerEvent(response.code() == 200));
                        solver.resolve((Object)true);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> subscribeForCall(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.mConferenceObservableProvider.getSubscribeForCallObservable(conferenceId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<SubscribeConference>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to subscribe to this mConference's start", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SubscribeForCallConferenceErrorEvent(conferenceId, AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }

                    public void onNext(SubscribeConference response) {
                        AbstractConferenceSdkService.this.getTwig().i("You are no subscribed to receive events when this conf starts", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SubscribeForCallConferenceAnswerEvent(conferenceId));
                        solver.resolve((Object)true);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> unSubscribeFromCall(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getUnSubscribeFromCallObservable(conferenceId);
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to unsubscribe from this mConference's start", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new UnsubscribeFromCallConferenceErrorEvent(conferenceId, AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }

                    public void onNext(Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().i("You are no longer subscribed to this mConference's start", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new UnSubscribeFromConferenceAnswerEvent(conferenceId));
                        solver.resolve((Object)true);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> joinVoxeetConference(final @NonNull String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                if (AbstractConferenceSdkService.this.mInConference) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject((Throwable)exception);
                        return;
                    }
                }
                AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                AbstractConferenceSdkService.this.setIsInConference(true);
                AbstractConferenceSdkService.this.mConferenceId = conferenceId;
                AbstractConferenceSdkService.this.initMedia();
                Observable<ResumeConference> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.joinConference(conferenceId, new DeviceEvent(DeviceType.ANDROID, AbstractConferenceSdkService.this.isListenerMode));
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<ResumeConference>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        try {
                            e.printStackTrace();
                            AbstractConferenceSdkService.this.getTwig().e("Failed to Join mConference with id " + conferenceId, new Object[0]);
                            AbstractConferenceSdkService.this.setIsInConference(false);
                            AbstractConferenceSdkService.this.closeMedia();
                            ConferenceJoinedError error = new ConferenceJoinedError(AbstractConferenceSdkService.this.handleError(e));
                            AbstractConferenceSdkService.this.mEventBus.post((Object)error);
                            throw new PromiseConferenceJoinedErrorException(error, e);
                        }
                        catch (PromiseConferenceJoinedErrorException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }

                    public void onNext(ResumeConference response) {
                        AbstractConferenceSdkService.this.onConferenceResumedInternal(response, (Solver<Boolean>)solver);
                    }
                });
            }
        });
    }

    protected void onConferenceResumedInternal(ResumeConference response, Solver<Boolean> solver) {
        List<DefaultParticipant> participants;
        if (this.mConference == null) {
            this.mConference = this.createConference();
        }
        this.mConference.setConferenceId(response.getConferenceId());
        this.mConference.setConferenceAlias(response.getConferenceId());
        if (response.getConferenceAlias() != null) {
            this.mConferenceAlias = response.getConferenceAlias();
        }
        if (response.getConferenceId() != null) {
            this.mConferenceId = response.getConferenceId();
        }
        if (response.getConferenceAlias() != null) {
            this.mConferenceAlias = response.getConferenceAlias();
        }
        if (null != (participants = response.getParticipants())) {
            for (DefaultParticipant participant : participants) {
                this.mCacheUserIds.put(participant.getExternalId(), participant.getExternalId());
            }
        }
        this.setIsInConference(true);
        this.setAudioRoute(AudioRoute.ROUTE_PHONE);
        this.getTwig().i("Joined mConference with id " + this.getConferenceId(), new Object[0]);
        this.mEventBus.post((Object)new ConferencePreJoinedEvent(this.getConferenceId(), this.getAliasId()));
        this.mEventBus.post((Object)new ConferenceJoinedSuccessEvent(this.getConferenceId(), this.getAliasId()));
        solver.resolve((Object)true);
    }

    @Override
    public Promise<ConferenceUsersInvitedEvent> getInvitedUsers() {
        return new Promise((PromiseSolver)new PromiseSolver<ConferenceUsersInvitedEvent>(){

            public void onCall(final @NonNull Solver<ConferenceUsersInvitedEvent> solver) {
                Observable<GetConferenceStatusEvent> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getConferenceStatusObservable(AbstractConferenceSdkService.this.mConferenceId);
                user.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<GetConferenceStatusEvent>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Error while retrieving connecting users", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUsersInvitedEvent(null));
                        solver.reject(e);
                    }

                    public void onNext(GetConferenceStatusEvent response) {
                        Iterable users = Iterables.filter(response.getConferenceUsers(), (Predicate)new Predicate<DefaultConferenceUser>(){

                            public boolean apply(DefaultConferenceUser input) {
                                return input.getStatus().equalsIgnoreCase(ConferenceUserStatus.CONNECTING.toString());
                            }
                        });
                        AbstractConferenceSdkService.this.mTwig.i("Successfully retrieved connecting users", new Object[0]);
                        ConferenceUsersInvitedEvent event = new ConferenceUsersInvitedEvent(users);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        solver.resolve((Object)event);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> sendBroadcastMessage(final @NonNull String message) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    if (null == AbstractConferenceSdkService.this.mConferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                    return;
                }
                Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.broadcastMessage(AbstractConferenceSdkService.this.mConferenceId, new BroadcastEvent(message));
                user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("The broadcast message has not been sent", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SendBroadcastResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.resolve((Object)false);
                    }

                    public void onNext(Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().i("The broadcast message has been sent", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SendBroadcastResultEvent(response.code() == 200));
                        solver.resolve((Object)true);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> leave() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.getTwig().i("Attempting to leave mConference with mConference id " + AbstractConferenceSdkService.this.mConferenceId, new Object[0]);
                Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.leaveConference(AbstractConferenceSdkService.this.mConferenceId);
                user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){
                    private boolean success = false;

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                        AbstractConferenceSdkService.this.getTwig().e("Something went wrong while leaving the mConference", new Object[0]);
                        AbstractConferenceSdkService.this.closeMedia();
                        if (!this.success) {
                            AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceLeftError(AbstractConferenceSdkService.this.handleError(e)));
                        }
                        solver.resolve((Object)false);
                    }

                    public void onNext(Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                        AbstractConferenceSdkService.this.getTwig().i("Conference left successfully", new Object[0]);
                        int leftInConference = 0;
                        DefaultConference conference = AbstractConferenceSdkService.this.getConference();
                        if (conference != null) {
                            leftInConference = AbstractConferenceSdkService.this.getConference().getConferenceUsers().size() - 1;
                        }
                        AbstractConferenceSdkService.this.closeMedia();
                        if (response.code() == 200 || response.code() == 404) {
                            AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceLeftSuccessEvent(leftInConference));
                            this.success = true;
                            solver.resolve((Object)true);
                        } else {
                            AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceLeftError(response.code() + ""));
                            solver.resolve((Object)false);
                        }
                    }
                });
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceStatsEvent event) {
        ConferenceStats stats = event.getEvent();
        if (stats.getConference_id() != null && stats.getConference_id().equals(this.getConferenceId())) {
            float mos = stats.getScore(VoxeetPreferences.id());
            this.mEventBus.post((Object)new QualityIndicators(mos));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceivedEvent invitation) {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceived invitation) {
        DefaultConference conference = invitation.getEvent().getConference();
        boolean is_own_user = invitation.getEvent().getUserId().equals(VoxeetPreferences.id());
        if (!(is_own_user || is_own_user && !conference.getConferenceType().equals(ConferenceType.SCHEDULED.value()))) {
            this.getTwig().i("Invitation received from " + invitation.getEvent().getUserId(), new Object[0]);
            InvitationReceivedEvent.UserInviter inviter = invitation.getEvent().getInviter();
            List<DefaultInvitation> invitations = invitation.getEvent().getInvitations();
            this.mLastInvitationReceived = new ArrayList();
            if (null != inviter && null != inviter.externalId && null != inviter.userId) {
                this.safeUserManagementStarted();
                Log.d((String)TAG, (String)("onEvent: Invitation with inviter " + inviter.userId + " " + inviter.externalId));
                UserInfo info = this.createUserInfo(inviter.nickName, inviter.externalId, inviter.externalAvatarUrl);
                DefaultConferenceUser inviter_user = new DefaultConferenceUser(inviter.userId, "", info);
                this.mLastInvitationReceived.add(inviter_user);
                this.mCacheUserIds.put(inviter.userId, inviter.externalId);
                this.safeUserManagementEnded();
            } else {
                Log.d((String)TAG, (String)"onEvent: Invitation with invalid inviter");
            }
            this.getConferenceStatus(conference.getConferenceId()).then((PromiseExec)new PromiseExec<GetConferenceStatusEvent, Object>(){

                public void onCall(@Nullable GetConferenceStatusEvent result, @NonNull Solver<Object> internal_solver) {
                    Log.d((String)TAG, (String)("onSuccess: " + result));
                    if (!AbstractConferenceSdkService.this.isLive() && result.getConferenceUsers().size() > 0) {
                        Log.d((String)TAG, (String)("onEvent: users " + result.getConferenceUsers().size()));
                        DefaultConferenceUser foundUser = null;
                        String foundExternalId = null;
                        ArrayList<DefaultConferenceUser> merged_list = new ArrayList<DefaultConferenceUser>();
                        merged_list.addAll(result.getConferenceUsers());
                        merged_list.addAll(AbstractConferenceSdkService.this.getLastInvitationUsers());
                        Iterable list = Iterables.filter(merged_list, (Predicate)new Predicate<DefaultConferenceUser>(){

                            public boolean apply(@Nullable DefaultConferenceUser input) {
                                return !AbstractConferenceSdkService.this.currentUserOrEmpty().equals(input.getUserId());
                            }
                        });
                        for (DefaultConferenceUser conferenceUser : list) {
                            String userId = conferenceUser.getUserId();
                            if (null != foundExternalId) continue;
                            String externalId = conferenceUser.getUserInfo().getExternalId();
                            String cachedExternalId = (String)AbstractConferenceSdkService.this.mCacheUserIds.get(userId);
                            Log.d((String)TAG, (String)("onEvent: " + userId + " " + externalId + " " + cachedExternalId));
                            foundUser = conferenceUser;
                            if (null == userId || null != externalId && !userId.equals(externalId) || null == (externalId = cachedExternalId)) continue;
                            foundExternalId = cachedExternalId;
                        }
                        if (foundUser != null && null == foundExternalId) {
                            foundExternalId = foundUser.getUserId();
                            Log.d((String)TAG, (String)"externalId is null, setting it to userId");
                        }
                        HashMap<String, String> infos = new HashMap<String, String>();
                        infos.put("UserId", foundUser.getUserId());
                        infos.put("DisplayName", foundUser.getUserInfo().getName());
                        infos.put("NotifType", result.getType());
                        infos.put("ExternalId", foundExternalId);
                        infos.put("AvatarUrl", foundUser.getUserInfo().getAvatarUrl());
                        infos.put("ConfId", result.getConferenceId());
                        AbstractConferenceSdkService.this.getTwig().i("Starting default incoming view", new Object[0]);
                        Intent intent = VoxeetIntentFactory.buildFrom(AbstractConferenceSdkService.this.mContext, VoxeetPreferences.getDefaultActivity(), infos);
                        if (intent != null) {
                            AbstractConferenceSdkService.this.mContext.startActivity(intent);
                        }
                    }
                }
            }).error(new ErrorPromise(){

                public void onError(Throwable error) {
                    error.printStackTrace();
                }
            });
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OwnConferenceStartedEvent ownConferenceStartedEvent) {
        if (this.mConference == null) {
            this.mConference = this.createConference();
        }
        this.getTwig().i("Own mConference started", new Object[0]);
        this.mConference.setConferenceInfos(ownConferenceStartedEvent.event().getConferenceInfos());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(StartVideoAnswerEvent event) {
        Log.d((String)TAG, (String)("onEvent: start video event " + event.isSuccess() + " " + event.message()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RenegociationUpdate event) {
        RenegociationEndedEvent renego = event.getEvent();
        Log.d((String)TAG, (String)("onEvent: Renegociation " + renego.getConferenceId() + " " + renego.getType() + " " + renego.getAnswerReceived() + " " + renego.getOfferSent()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(final OfferCreatedEvent event) {
        Log.d((String)TAG, (String)("onEvent: OfferCreatedEvent " + event.message()));
        try {
            this.handleAnswer(event.offer()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + event.offer().getUserId() + " " + VoxeetPreferences.id()));
                }
            }).error(new ErrorPromise(){

                public void onError(Throwable error) {
                    error.printStackTrace();
                }
            });
        }
        catch (MediaEngineException e) {
            e.printStackTrace();
            this.getTwig().e(e);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserAddedEvent event) {
        ConferenceUserAdded content = event.getEvent();
        if (null != content) {
            HashMap<String, MediaStream> streams;
            ConferenceUserStatus status;
            Log.d((String)TAG, (String)("onEvent: ParticipantAdded " + content + " " + content.getUserId() + " " + this.getConference().getConferenceUsers().size()));
            DefaultConferenceUser user = this.findUserById(event.getEvent().getUserId());
            if (null == user) {
                user = new DefaultConferenceUser(content.getUserId(), null);
                user.setIsOwner(false);
                user.setUserInfo(new UserInfo(content.getName(), content.getExternalId(), content.getAvatarUrl()));
                this.mConference.getConferenceUsers().add(user);
            }
            if (null != (status = ConferenceUserStatus.fromString((String)content.getStatus()))) {
                user.setConferenceStatus(status);
                user.setStatus(content.getStatus());
            }
            this.mTwig.i("from Event ConferenceUserAddedEvent, user joined with id := " + user.getUserId(), new Object[0]);
            MediaStream stream = null;
            if (null != this.media && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                stream = streams.get(user.getUserId());
            }
            this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdatedEvent event) {
        boolean timeout_managed;
        DefaultConferenceUser user = this.findUserById(event.getUserId());
        ConferenceUserStatus status = ConferenceUserStatus.valueOf((String)event.getStatus());
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setStatus(event.getStatus());
            this.commitTransactionConferenceUser();
        } else {
            this.getTwig().i("Not in mConference user with id: " + event.getUserId() + " status updated to " + event.getStatus(), new Object[0]);
        }
        switch (status) {
            case CONNECTING: {
                if (null == user || user.getUserId().equals(VoxeetPreferences.id())) break;
                this.mTwig.i("Cancelling timeout timer from user connecting", new Object[0]);
                this.removeTimeoutCallbacks();
                break;
            }
            case LEFT: 
            case DECLINE: {
                if (this.media == null || user == null) break;
                this.getTwig().i("In mConference user with id: " + event.getUserId() + " status updated to " + event.getStatus(), new Object[0]);
                this.media.removePeer(event.getUserId());
                break;
            }
            default: {
                this.getTwig().i("status not managed updated to " + event.getStatus(), new Object[0]);
            }
        }
        boolean bl = timeout_managed = this.timeoutRunnable != null && this.timeoutRunnable.isTriggered();
        if (!timeout_managed) {
            switch (status) {
                case DECLINE: {
                    if (event.getUserId().equals(VoxeetPreferences.id())) break;
                    this.getTwig().i("Conference user with id: " + event.getUserId() + " declined the call", new Object[0]);
                    this.mEventBus.post((Object)new ConferenceUserCallDeclinedEvent(event.getConfId(), event.getUserId(), event.getStatus()));
                    break;
                }
                case LEFT: {
                    this.onUserLeft(event.getUserId());
                    break;
                }
                default: {
                    HashMap<String, MediaStream> streams;
                    MediaStream stream = null;
                    if (null != this.media && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                        stream = streams.get(user.getUserId());
                    }
                    this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                }
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantAddedEvent event) {
        DefaultConferenceUser user = event.getUser();
        if (user != null) {
            HashMap<String, MediaStream> streams;
            this.mTwig.i("Conference user joined with id: " + user.getUserId(), new Object[0]);
            MediaStream stream = null;
            if (null != this.media && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                stream = streams.get(user.getUserId());
            }
            this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPushEvent event) {
        this.closeMedia();
        this.getTwig().i("Conference has ended", new Object[0]);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceEndedEvent event) {
        this.closeMedia();
        this.getTwig().i("Conference has ended", new Object[0]);
        this.mEventBus.post((Object)event.getEvent());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(QualityUpdatedEvent event) {
        for (DefaultConferenceUser conferenceUser : event.getEvent().getUser()) {
            DefaultConferenceUser user = this.findUserById(conferenceUser.getUserId());
            if (user == null) continue;
            this.mTwig.i("Quality updated for " + user.getUserId(), new Object[0]);
            this.startTransactionConferenceUser();
            user.setQuality(conferenceUser.getQuality());
            this.commitTransactionConferenceUser();
            this.mEventBus.post((Object)new ConferenceUserQualityUpdatedEvent(user));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RecordingStatusUpdate event) {
        RecordingStatusUpdateEvent recordingStatusUpdateEvent = event.getEvent();
        DefaultConferenceUser user = this.findUserById(recordingStatusUpdateEvent.getUserId());
        if (user != null) {
            RecordingStatus status = RecordingStatus.valueOf((String)recordingStatusUpdateEvent.getRecordingStatus());
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                this.mConference.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.getTimeStamp()));
                this.mConference.setRecordingStatus(RecordingStatus.RECORDING);
                this.mConference.setRecordingUser(recordingStatusUpdateEvent.getUserId());
                user.setIsRecordingOwner(true);
            } else {
                this.isRecording = false;
                this.mConference.setStartRecordTimestamp(null);
                this.mConference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                this.mConference.setRecordingUser(null);
                user.setIsRecordingOwner(false);
            }
        }
        this.getTwig().i("Conference's recording status has changed to: " + event.getEvent().getRecordingStatus(), new Object[0]);
        this.mEventBus.post((Object)recordingStatusUpdateEvent);
    }

    protected abstract DefaultConference createConference();

    protected abstract DefaultConferenceUser createConferenceUser(String var1, String var2, UserInfo var3);

    protected abstract UserInfo createUserInfo(String var1, String var2, String var3);

    protected Twig getTwig() {
        return this.mTwig;
    }

    protected void setConference(DefaultConference conference) {
        this.mConference = conference;
        this.mConferenceId = conference.getConferenceId();
    }

    protected void setConferenceAlias(String alias) {
        this.mConferenceAlias = alias;
    }

    @Override
    protected EventBus getEventBus() {
        return this.mEventBus;
    }

    protected ConferenceListener getConferenceListener() {
        return this.mListener;
    }

    protected MediaSDK getMedia() {
        return this.media;
    }

    protected abstract void startTransactionConferenceUser();

    protected abstract void commitTransactionConferenceUser();

    protected abstract boolean isSDK();

    protected Promise<Integer> answer(final String peer, final SdpMessage message) {
        return new Promise((PromiseSolver)new PromiseSolver<Integer>(){

            public void onCall(final @NonNull Solver<Integer> solver) {
                try {
                    if (null == AbstractConferenceSdkService.this.mConferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                    return;
                }
                Log.d((String)"SDKMEDIA", (String)("answer: peer := " + peer + " message := " + message));
                Observable<Response<ResponseBody>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.answerConference(AbstractConferenceSdkService.this.mConferenceId, peer, message.getDescription());
                user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        AbstractConferenceSdkService.this.getTwig().e("Offer created for " + peer + " : KO", new Object[0]);
                        try {
                            ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(AbstractConferenceSdkService.this.handleError(e));
                            throw new PromiseParticipantAddedErrorEventException(event);
                        }
                        catch (PromiseParticipantAddedErrorEventException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }

                    public void onNext(Response<ResponseBody> response) {
                        if (response.code() != 200) {
                            AbstractConferenceSdkService.this.getTwig().i("Offer created for " + peer + " : KO", new Object[0]);
                            try {
                                ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(response.code() + "");
                                throw new PromiseParticipantAddedErrorEventException(event);
                            }
                            catch (PromiseParticipantAddedErrorEventException exception) {
                                solver.reject((Throwable)exception);
                            }
                        } else {
                            AbstractConferenceSdkService.this.getTwig().i("Offer created for " + peer + " : OK", new Object[0]);
                            solver.resolve((Object)response.code());
                        }
                    }
                });
            }
        });
    }

    protected Promise<Boolean> handleAnswer(final OfferCreated offer) throws MediaEngineException {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                if (null == AbstractConferenceSdkService.this.media) {
                    try {
                        throw new MediaEngineException("handleAnswer media is null");
                    }
                    catch (MediaEngineException exception) {
                        solver.reject((Throwable)exception);
                    }
                }
                SdpDescription description = new SdpDescription(offer.getDescription().getType(), offer.getDescription().getSdp());
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                for (OfferCandidate candidate : offer.getCandidates()) {
                    candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                }
                String userId = offer.getUserId();
                Log.d((String)TAG, (String)("handleAnswer: offer := " + offer.getUserId() + " " + offer.getExternalId()));
                Log.d((String)"SDKMEDIA", (String)("handleAnswer: " + offer.getUserId() + " " + offer.getExternalId() + " " + description.getSsrc()));
                try {
                    AbstractConferenceSdkService.this.media.createAnswerForPeer(userId, description.getSsrc(), description, candidates, offer.isMaster(), new PendingPeerCallback(){

                        public void onMessage(@Nullable SdpMessage message) {
                            try {
                                if (AbstractConferenceSdkService.this.mConference == null) {
                                    AbstractConferenceSdkService.this.mConference = AbstractConferenceSdkService.this.createConference();
                                }
                                DefaultConferenceUser user = null;
                                for (DefaultConferenceUser in_conf : AbstractConferenceSdkService.this.mConference.getConferenceUsers()) {
                                    if (in_conf.getUserId() == null || !in_conf.getUserId().equals(offer.getUserId())) continue;
                                    user = in_conf;
                                }
                                UserInfo infos = offer.getUserId().contains("11111") ? AbstractConferenceSdkService.this.createUserInfo("Julie", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_1.png") : (offer.getUserId().contains("22222") ? AbstractConferenceSdkService.this.createUserInfo("Sophie", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_2.png") : (offer.getUserId().contains("33333") ? AbstractConferenceSdkService.this.createUserInfo("Mike", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_3.png") : AbstractConferenceSdkService.this.createUserInfo(offer.getName(), offer.getExternalId(), offer.getAvatarUrl())));
                                if (user == null) {
                                    user = AbstractConferenceSdkService.this.createConferenceUser(offer.getUserId(), offer.getDevice(), infos);
                                    AbstractConferenceSdkService.this.mConference.getConferenceUsers().add(user);
                                } else {
                                    user.setUserInfo(infos);
                                }
                                AbstractConferenceSdkService.this.setUserPosition(offer.getUserId(), 0.0, 0.5);
                                AbstractConferenceSdkService.this.answer(offer.getUserId(), message).then((PromiseExec)new PromiseExec<Integer, Object>(){

                                    public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                        Log.d((String)TAG, (String)("onSuccess: " + result));
                                        solver.resolve((Object)true);
                                    }
                                }).error(new ErrorPromise(){

                                    public void onError(Throwable error) {
                                        if (error instanceof PromiseParticipantAddedErrorEventException) {
                                            AbstractConferenceSdkService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                        } else {
                                            error.printStackTrace();
                                        }
                                        solver.resolve((Object)false);
                                    }
                                });
                            }
                            catch (Exception e) {
                                Log.d((String)TAG, (String)("onMessage: unlockPeerOperation" + e.getMessage()));
                                solver.resolve((Object)false);
                            }
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }

    protected void safeUserManagementStarted() {
    }

    protected void safeUserManagementEnded() {
    }

    protected void safeConferenceManagementStarted() {
    }

    protected void safeConferenceManagementEnded() {
    }

    protected DefaultConferenceUser updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        DefaultConferenceUser user = this.findUserById(userId);
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setIsOwner(this.mConference.getOwnerProfile() == null || this.mConference.getOwnerProfile().getUserId().equals(user.getProfile().getUserId())).setConferenceStatus(status).setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
            this.commitTransactionConferenceUser();
            return user;
        }
        return null;
    }

    protected void initMedia() {
        Validate.notNull(this.mContext, "mContext");
        Validate.notNull(VoxeetPreferences.id(), "user id");
        if (this.media == null) {
            try {
                this.media = new MediaSDK(this.context, VoxeetPreferences.id(), this.mediaStreamListener, this.isVideoOn(), Validate.hasMicrophonePermissions(this.context));
                this.getAudioService().setSpeakerMode(this.isDefaultOnSpeaker);
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getTwig().i("the app does not seem to have mic permission, disabling mic", new Object[0]);
                    this.mute(true);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                }
            }
            catch (MediaEngineException e) {
                this.getTwig().e(e);
            }
        }
    }

    protected void closeMedia() {
        if (this.media != null) {
            try {
                if (this.mConference != null) {
                    for (DefaultConferenceUser user : this.mConference.getConferenceUsers()) {
                        if (user == null || user.getUserId() == null) continue;
                        this.media.removePeer(user.getUserId());
                    }
                }
            }
            catch (Exception ex) {
                this.mTwig.e(ex);
            }
            this.media.stop();
            this.media = null;
            this.getTwig().i("Microphone value restored to true", new Object[0]);
            this.isVideoOn = false;
            this.mTwig.i("Video value restored to false", new Object[0]);
            this.isListenerMode = false;
            this.getTwig().i("Listener mode set back to false", new Object[0]);
        }
        this.getTwig().i("Media closed", new Object[0]);
        this.setIsInConference(false);
        this.mConference = null;
    }

    private void removeTimeoutCallbacks() {
        if (this.timeoutRunnable != null) {
            this.timeoutRunnable.setCanceled(true);
            handler.removeCallbacks((Runnable)this.timeoutRunnable);
        }
    }

    private void sendTimeoutCallbacks() {
        if (this.mTimeOutTimer != -1L) {
            this.timeoutRunnable = new TimeoutRunnable(this, this.getTwig(), this.mEventBus, this.mTimeOutTimer);
            this.getTwig().i("scheduling timer to leave the mConference in " + this.mTimeOutTimer, new Object[0]);
            handler.postDelayed((Runnable)this.timeoutRunnable, this.mTimeOutTimer);
        }
    }

    private void onUserLeft(@NonNull String peer) {
        DefaultConferenceUser user = this.findUserById(peer);
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setConferenceStatus(ConferenceUserStatus.LEFT);
            if (this.getConferenceUsers().contains(user)) {
                this.getConferenceUsers().remove(user);
            }
            this.getTwig().i("Conference user left with id: " + user.getUserId(), new Object[0]);
            this.commitTransactionConferenceUser();
            this.mEventBus.post((Object)new ConferenceUserLeftEvent(user));
        }
    }

    protected VoxeetSdkTemplate getVoxeetSDK() {
        return this.mSDK;
    }

    public void setStatEnabled(boolean stats) {
        this.mEnableStats = stats;
    }

    private AudioService getAudioService() {
        return this.getVoxeetSDK().getAudioService();
    }
}

