package voxeet.com.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import voxeet.com.sdk.events.SuccessEvent;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RemoveTagsAnswerEvent extends SuccessEvent {

    private boolean success;

    public RemoveTagsAnswerEvent(boolean isSuccessful) {
        this.success = isSuccessful;
    }

    public RemoveTagsAnswerEvent(boolean isSuccessful, String error) {
        super(error);

        this.success = isSuccessful;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}
