/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Response;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.network.ISdkFilePresentationRService;
import voxeet.com.sdk.events.success.FileConvertedEvent;
import voxeet.com.sdk.events.success.FilePresentationStartedEvent;
import voxeet.com.sdk.events.success.FilePresentationStoppedEvent;
import voxeet.com.sdk.events.success.FilePresentationUpdatedEvent;
import voxeet.com.sdk.json.FileConverted;
import voxeet.com.sdk.json.FilePresentationStarted;
import voxeet.com.sdk.json.FilePresentationStopped;
import voxeet.com.sdk.json.FilePresentationUpdated;
import voxeet.com.sdk.models.FilePresentationConverted;
import voxeet.com.sdk.models.impl.DefaultFile;

public class SDKFilePresentationService
extends AbstractVoxeetService<ISdkFilePresentationRService> {
    private static final String TAG = SDKFilePresentationService.class.getSimpleName();
    private final VoxeetSdkTemplate mInstance;
    private HashMap<String, Solver<FilePresentationConverted>> mCacheSolvers;
    private HashMap<String, Solver<FilePresentationStarted>> mCacheStartedSolvers;
    private HashMap<String, Solver<FilePresentationStopped>> mCacheStoppedSolvers;
    private HashMap<String, Solver<FilePresentationUpdated>> mCacheUpdatedSolvers;

    public SDKFilePresentationService(VoxeetSdkTemplate instance) {
        super(instance, ISdkFilePresentationRService.class);
        this.mInstance = instance;
        this.mCacheSolvers = new HashMap();
        this.mCacheStartedSolvers = new HashMap();
        this.mCacheStoppedSolvers = new HashMap();
        this.mCacheUpdatedSolvers = new HashMap();
        this.registerEventBus();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationStartedEvent event) {
        this.tryUnlock(event.getEvent().getFileId(), event.getEvent(), this.mCacheStartedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationStoppedEvent event) {
        this.tryUnlock(event.getEvent().getFileId(), event.getEvent(), this.mCacheStoppedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationUpdatedEvent event) {
        this.tryUnlock(event.getEvent().getFileId(), event.getEvent(), this.mCacheUpdatedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FileConvertedEvent event) {
        if (null != event) {
            FileConverted converted = event.getEvent();
            List<DefaultFile> list = converted.getFiles();
            for (DefaultFile file : list) {
                Log.d((String)TAG, (String)("onEvent: " + file.getName()));
                String key = this.findSolverFor(file.getName());
                Log.d((String)TAG, (String)("onEvent: " + key));
                if (null == key) continue;
                FilePresentationConverted temp = new FilePresentationConverted(file.getName(), file.getFileId(), file.getSize(), file.getNbImageConverted());
                this.tryUnlock(key, temp, this.mCacheSolvers);
            }
        }
    }

    public String getImage(String fileId, int pageNumber) {
        return String.format("%s/v1/files/%s/converted/%d?token=%s", this.getURLRoot(this.mInstance), fileId, pageNumber, this.getInternalJwtToken(this.mInstance));
    }

    public String getThumbnail(String fileId, int pageNumber) {
        return String.format("%s/v1/files/%s/converted/%d/thumbnail?token=%s", this.getURLRoot(this.mInstance), fileId, pageNumber, this.getInternalJwtToken(this.mInstance));
    }

    @Nullable
    private String findSolverFor(@NonNull String name) {
        for (String value : this.mCacheSolvers.keySet()) {
            if (name.indexOf(value) != 0) continue;
            return value;
        }
        return null;
    }

    public Promise<FilePresentationConverted> convertFile(final File file) {
        return new Promise((PromiseSolver)new PromiseSolver<FilePresentationConverted>(){

            public void onCall(final @NonNull Solver<FilePresentationConverted> solver) {
                final String uuid = UUID.randomUUID().toString();
                String appended_name = uuid + file.getName();
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)appended_name, (RequestBody)requestFile);
                ((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).convertFile(requestFile, body).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                        Log.d((String)TAG, (String)"onCompleted: ");
                    }

                    public void onError(Throwable e) {
                        Log.d((String)TAG, (String)("onError: " + e));
                        solver.reject(e);
                    }

                    public void onNext(Response<ResponseBody> responseBodyResponse) {
                        SDKFilePresentationService.this.mCacheSolvers.put(uuid, solver);
                    }
                });
            }
        });
    }

    public Promise<FilePresentationStarted> startPresentation(@NonNull FilePresentationConverted body) {
        return this.startPresentation(body, 0);
    }

    public Promise<FilePresentationStarted> startPresentation(final @NonNull FilePresentationConverted body, final int position) {
        return new Promise((PromiseSolver)new PromiseSolver<FilePresentationStarted>(){

            public void onCall(final @NonNull Solver<FilePresentationStarted> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(body.getFileId(), body.getName(), position, body.getNbImageConverted());
                SDKFilePresentationService.this.internalCall((Observable<Response<ResponseBody>>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).startFilePresentation(((AbstractConferenceSdkService)SDKFilePresentationService.this.mInstance.getConferenceService()).getConferenceId(), body_sent)).then((PromiseExec)new PromiseExec<Response<ResponseBody>, Object>(){

                    public void onCall(@Nullable Response<ResponseBody> responseBodyResponse, @NonNull Solver<Object> internal_solver) {
                        SDKFilePresentationService.this.mCacheStartedSolvers.put(body.getFileId(), solver);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable throwable) {
                        solver.reject(throwable);
                    }
                });
            }
        });
    }

    public Promise<FilePresentationStopped> stopPresentation(final @NonNull String fileId) {
        return new Promise((PromiseSolver)new PromiseSolver<FilePresentationStopped>(){

            public void onCall(final @NonNull Solver<FilePresentationStopped> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(fileId);
                SDKFilePresentationService.this.internalCall((Observable<Response<ResponseBody>>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).stopFilePresentation(((AbstractConferenceSdkService)SDKFilePresentationService.this.mInstance.getConferenceService()).getConferenceId(), body_sent)).then((PromiseExec)new PromiseExec<Response<ResponseBody>, Object>(){

                    public void onCall(@Nullable Response<ResponseBody> responseBodyResponse, @NonNull Solver<Object> internal_solver) {
                        SDKFilePresentationService.this.mCacheStoppedSolvers.put(fileId, solver);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable throwable) {
                        solver.reject(throwable);
                    }
                });
            }
        });
    }

    public Promise<FilePresentationUpdated> updatePresentation(final @NonNull String fileId, final int position) {
        return new Promise((PromiseSolver)new PromiseSolver<FilePresentationUpdated>(){

            public void onCall(final @NonNull Solver<FilePresentationUpdated> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(fileId, position);
                SDKFilePresentationService.this.internalCall((Observable<Response<ResponseBody>>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).updateFilePresentation(((AbstractConferenceSdkService)SDKFilePresentationService.this.mInstance.getConferenceService()).getConferenceId(), body_sent)).then((PromiseExec)new PromiseExec<Response<ResponseBody>, Object>(){

                    public void onCall(@Nullable Response<ResponseBody> responseBodyResponse, @NonNull Solver<Object> internal_solver) {
                        SDKFilePresentationService.this.mCacheUpdatedSolvers.put(fileId, solver);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable throwable) {
                        solver.reject(throwable);
                    }
                });
            }
        });
    }

    private Promise<Response<ResponseBody>> internalCall(final Observable<Response<ResponseBody>> observable_caller) {
        return new Promise((PromiseSolver)new PromiseSolver<Response<ResponseBody>>(){

            public void onCall(final @NonNull Solver<Response<ResponseBody>> solver) {
                String conferenceId = ((AbstractConferenceSdkService)SDKFilePresentationService.this.mInstance.getConferenceService()).getConferenceId();
                if (null == conferenceId) {
                    solver.reject((Throwable)new IllegalStateException("Not in conference"));
                    return;
                }
                observable_caller.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                        Log.d((String)TAG, (String)"onCompleted: ");
                    }

                    public void onError(Throwable e) {
                        solver.reject(e);
                    }

                    public void onNext(Response<ResponseBody> responseBodyResponse) {
                        if (responseBodyResponse.code() >= 200 && responseBodyResponse.code() < 300) {
                            solver.resolve(responseBodyResponse);
                        } else {
                            try {
                                throw new IllegalStateException("Exception while managing presentation, invalid state ?");
                            }
                            catch (IllegalStateException exception) {
                                solver.reject((Throwable)exception);
                            }
                        }
                    }
                });
            }
        });
    }

    private <FILE_PRESENTATION> void tryUnlock(String fileId, FILE_PRESENTATION object, HashMap<String, Solver<FILE_PRESENTATION>> maps) {
        Log.d((String)TAG, (String)("tryUnlock: fileId := " + fileId + " " + object + " " + maps));
        Solver<FILE_PRESENTATION> solver = maps.get(fileId);
        Log.d((String)TAG, (String)("tryUnlock: solver ? := " + solver));
        if (null != solver) {
            solver.resolve(object);
            if (maps.containsKey(fileId)) {
                maps.remove(solver);
            }
        }
    }
}

