/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.greenrobot.eventbus.EventBus;
import voxeet.com.sdk.events.BaseEvent;
import voxeet.com.sdk.events.error.SocketErrorEvent;
import voxeet.com.sdk.events.success.BadgeUpdate;
import voxeet.com.sdk.events.success.ConferenceDestroyedPushEvent;
import voxeet.com.sdk.events.success.ConferenceEndedEvent;
import voxeet.com.sdk.events.success.ConferenceStatsEvent;
import voxeet.com.sdk.events.success.ConferenceUpdated;
import voxeet.com.sdk.events.success.ConferenceUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUserAddedEvent;
import voxeet.com.sdk.events.success.ConferenceUserSwitchEvent;
import voxeet.com.sdk.events.success.ContactAddedEvent;
import voxeet.com.sdk.events.success.FileConvertedEvent;
import voxeet.com.sdk.events.success.FilePresentationChangeEvent;
import voxeet.com.sdk.events.success.FilePresentationStartEvent;
import voxeet.com.sdk.events.success.FilePresentationStartedEvent;
import voxeet.com.sdk.events.success.FilePresentationStopEvent;
import voxeet.com.sdk.events.success.FilePresentationStoppedEvent;
import voxeet.com.sdk.events.success.FilePresentationUpdatedEvent;
import voxeet.com.sdk.events.success.InvitationReceived;
import voxeet.com.sdk.events.success.MeetingActivityAdded;
import voxeet.com.sdk.events.success.MeetingActivityDeleted;
import voxeet.com.sdk.events.success.MeetingActivityUpdated;
import voxeet.com.sdk.events.success.MeetingAddedOrUpdated;
import voxeet.com.sdk.events.success.MeetingDeleted;
import voxeet.com.sdk.events.success.MeetingEventAddedOrUpdated;
import voxeet.com.sdk.events.success.MeetingReadTimeStampUpdated;
import voxeet.com.sdk.events.success.MessageReceived;
import voxeet.com.sdk.events.success.OfferCreatedEvent;
import voxeet.com.sdk.events.success.OwnConferenceStartedEvent;
import voxeet.com.sdk.events.success.OwnConferenceUserSwitchEvent;
import voxeet.com.sdk.events.success.OwnContactRemoved;
import voxeet.com.sdk.events.success.OwnExternalInvitationSent;
import voxeet.com.sdk.events.success.OwnProfileUpdatedEvent;
import voxeet.com.sdk.events.success.OwnUserInvitedEvent;
import voxeet.com.sdk.events.success.ParticipantUpdatedEvent;
import voxeet.com.sdk.events.success.PeerConnectionStatusUpdatedEvent;
import voxeet.com.sdk.events.success.PlayEmoSphereEvent;
import voxeet.com.sdk.events.success.ProfileUpdated;
import voxeet.com.sdk.events.success.QualityUpdatedEvent;
import voxeet.com.sdk.events.success.RecordingStatusUpdate;
import voxeet.com.sdk.events.success.RenegociationEndedEvent;
import voxeet.com.sdk.events.success.RenegociationUpdate;
import voxeet.com.sdk.events.success.SocketConnectEvent;
import voxeet.com.sdk.events.success.SocketDisconnectEvent;
import voxeet.com.sdk.events.success.SocketStateChangeEvent;
import voxeet.com.sdk.events.success.TypingDetectionEvent;
import voxeet.com.sdk.events.success.UserInvitedEvent;
import voxeet.com.sdk.events.success.WhisperInviteAcceptedEvent;
import voxeet.com.sdk.events.success.WhisperInviteDeclinedEvent;
import voxeet.com.sdk.events.success.WhisperInviteReceivedEvent;
import voxeet.com.sdk.events.success.WhisperLeftEvent;
import voxeet.com.sdk.factories.EventsFactory;
import voxeet.com.sdk.json.BadgeUpdatedEvent;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.ConferenceDestroyedPush;
import voxeet.com.sdk.json.ConferenceEnded;
import voxeet.com.sdk.json.ConferenceMessageReceived;
import voxeet.com.sdk.json.ConferenceStats;
import voxeet.com.sdk.json.ConferenceUserAdded;
import voxeet.com.sdk.json.ConferenceUserSwitch;
import voxeet.com.sdk.json.ContactAdded;
import voxeet.com.sdk.json.Event;
import voxeet.com.sdk.json.FileAdded;
import voxeet.com.sdk.json.FileAddedEvent;
import voxeet.com.sdk.json.FileConverted;
import voxeet.com.sdk.json.FileDeleted;
import voxeet.com.sdk.json.FileDeletedEvent;
import voxeet.com.sdk.json.FilePresentationChange;
import voxeet.com.sdk.json.FilePresentationStart;
import voxeet.com.sdk.json.FilePresentationStarted;
import voxeet.com.sdk.json.FilePresentationStop;
import voxeet.com.sdk.json.FilePresentationStopped;
import voxeet.com.sdk.json.FilePresentationUpdated;
import voxeet.com.sdk.json.InvitationReceivedEvent;
import voxeet.com.sdk.json.MeetActivityAddedEvent;
import voxeet.com.sdk.json.MeetActivityDeletedEvent;
import voxeet.com.sdk.json.MeetActivityUpdatedEvent;
import voxeet.com.sdk.json.MeetingAddedOrUpdatedEvent;
import voxeet.com.sdk.json.MeetingDeletedEvent;
import voxeet.com.sdk.json.MeetingEventAddedOrUpdatedEvent;
import voxeet.com.sdk.json.MeetingReadTimeStampUpdatedEvent;
import voxeet.com.sdk.json.OfferCreated;
import voxeet.com.sdk.json.OwnConferenceCreated;
import voxeet.com.sdk.json.OwnConferenceUserSwitch;
import voxeet.com.sdk.json.OwnContactRemovedEvent;
import voxeet.com.sdk.json.OwnExternalInvitationSentEvent;
import voxeet.com.sdk.json.OwnProfileUpdated;
import voxeet.com.sdk.json.OwnUserInvited;
import voxeet.com.sdk.json.ParticipantUpdated;
import voxeet.com.sdk.json.PeerConnectionStatusUpdated;
import voxeet.com.sdk.json.PlayEmoSphere;
import voxeet.com.sdk.json.ProfileUpdatedEvent;
import voxeet.com.sdk.json.QualityUpdated;
import voxeet.com.sdk.json.RecordingStatusUpdateEvent;
import voxeet.com.sdk.json.TypingDetection;
import voxeet.com.sdk.json.UserInvited;
import voxeet.com.sdk.json.WhisperInvitationAccepted;
import voxeet.com.sdk.json.WhisperInvitationDeclined;
import voxeet.com.sdk.json.WhisperInvitationReceived;
import voxeet.com.sdk.json.WhisperLeft;

public class VoxeetDispatcher {
    private static final String TAG = VoxeetDispatcher.class.getSimpleName();
    private static EventBus eventBus = EventBus.getDefault();
    private final Gson sGson = new GsonBuilder().serializeNulls().create();

    public static void dispatch(String eventName, String message) {
        Log.d((String)TAG, (String)("dispatch: " + eventName + " := " + message));
        try {
            BaseEvent event;
            switch (eventName) {
                case "SOCKET_DISCONNECTED": {
                    event = VoxeetDispatcher.handleDisconnect(message);
                    break;
                }
                case "SOCKET_ERROR": {
                    event = VoxeetDispatcher.handleError(message);
                    break;
                }
                case "SOCKET_TEXT": {
                    event = VoxeetDispatcher.handleMessage(message);
                    break;
                }
                case "SOCKET_CONNECTED": {
                    event = VoxeetDispatcher.handleSocketConnect(message);
                    break;
                }
                case "SOCKET_STATE_CHANGE": {
                    event = VoxeetDispatcher.handleStateChange(message);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown event type");
                }
            }
            eventBus.post((Object)event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BaseEvent handleError(String message) {
        return new SocketErrorEvent(message);
    }

    private static BaseEvent handleDisconnect(String message) {
        return new SocketDisconnectEvent(message);
    }

    private static BaseEvent handleStateChange(String message) {
        return new SocketStateChangeEvent(message);
    }

    private static BaseEvent handleSocketConnect(String message) {
        return new SocketConnectEvent(message);
    }

    private static BaseEvent handleMessage(String message) {
        BaseEvent busEvent;
        Event event = EventsFactory.decode(message);
        switch (event.getType()) {
            case "OfferCreated": {
                busEvent = new OfferCreatedEvent(message, (OfferCreated)event);
                break;
            }
            case "ConferenceMessageReceived": {
                busEvent = VoxeetDispatcher.handleConferenceMessage((ConferenceMessageReceived)event);
                break;
            }
            case "ConferenceDestroyedPush": {
                busEvent = new ConferenceDestroyedPushEvent(message, (ConferenceDestroyedPush)event);
                break;
            }
            case "ProfileUpdatedEvent": {
                busEvent = new ProfileUpdated(message, (ProfileUpdatedEvent)event);
                break;
            }
            case "ParticipantUpdated": {
                ParticipantUpdated participantUpdated = (ParticipantUpdated)event;
                busEvent = new ParticipantUpdatedEvent(message, participantUpdated);
                break;
            }
            case "OwnConferenceCreatedEvent": {
                busEvent = new OwnConferenceStartedEvent(message, (OwnConferenceCreated)event);
                break;
            }
            case "OwnProfileUpdatedEvent": {
                busEvent = new OwnProfileUpdatedEvent(message, (OwnProfileUpdated)event);
                break;
            }
            case "OwnExternalInvitationsSentEvent": {
                busEvent = new OwnExternalInvitationSent(message, (OwnExternalInvitationSentEvent)event);
                break;
            }
            case "OwnContactRemovedEvent": {
                busEvent = new OwnContactRemoved(message, (OwnContactRemovedEvent)event);
                break;
            }
            case "MeetingAddedOrUpdatedEvent": {
                busEvent = new MeetingAddedOrUpdated(message, (MeetingAddedOrUpdatedEvent)event);
                break;
            }
            case "MeetingDeletedEvent": {
                busEvent = new MeetingDeleted(message, (MeetingDeletedEvent)event);
                break;
            }
            case "BadgeCounterUpdatedEvent": {
                busEvent = new BadgeUpdate(message, (BadgeUpdatedEvent)event);
                break;
            }
            case "RenegociationEnded": {
                busEvent = new RenegociationUpdate(message, (RenegociationEndedEvent)event);
                break;
            }
            case "BroadcastEvent": {
                busEvent = VoxeetDispatcher.handleBroadcast((BroadcastEvent)event);
                break;
            }
            case "RecordingStatusUpdated": {
                busEvent = new RecordingStatusUpdate(message, (RecordingStatusUpdateEvent)event);
                break;
            }
            case "MeetActivityDeletedEvent": {
                busEvent = new MeetingActivityDeleted(message, (MeetActivityDeletedEvent)event);
                break;
            }
            case "MeetActivityUpdatedEvent": {
                busEvent = new MeetingActivityUpdated(message, (MeetActivityUpdatedEvent)event);
                break;
            }
            case "MeetActivityAddedEvent": {
                busEvent = new MeetingActivityAdded(message, (MeetActivityAddedEvent)event);
                break;
            }
            case "MeetingReadTimestampUpdatedEvent": {
                busEvent = new MeetingReadTimeStampUpdated(message, (MeetingReadTimeStampUpdatedEvent)event);
                break;
            }
            case "InvitationReceivedEvent": {
                busEvent = new InvitationReceived(message, (InvitationReceivedEvent)event);
                break;
            }
            case "MeetingEventAddedOrUpdatedEvent": {
                busEvent = new MeetingEventAddedOrUpdated(message, (MeetingEventAddedOrUpdatedEvent)event);
                break;
            }
            case "FileDeletedEvent": {
                busEvent = new FileDeleted(message, (FileDeletedEvent)event);
                break;
            }
            case "FileSharedEvent": {
                busEvent = new FileAdded(message, (FileAddedEvent)event);
                break;
            }
            case "QualityUpdated": {
                busEvent = new QualityUpdatedEvent(message, (QualityUpdated)event);
                break;
            }
            case "WhisperInvitationReceivedEvent": {
                busEvent = new WhisperInviteReceivedEvent(message, (WhisperInvitationReceived)event);
                break;
            }
            case "WhisperAcceptedEvent": {
                busEvent = new WhisperInviteAcceptedEvent(message, (WhisperInvitationAccepted)event);
                break;
            }
            case "WhisperDeclinedEvent": {
                busEvent = new WhisperInviteDeclinedEvent(message, (WhisperInvitationDeclined)event);
                break;
            }
            case "WhisperLeftEvent": {
                busEvent = new WhisperLeftEvent(message, (WhisperLeft)event);
                break;
            }
            case "OwnUserInvitedEvent": {
                busEvent = new OwnUserInvitedEvent(message, (OwnUserInvited)event);
                break;
            }
            case "UserInvited": {
                busEvent = new UserInvitedEvent(message, (UserInvited)event);
                break;
            }
            case "ParticipantSwitched": {
                busEvent = new ConferenceUserSwitchEvent(message, (ConferenceUserSwitch)event);
                break;
            }
            case "ParticipantAdded": {
                busEvent = new ConferenceUserAddedEvent(message, (ConferenceUserAdded)event);
                break;
            }
            case "OwnParticipantSwitched": {
                busEvent = new OwnConferenceUserSwitchEvent(message, (OwnConferenceUserSwitch)event);
                break;
            }
            case "ConferenceEndedEvent": {
                busEvent = new ConferenceEndedEvent(message, (ConferenceEnded)event);
                break;
            }
            case "ConferenceStatusUpdated": {
                busEvent = new ConferenceUpdatedEvent(message, (ConferenceUpdated)event);
                break;
            }
            case "FileConvertedEvent": {
                busEvent = new FileConvertedEvent(message, (FileConverted)event);
                break;
            }
            case "FilePresentationStarted": {
                busEvent = new FilePresentationStartedEvent(message, (FilePresentationStarted)event);
                break;
            }
            case "FilePresentationStopped": {
                busEvent = new FilePresentationStoppedEvent(message, (FilePresentationStopped)event);
                break;
            }
            case "FilePresentationUpdated": {
                busEvent = new FilePresentationUpdatedEvent(message, (FilePresentationUpdated)event);
                break;
            }
            case "ContactsAddedEvent": {
                busEvent = new ContactAddedEvent(message, (ContactAdded)event);
                break;
            }
            case "PeerConnectionStatusUpdatedEvent": {
                busEvent = new PeerConnectionStatusUpdatedEvent(message, (PeerConnectionStatusUpdated)event);
                break;
            }
            case "ConferenceStats": {
                ConferenceStats stats = (ConferenceStats)new Gson().fromJson(message, ConferenceStats.class);
                busEvent = new ConferenceStatsEvent(message, stats);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type of event");
            }
        }
        return busEvent;
    }

    private static BaseEvent handleConferenceMessage(ConferenceMessageReceived event) {
        Event event1 = EventsFactory.decode(event.getMessage());
        if (event1 == null) {
            return new MessageReceived(event.getUserId(), event.getConferenceId(), event.getMessage());
        }
        switch (event1.getType()) {
            case "FilePresentationChange": {
                return new FilePresentationChangeEvent(event.getMessage(), event.getUserId(), event.getConferenceId(), (FilePresentationChange)event1);
            }
            case "FilePresentationStart": {
                return new FilePresentationStartEvent(event.getMessage(), event.getUserId(), event.getConferenceId(), (FilePresentationStart)event1);
            }
            case "FilePresentationStop": {
                return new FilePresentationStopEvent(event.getMessage(), event.getUserId(), event.getConferenceId(), (FilePresentationStop)event1);
            }
            case "PlayEmosphere": {
                return new PlayEmoSphereEvent(event.getMessage(), event.getUserId(), event.getConferenceId(), (PlayEmoSphere)event1);
            }
        }
        return new MessageReceived(event.getUserId(), event.getConferenceId(), event.getMessage());
    }

    private static BaseEvent handleBroadcast(BroadcastEvent event) {
        Event event1 = EventsFactory.decode(event.getMessage());
        switch (event1.getType()) {
            case "TypingDetection": {
                return new TypingDetectionEvent(event.getMessage(), (TypingDetection)event1, event.getUserId(), event.getMeetingId());
            }
        }
        throw new IllegalStateException("Unknown broadcast type event");
    }
}

