package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceInfos;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultUserProfile;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OWN_USER_INVITED)
public class OwnUserInvited extends Event {

    private String userId;

    @JsonProperty("conference")
    private DefaultConferenceInfos conferenceInfos;

    public List<DefaultUserProfile> getGuests() {
        return guests;
    }

    public void setGuests(List<DefaultUserProfile> guests) {
        this.guests = guests;
    }

    private List<DefaultUserProfile> guests;

    public DefaultConference getConference() {
        DefaultConference conference = new DefaultConference();
        conference.setConferenceInfos(conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(conferenceInfos.getConferenceType());
        conference.setMeetingId(conferenceInfos.getMeetingId());
        conference.setConferenceId(conferenceInfos.getConferenceId());
        conference.setDescription(conferenceInfos.getDescription());
        conference.setLocation(conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);

        for (DefaultUserProfile profile : guests) {
            conference.getConferenceUsers().add(new DefaultConferenceUser(profile));
        }

        return conference;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DefaultConferenceInfos getConferenceInfos() {
        return conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return EventNames.OWN_USER_INVITED;
    }
}
