/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services.authenticate.token;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import retrofit2.Call;
import retrofit2.Callback;
import voxeet.com.sdk.core.network.IVoxeetRService;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.TokenResponse;
import voxeet.com.sdk.models.UserTokenResponse;

public abstract class TokenResponseProvider {
    protected static final String HEADER_NAME_AUTHORIZATION = "Authorization";
    private static final String HEADER_VOXEET_TOKEN = "Voxeet-Token";
    private static final String HEADER_NAME_XTOKEN = "X-Token";
    public final String TAG = TokenResponseProvider.class.getSimpleName();
    @Nullable
    private UserInfo mUserInfo;
    private String resetTokenValue = "";
    @Nullable
    protected TokenResponse tokenResponse;
    private UserTokenResponse mUserTokenResponse;
    protected IVoxeetRService service;
    private IVoxeetRService serviceSubAuthenticator;
    @NonNull
    private final HashMap<String, UserTokenResponse> responses = new HashMap();

    public void resetVoxeetHttp() {
        this.resetTokenValue = "resetting";
    }

    @Nullable
    private TokenResponse multipleRefreshTokenResponseTry() {
        for (int tries = 0; tries < 5; ++tries) {
            TokenResponse answer = this.refreshTokenResponse();
            if (null != answer) {
                return answer;
            }
            this.wait(tries);
        }
        return null;
    }

    @Nullable
    public Response executeIdentify(Interceptor.Chain chain, String tag) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        if (null != this.tokenResponse) {
            this.addHeader(builder.removeHeader(HEADER_NAME_AUTHORIZATION)).addHeader(HEADER_NAME_AUTHORIZATION, "bearer " + this.resetTokenValue + this.tokenResponse.getAccessToken());
        }
        return chain.proceed(builder.build());
    }

    @Nullable
    public Response execute(Interceptor.Chain chain) throws IOException {
        try {
            Request.Builder builder = chain.request().newBuilder();
            if (null != this.tokenResponse) {
                builder.addHeader(HEADER_NAME_AUTHORIZATION, "bearer " + this.resetTokenValue + this.tokenResponse.getAccessToken());
            }
            if (null != this.mUserTokenResponse) {
                builder.removeHeader(HEADER_NAME_XTOKEN);
                if (!TextUtils.isEmpty((CharSequence)this.mUserTokenResponse.getUserToken())) {
                    builder.addHeader(HEADER_VOXEET_TOKEN, this.mUserTokenResponse.getUserToken());
                }
                if (null != this.mUserTokenResponse.getJwtUserToken()) {
                    builder.addHeader(HEADER_NAME_XTOKEN, this.mUserTokenResponse.getJwtUserToken());
                }
            }
            return chain.proceed(builder.build());
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)("execute: ISSUE WHILE EXECUTING " + chain.call().request().toString()));
            if (e instanceof IOException) {
                throw e;
            }
            e.printStackTrace();
            return null;
        }
    }

    @NonNull
    private Promise<UserTokenResponse> retrieveUserTokenResponse(final @NonNull UserInfo userInfo) {
        return new Promise((PromiseSolver)new PromiseSolver<UserTokenResponse>(){

            public void onCall(final @NonNull Solver<UserTokenResponse> solver) {
                UserTokenResponse response = TokenResponseProvider.this.getUserTokenResponse(userInfo.getExternalId());
                if (null != response) {
                    Log.d((String)TokenResponseProvider.this.TAG, (String)"onCall: the user is known, it is better to resolve it...");
                    solver.resolve((Object)response);
                } else {
                    Call<UserTokenResponse> user = TokenResponseProvider.this.service.identify(userInfo);
                    user.enqueue((Callback)new Callback<UserTokenResponse>(){

                        public void onResponse(@NonNull Call<UserTokenResponse> call, @NonNull retrofit2.Response<UserTokenResponse> response) {
                            UserTokenResponse token = (UserTokenResponse)response.body();
                            if (null != token) {
                                TokenResponseProvider.this.responses.put(userInfo.getExternalId(), token);
                            }
                            solver.resolve((Object)token);
                        }

                        public void onFailure(@NonNull Call<UserTokenResponse> call, @NonNull Throwable t) {
                            solver.reject(t);
                        }
                    });
                }
            }
        });
    }

    @Nullable
    private Request reauthenticate(Route route, Response response) {
        Log.d((String)this.TAG, (String)"reauthenticate the user");
        this.resetTokenValue = "";
        boolean wasIdentifying = false;
        Headers headers = response.request().headers();
        if (null != headers) {
            for (int i = 0; i < headers.size(); ++i) {
                String name = headers.name(i);
                String header = headers.get(name);
                if (null == header || !header.contains("identifying")) continue;
                wasIdentifying = true;
            }
        }
        Request.Builder builder = response.request().newBuilder();
        TokenResponse tokenResponse = this.multipleRefreshTokenResponseTry();
        if (null == tokenResponse) {
            return null;
        }
        this.tokenResponse = tokenResponse;
        Log.d((String)this.TAG, (String)("reauthenticate: wasIdentifying:=" + wasIdentifying + " mUserInfos:=" + this.mUserInfo + " mUserTokenResponse:=" + this.mUserTokenResponse));
        if (!wasIdentifying && null != this.mUserInfo && null == this.mUserTokenResponse) {
            try {
                UserTokenResponse userTokenResponse = this.getUserTokenResponse(this.mUserInfo.getExternalId());
                Log.d((String)this.TAG, (String)("reauthenticate: already known := " + userTokenResponse));
                if (null == userTokenResponse) {
                    userTokenResponse = (UserTokenResponse)this.serviceSubAuthenticator.identify(this.mUserInfo).execute().body();
                }
                if (null != userTokenResponse) {
                    Log.d((String)this.TAG, (String)"reauthenticate: userTokenResponse storing");
                    this.responses.put(this.mUserInfo.getExternalId(), userTokenResponse);
                    this.mUserTokenResponse = userTokenResponse;
                }
                Log.d((String)this.TAG, (String)("reauthenticate: new token := " + this.mUserTokenResponse));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (wasIdentifying) {
            Log.d((String)this.TAG, (String)"reauthenticate: no identify in it since it was identifying the user B)");
        }
        this.addHeader(builder.removeHeader(HEADER_NAME_AUTHORIZATION)).addHeader(HEADER_NAME_AUTHORIZATION, "bearer " + tokenResponse.getAccessToken());
        if (!wasIdentifying && null != this.mUserTokenResponse) {
            builder.removeHeader(HEADER_NAME_XTOKEN).addHeader(HEADER_VOXEET_TOKEN, this.mUserTokenResponse.getUserToken()).addHeader(HEADER_NAME_XTOKEN, this.mUserTokenResponse.getJwtUserToken());
        } else {
            Log.d((String)this.TAG, (String)("authenticate: no jwt token or wasIdentifying:=" + wasIdentifying));
        }
        return builder.build();
    }

    @Nullable
    public abstract TokenResponse refreshTokenResponse();

    @NonNull
    public Promise<UserTokenResponse> retrieve() {
        return new Promise((PromiseSolver)new PromiseSolver<UserTokenResponse>(){

            public void onCall(final @NonNull Solver<UserTokenResponse> solver) {
                Promise<TokenResponse> response = TokenResponseProvider.this.retrieveTokenResponse();
                response.then((PromiseExec)new PromiseExec<TokenResponse, UserTokenResponse>(){

                    public void onCall(@Nullable TokenResponse result, @NonNull Solver<UserTokenResponse> s) {
                        Log.d((String)TokenResponseProvider.this.TAG, (String)("onCall: solver 1 " + result));
                        TokenResponseProvider.this.tokenResponse = result;
                        if (null != TokenResponseProvider.this.mUserInfo) {
                            s.resolve(TokenResponseProvider.this.retrieveUserTokenResponse(TokenResponseProvider.this.mUserInfo));
                        } else {
                            try {
                                throw new IllegalStateException("user info null, disconnected ?");
                            }
                            catch (Exception e) {
                                s.reject((Throwable)e);
                            }
                        }
                    }
                }).then((PromiseExec)new PromiseExec<UserTokenResponse, Object>(){

                    public void onCall(@Nullable UserTokenResponse result, @NonNull Solver<Object> s) {
                        Log.d((String)TokenResponseProvider.this.TAG, (String)("onCall: solver 2 " + result));
                        UserInfo info = TokenResponseProvider.this.mUserInfo;
                        if (null == result && null != info && null != info.getExternalId()) {
                            result = TokenResponseProvider.this.getUserTokenResponse(info.getExternalId());
                            Log.d((String)TokenResponseProvider.this.TAG, (String)("onCall: we have an info ?! " + result));
                        }
                        TokenResponseProvider.this.mUserTokenResponse = result;
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    @NonNull
    protected abstract Promise<TokenResponse> retrieveTokenResponse();

    @NonNull
    protected abstract Request.Builder addHeader(@NonNull Request.Builder var1);

    private void wait(int tries) {
        try {
            Thread.sleep(200 * tries);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUserInfo(@Nullable UserInfo userInfo) {
        this.mUserInfo = userInfo;
    }

    @Nullable
    public TokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    @Nullable
    public String getToken() {
        return this.mUserTokenResponse != null ? this.mUserTokenResponse.getUserToken() : null;
    }

    @Nullable
    public String getJwtToken() {
        return this.mUserTokenResponse != null ? this.mUserTokenResponse.getJwtUserToken() : null;
    }

    public void initService(IVoxeetRService service, IVoxeetRService serviceSubAuthenticator) {
        this.service = service;
        this.serviceSubAuthenticator = serviceSubAuthenticator;
    }

    private Authenticator createAuthenticator() {
        return new Authenticator(){

            public Request authenticate(@NonNull Route route, @NonNull Response response) throws IOException {
                return TokenResponseProvider.this.reauthenticate(route, response);
            }
        };
    }

    public void configureOkHttpClientBuilder(OkHttpClient.Builder builder, boolean useAuthenticator) {
        if (useAuthenticator) {
            builder = builder.authenticator(this.createAuthenticator());
        }
        builder.connectionPool(new ConnectionPool(5, 45L, TimeUnit.SECONDS)).retryOnConnectionFailure(true).pingInterval(3L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).writeTimeout(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private UserTokenResponse getUserTokenResponse(@NonNull String userId) {
        HashMap<String, UserTokenResponse> hashMap = this.responses;
        synchronized (hashMap) {
            if (this.responses.containsKey(userId)) {
                return this.responses.get(userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUserSession(@NonNull String userId) {
        Log.d((String)this.TAG, (String)("cleanUserSession: clean the information for user " + userId));
        try {
            HashMap<String, UserTokenResponse> hashMap = this.responses;
            synchronized (hashMap) {
                if (this.responses.containsKey(userId)) {
                    this.responses.remove(userId);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("cleanUserSession: error while removing user session := " + userId));
            e.printStackTrace();
        }
    }
}

