package voxeet.com.sdk.core.network.websocket;

import okhttp3.WebSocket;
import voxeet.com.sdk.core.services.authenticate.WebSocketState;
import voxeet.com.sdk.events.error.HttpException;

/**
 * The interface Socket listener which can be used when trying to connect to the server.
 */
public interface SocketListener {
    /**
     * On connect.
     */
    void onConnect(WebSocket webSocket);

    void onTextMessage(String message);

    void onError(HttpException exception);

    void onClose();

    void onStateChanged(WebSocketState newState);

    void onDisconnected();
}
