package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Created by Thomas on 20/10/2015.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.VIDEO_PRESENTATION_STARTED)
public class VideoPresentationStarted extends Event {

    private String key;

    private String conferenceId;

    private String userId;

    private String url;

    private long timestamp;

    public VideoPresentationStarted() {

    }

    public VideoPresentationStarted(String key, String conferenceId, String userId, String url, long timestamp) {
        this();
        setKey(key);
        setConferenceId(conferenceId);
        setUserId(userId);
        setUrl(url);
        setTimestamp(timestamp);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getKey() {
        return key;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public String getUserId() {
        return userId;
    }

    public String getUrl() {
        return url;
    }

    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public String getType() {
        return EventNames.VIDEO_PRESENTATION_STARTED;
    }
}
