/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.network.websocket;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import voxeet.com.sdk.core.VoxeetHttp;
import voxeet.com.sdk.core.network.websocket.ConnectListener;
import voxeet.com.sdk.core.network.websocket.SocketListener;
import voxeet.com.sdk.core.services.authenticate.WebSocketState;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.utils.DeviceStateUtils;

public class WebSocketProxy
implements Runnable {
    private static final Handler HANDLER = new Handler();
    private static final int MAXIMUM_RETRY = 60;
    private static final long SOCKET_RETRY_MAX = 10000L;
    private static final long SOCKET_RETRY_AFTER = 500L;
    private static final String TAG = WebSocketProxy.class.getSimpleName();
    private WebSocketState mState = WebSocketState.CLOSED;
    private Context mContext;
    private ExecutorService mExecutorService;
    private String mSocketUrl;
    private int mCount = 0;
    private boolean shouldRetry = true;
    private WebSocketListener mAdapter;
    private List<SocketListener> mListeners;
    private long mSocketCurrentRetryDelay;
    private WebSocket mWebSocket;
    private ConnectListener mConnectListener;
    private boolean isCanceled = false;
    private VoxeetHttp mProvider;

    public WebSocketProxy(Context context, @NonNull String socketUrl) {
        this.mSocketUrl = socketUrl;
        this.mContext = context;
        this.mExecutorService = Executors.newSingleThreadExecutor();
        this.mListeners = new ArrayList<SocketListener>();
        this.mSocketCurrentRetryDelay = 500L;
        this.mCount = 0;
        this.mAdapter = new WebSocketListener(){

            public void onOpen(@NonNull WebSocket websocket, @NonNull Response response) {
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                WebSocketProxy.this.mWebSocket = websocket;
                WebSocketProxy.this.mState = WebSocketState.CONNECTED;
                WebSocketProxy.this.mSocketCurrentRetryDelay = 500L;
                WebSocketProxy.this.mCount = 0;
                WebSocketProxy.this.shouldRetry = true;
                try {
                    WebSocketProxy.this.attemptConnectListenerConnected(websocket);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.onStateChanged(websocket, WebSocketProxy.this.mState);
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    try {
                        listener.onConnect(websocket);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onMessage(@NonNull WebSocket websocket, @NonNull String message) {
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    try {
                        listener.onTextMessage(message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onFailure(@NonNull WebSocket websocket, @NonNull Throwable cause, Response response) {
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                cause.printStackTrace();
                HttpException error = HttpException.throwResponse(response);
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    try {
                        listener.onError(error);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                WebSocketProxy.this.mState = WebSocketState.CLOSING;
            }

            public void onClosed(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                Log.d((String)TAG, (String)("onClosed: reason := " + reason));
                if (WebSocketProxy.this.shouldRetry) {
                    if (WebSocketProxy.this.mCount < 60) {
                        WebSocketProxy.this.mState = WebSocketState.CONNECTING;
                        WebSocketProxy.this.mCount++;
                        WebSocketProxy.this.mSocketCurrentRetryDelay = Math.min(WebSocketProxy.this.mSocketCurrentRetryDelay * 2L, 10000L);
                        HANDLER.postDelayed((Runnable)WebSocketProxy.this, WebSocketProxy.this.mSocketCurrentRetryDelay);
                    } else {
                        WebSocketProxy.this.mState = WebSocketState.CLOSED;
                        WebSocketProxy.this.attemptConnectListenerDisconnected();
                        WebSocketProxy.this.onDisconnected();
                    }
                } else {
                    WebSocketProxy.this.mState = WebSocketState.CLOSED;
                    this.onStateChanged(webSocket, WebSocketProxy.this.mState);
                    WebSocketProxy.this.onDisconnected();
                }
            }

            void onStateChanged(WebSocket websocket, WebSocketState newState) {
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    try {
                        listener.onStateChanged(newState);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    private void attemptConnectListenerDisconnected() {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        if (this.mConnectListener != null) {
            this.mConnectListener.onConnectError(new HttpException((Response)null));
            this.mConnectListener = null;
        }
    }

    private void attemptConnectListenerConnected(WebSocket webSocket) {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        if (this.mConnectListener != null) {
            this.mConnectListener.onConnect(webSocket);
            this.mConnectListener = null;
        }
    }

    private Request setWebSocketRequest() {
        if (this.isCanceled) {
            this.checkCancel();
            return null;
        }
        String socketUrl = this.mSocketUrl;
        String jwtToken = this.mProvider.getJwtToken();
        if (null != jwtToken) {
            socketUrl = !socketUrl.contains("?") ? socketUrl + "?Token=" + jwtToken : socketUrl + "Token=" + jwtToken;
            Log.d((String)TAG, (String)("setWebSocketRequest: socketUrl := " + socketUrl));
            return new Request.Builder().url(socketUrl).build();
        }
        return null;
    }

    public void connect(@NonNull VoxeetHttp provider, @Nullable ConnectListener connectListener) {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        this.mConnectListener = connectListener;
        this.mProvider = provider;
        Request request = this.setWebSocketRequest();
        this.mState = WebSocketState.CONNECTING;
        this.mWebSocket = provider.getClient().newWebSocket(request, this.mAdapter);
    }

    private void onDisconnected() {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        for (SocketListener listener : this.mListeners) {
            listener.onDisconnected();
        }
    }

    public void addListener(@NonNull SocketListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(@NonNull SocketListener listener) {
        if (this.mListeners.contains(listener)) {
            this.mListeners.remove(listener);
        }
    }

    @Override
    public void run() {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        Log.d((String)TAG, (String)("run: isNetworkAvailable := " + DeviceStateUtils.isNetworkAvailable(this.mContext)));
        this.connect(this.mProvider, this.mConnectListener);
    }

    public boolean isOpen() {
        return WebSocketState.CONNECTED.equals((Object)this.mState);
    }

    public boolean sendPing() {
        Log.e((String)TAG, (String)"sendPing:");
        return false;
    }

    public void disconnect() {
        this.mState = WebSocketState.CLOSED;
        this.mCount = 60;
        this.shouldRetry = false;
        if (null != this.mWebSocket) {
            this.mWebSocket.close(1000, "Closing socket from client");
        }
        for (SocketListener listener : this.mListeners) {
            listener.onClose();
        }
        this.mExecutorService.shutdown();
    }

    public void removeListeners() {
        this.mListeners.clear();
        this.mAdapter = null;
    }

    public WebSocketState getState() {
        return this.mState;
    }

    public WebSocket getWebSocket() {
        return this.mWebSocket;
    }

    private void checkCancel() {
        Log.d((String)TAG, (String)("checkCancel: isCanceled:=" + this.isCanceled + " isOpen:=" + this.isOpen()));
        if (this.isCanceled && this.isOpen()) {
            this.disconnect();
        }
    }

    public void cancel() {
        this.removeListeners();
        this.isCanceled = true;
    }
}

