/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.abs;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.android.media.audio.AudioRoute;
import com.voxeet.android.media.peer.PendingPeerCallback;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.video.Camera2Enumerator;
import com.voxeet.kernel.R;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.VideoRenderer;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import voxeet.com.sdk.audio.MessagingEnvironment;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.ConferenceSimpleState;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.abs.information.ConferenceInformation;
import voxeet.com.sdk.core.abs.information.ConferenceInformationHolder;
import voxeet.com.sdk.core.abs.information.ConferenceState;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.core.services.AudioService;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.core.services.SdkConferenceService;
import voxeet.com.sdk.core.services.TimeoutRunnable;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.events.error.CameraSwitchErrorEvent;
import voxeet.com.sdk.events.error.ConferenceCreatedError;
import voxeet.com.sdk.events.error.ConferenceJoinedError;
import voxeet.com.sdk.events.error.ConferenceLeftError;
import voxeet.com.sdk.events.error.GetConferenceHistoryErrorEvent;
import voxeet.com.sdk.events.error.GetConferenceStatusErrorEvent;
import voxeet.com.sdk.events.error.HttpException;
import voxeet.com.sdk.events.error.ParticipantAddedErrorEvent;
import voxeet.com.sdk.events.error.PermissionRefusedEvent;
import voxeet.com.sdk.events.error.ReplayConferenceErrorEvent;
import voxeet.com.sdk.events.error.SdkLogoutErrorEvent;
import voxeet.com.sdk.events.error.SubscribeConferenceErrorEvent;
import voxeet.com.sdk.events.error.SubscribeForCallConferenceErrorEvent;
import voxeet.com.sdk.events.error.UnsubscribeFromCallConferenceErrorEvent;
import voxeet.com.sdk.events.promises.InConferenceException;
import voxeet.com.sdk.events.promises.NotInConferenceException;
import voxeet.com.sdk.events.promises.PromiseConferenceJoinedErrorException;
import voxeet.com.sdk.events.promises.PromiseDeclineConferenceResultEventException;
import voxeet.com.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import voxeet.com.sdk.events.promises.PromiseParticipantAddedErrorEventException;
import voxeet.com.sdk.events.promises.PromisePermissionRefusedEventException;
import voxeet.com.sdk.events.success.AddConferenceParticipantResultEvent;
import voxeet.com.sdk.events.success.CameraSwitchSuccessEvent;
import voxeet.com.sdk.events.success.ConferenceCreatingEvent;
import voxeet.com.sdk.events.success.ConferenceCreationSuccess;
import voxeet.com.sdk.events.success.ConferenceDestroyedPushEvent;
import voxeet.com.sdk.events.success.ConferenceEndedEvent;
import voxeet.com.sdk.events.success.ConferenceJoinedSuccessEvent;
import voxeet.com.sdk.events.success.ConferenceLeftSuccessEvent;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.events.success.ConferenceRefreshedEvent;
import voxeet.com.sdk.events.success.ConferenceStatsEvent;
import voxeet.com.sdk.events.success.ConferenceUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUserAddedEvent;
import voxeet.com.sdk.events.success.ConferenceUserCallDeclinedEvent;
import voxeet.com.sdk.events.success.ConferenceUserJoinedEvent;
import voxeet.com.sdk.events.success.ConferenceUserLeftEvent;
import voxeet.com.sdk.events.success.ConferenceUserQualityUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUserUpdatedEvent;
import voxeet.com.sdk.events.success.ConferenceUsersInvitedEvent;
import voxeet.com.sdk.events.success.DeclineConferenceResultEvent;
import voxeet.com.sdk.events.success.GetConferenceHistoryEvent;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.IncomingCallEvent;
import voxeet.com.sdk.events.success.InvitationReceived;
import voxeet.com.sdk.events.success.OfferCreatedEvent;
import voxeet.com.sdk.events.success.OwnConferenceStartedEvent;
import voxeet.com.sdk.events.success.ParticipantAddedEvent;
import voxeet.com.sdk.events.success.ParticipantUpdatedEvent;
import voxeet.com.sdk.events.success.QualityIndicators;
import voxeet.com.sdk.events.success.QualityUpdatedEvent;
import voxeet.com.sdk.events.success.RecordingStatusUpdate;
import voxeet.com.sdk.events.success.RenegociationEndedEvent;
import voxeet.com.sdk.events.success.RenegociationUpdate;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.events.success.ScreenStreamAddedEvent;
import voxeet.com.sdk.events.success.ScreenStreamRemovedEvent;
import voxeet.com.sdk.events.success.SdkLogoutSuccessEvent;
import voxeet.com.sdk.events.success.SendBroadcastResultEvent;
import voxeet.com.sdk.events.success.StartRecordingResultEvent;
import voxeet.com.sdk.events.success.StartScreenShareAnswerEvent;
import voxeet.com.sdk.events.success.StartVideoAnswerEvent;
import voxeet.com.sdk.events.success.StopRecordingResultEvent;
import voxeet.com.sdk.events.success.StopScreenShareAnswerEvent;
import voxeet.com.sdk.events.success.StopVideoAnswerEvent;
import voxeet.com.sdk.events.success.SubscribeConferenceEvent;
import voxeet.com.sdk.events.success.SubscribeForCallConferenceAnswerEvent;
import voxeet.com.sdk.events.success.UnSubscribeConferenceAnswerEvent;
import voxeet.com.sdk.events.success.UnSubscribeFromConferenceAnswerEvent;
import voxeet.com.sdk.factories.VoxeetIntentFactory;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.ConferenceStats;
import voxeet.com.sdk.json.ConferenceUserAdded;
import voxeet.com.sdk.json.CreateConferenceParams;
import voxeet.com.sdk.json.DeviceEvent;
import voxeet.com.sdk.json.InvitationReceivedEvent;
import voxeet.com.sdk.json.OfferCreated;
import voxeet.com.sdk.json.RecordingStatusUpdateEvent;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartScreenSharingResponse;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopScreenSharingResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.json.internal.MetadataHolder;
import voxeet.com.sdk.json.internal.ParamsHolder;
import voxeet.com.sdk.models.CandidatesPush;
import voxeet.com.sdk.models.ConferenceQuality;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.ConferenceType;
import voxeet.com.sdk.models.ConferenceUserStatus;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.NormalConferenceResponse;
import voxeet.com.sdk.models.OfferCandidate;
import voxeet.com.sdk.models.OfferDescription;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.SubscribeConference;
import voxeet.com.sdk.models.abs.Conference;
import voxeet.com.sdk.models.abs.ConferenceUser;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultInvitation;
import voxeet.com.sdk.models.impl.DefaultParticipant;
import voxeet.com.sdk.networking.DeviceType;
import voxeet.com.sdk.utils.ConferenceListener;
import voxeet.com.sdk.utils.Twig;
import voxeet.com.sdk.utils.Validate;

public abstract class AbstractConferenceSdkService<T, COP extends AbstractConferenceSdkObservableProvider<T, DemoEvent>, DemoEvent>
extends AbstractVoxeetService<T>
implements SdkConferenceService,
ConferenceListener {
    private static final String TAG = AbstractConferenceSdkService.class.getSimpleName();
    private final VoxeetSdkTemplate mInstance;
    private VoxeetSdkTemplate mSDK;
    private ConferenceListener mListener;
    private AbstractConferenceSdkObservableProvider mConferenceObservableProvider;
    private Twig mTwig;
    private EventBus mEventBus;
    private final MessagingEnvironment mEnvironment;
    private boolean isListenerMode = false;
    private boolean isVideoOn = false;
    private boolean isScreenshareOn = false;
    private boolean isRecording = false;
    private boolean mInConference = false;
    private long mTimeOutTimer = -1L;
    private HashMap<String, MediaStream> mapOfStreams = new HashMap();
    private HashMap<String, MediaStream> mapOfScreenShareStreams = new HashMap();
    private ReentrantLock joinLock = new ReentrantLock();
    private String mDefaultCamera;
    private boolean mEnableStats;
    private boolean isDefaultOnSpeaker;
    private String mConferenceId = null;
    private ConferenceInformationHolder mConferenceInformationHolder = new ConferenceInformationHolder();
    protected Context mContext;
    @Nullable
    private TimeoutRunnable timeoutRunnable = null;
    private MediaEngine.StreamListener mediaStreamListener = new MediaEngine.StreamListener(){

        public void onStreamAdded(final @NonNull String peer, final @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onStreamAdded: screen for peer " + peer));
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.getTwig().i("New mConference user joined with id: " + peer + " checking... (ours is " + VoxeetPreferences.id(), new Object[0]);
                    AbstractConferenceSdkService.this.mapOfStreams.put(peer, stream);
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.updateConferenceParticipants(peer, ConferenceUserStatus.ON_AIR);
                    if (user != null) {
                        AbstractConferenceSdkService.this.getTwig().i("New mConference user joined with id: " + user.getUserId(), new Object[0]);
                        if (!peer.equalsIgnoreCase(VoxeetPreferences.id()) && AbstractConferenceSdkService.this.mTimeOutTimer != -1L) {
                            AbstractConferenceSdkService.this.mTwig.i("Cancelling timeout timer", new Object[0]);
                            AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                        }
                        AbstractConferenceSdkService.this.updateConferenceFromUsers();
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream added");
                    }
                }
            });
        }

        public void onStreamUpdated(final @NonNull String peer, final @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onStreamUpdated: screen for peer " + peer));
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.getTwig().i("Conference user updated with id: " + peer + " checking... (ours is " + VoxeetPreferences.id(), new Object[0]);
                    AbstractConferenceSdkService.this.getTwig().i("stream updated having video ? " + (stream.videoTracks().size() > 0) + " screenshare := " + stream.isScreenShare(), new Object[0]);
                    if (stream.isScreenShare().booleanValue()) {
                        AbstractConferenceSdkService.this.mapOfScreenShareStreams.put(peer, stream);
                    } else {
                        AbstractConferenceSdkService.this.mapOfStreams.put(peer, stream);
                    }
                    DefaultConferenceUser user = AbstractConferenceSdkService.this.findUserById(peer);
                    if (user != null) {
                        AbstractConferenceSdkService.this.getTwig().i("Conference user updated with id: " + user.getUserId(), new Object[0]);
                        AbstractConferenceSdkService.this.updateConferenceFromUsers();
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream updated");
                    }
                }
            });
        }

        public void onStreamRemoved(final @NonNull String peer) {
            Log.d((String)TAG, (String)"onStreamRemoved: OnStreamRemoved");
            AbstractConferenceSdkService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    AbstractConferenceSdkService.this.onUserLeft(peer);
                }
            });
        }

        public void onScreenStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
            Log.d((String)TAG, (String)("onScreenStreamAdded: screen for peer " + peer));
            AbstractConferenceSdkService.this.getTwig().i("(for ScreenShare) Conference user updated with id: " + peer + " checking... (ours is " + VoxeetPreferences.id(), new Object[0]);
            AbstractConferenceSdkService.this.getTwig().i("screenshare stream updated having video ? " + stream.videoTracks().size() + " :: has stream inside ? " + (stream.videoTracks().size() > 0), new Object[0]);
            AbstractConferenceSdkService.this.mapOfScreenShareStreams.put(peer, stream);
            AbstractConferenceSdkService.this.mEventBus.post((Object)new ScreenStreamAddedEvent(peer, stream));
        }

        public void onScreenStreamRemoved(@NonNull String peer) {
            AbstractConferenceSdkService.this.getTwig().i("Screen share stream removed: " + peer, new Object[0]);
            AbstractConferenceSdkService.this.mapOfScreenShareStreams.remove(peer);
            AbstractConferenceSdkService.this.mEventBus.post((Object)new ScreenStreamRemovedEvent(peer));
        }

        public void onShutdown() {
        }

        public void onIceCandidateDiscovered(String peer, SdpCandidate[] candidates) {
            if (null == AbstractConferenceSdkService.this.getConferenceId()) {
                return;
            }
            Call<ResponseBody> call = AbstractConferenceSdkService.this.mConferenceObservableProvider.candidates(AbstractConferenceSdkService.this.getConferenceId(), peer, new CandidatesPush(candidates));
            call.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    Log.d((String)TAG, (String)"onResponse: Candidates sent ");
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    t.printStackTrace();
                }
            });
        }
    };

    public AbstractConferenceSdkService(VoxeetSdkTemplate instance, COP conference_observable_provider, long timeout, @NonNull ServiceProviderHolder<T> holder) {
        super(instance, holder);
        this.mInstance = instance;
        this.mEnableStats = false;
        if (Build.VERSION.SDK_INT >= 21) {
            this.mDefaultCamera = new Camera2Enumerator(instance.getApplicationContext()).getNameOfFrontFacingDevice();
        } else {
            Camera1Enumerator enumerator = new Camera1Enumerator(false);
            String[] names = enumerator.getDeviceNames();
            if (null != names && names.length > 0) {
                for (String name : names) {
                    if (!enumerator.isFrontFacing(name)) continue;
                    this.mDefaultCamera = name;
                }
            }
        }
        this.mConferenceObservableProvider = conference_observable_provider;
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider(this.getService());
        this.mListener = instance;
        this.mSDK = instance;
        this.mTimeOutTimer = timeout;
        this.mTwig = instance.getTwig();
        this.mEventBus = EventBus.getDefault();
        this.mContext = instance.getApplicationContext();
        this.setDefaultBuiltInSpeaker(true);
        this.mEnvironment = new MessagingEnvironment.Builder(this.mContext).setServerHost(R.string.session_manager_url).setServerPort(R.string.connectionManagerPort).setStunHost(R.string.stunHost).setStunPort(R.string.stunPort).build();
        this.register();
    }

    @Deprecated
    public boolean muteConference(boolean mute) {
        return this.mute(mute);
    }

    @Override
    public boolean mute(boolean mute) {
        if (this.getMediaService().hasMedia()) {
            if (!mute && this.getMediaService().getMedia().isMuted()) {
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getTwig().i("No permission for mic... please check it", new Object[0]);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                this.getTwig().i("Conference unmuted", new Object[0]);
                this.getAudioService().setInVoiceCallSoundType();
                this.getMedia().unMute();
            } else if (mute) {
                this.getTwig().i("Conference muted", new Object[0]);
                this.getAudioService().setInVoiceCallSoundType();
                this.getMedia().mute();
            }
        }
        return true;
    }

    @Override
    public boolean isMuted() {
        return this.getMedia() != null && this.getMedia().isMuted();
    }

    @Override
    public boolean isUserMuted(String userId) {
        DefaultConferenceUser user = this.findUserById(userId);
        return user != null && user.isMuted();
    }

    @Override
    public void setListenerMode(boolean isListener) {
        if (this.getMediaService().hasMedia()) {
            MediaSDK media = this.getMediaService().getMedia();
            if (media.isMuted()) {
                media.unMute();
            } else {
                media.mute();
            }
            this.getAudioService().setInVoiceCallSoundType();
        }
    }

    @Override
    @Deprecated
    public boolean attachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (this.getMediaService().hasMedia()) {
            this.getMedia().attachMediaStream(render, stream);
        }
        return this.getMediaService().hasMedia();
    }

    @Override
    @Deprecated
    public boolean unAttachMediaStream(MediaStream stream, VideoRenderer.Callbacks render) {
        if (this.getMediaService().hasMedia()) {
            this.getMedia().unattachMediaStream(render, stream);
        }
        return this.getMediaService().hasMedia();
    }

    @Override
    public void register() {
        this.registerEventBus();
    }

    @Override
    public void unregister() {
        this.unRegisterEventBus();
    }

    public void setDefaultCamera(String cameraName) {
        this.mDefaultCamera = cameraName;
    }

    @Override
    public void toggleVideo() {
        Promise<Boolean> promise = this.isVideoOn() ? this.stopVideo() : this.startVideo();
        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggleVideo " + result));
            }
        }).error(new ErrorPromise(){

            public void onError(Throwable error) {
                error.printStackTrace();
            }
        });
    }

    public void toggleScreenShare() {
        if (this.isScreenShareOn()) {
            this.stopScreenShare().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onSuccess: toggleScreenShare " + result));
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    Log.d((String)TAG, (String)"onError: toggleScreenShare");
                    error.printStackTrace();
                }
            });
        } else {
            this.getVoxeetSDK().getScreenShareService().sendRequestStartScreenShare();
        }
    }

    @Override
    public String getCurrentConferenceId() {
        Validate.runningOnUiThread();
        return this.mConferenceId;
    }

    @Override
    public int getConferenceRoomSize() {
        DefaultConference conference = this.getCurrentConferenceInformation().getConference();
        return conference.getConferenceRoomSize();
    }

    @Override
    public String currentSpeaker() {
        DefaultConference conference = this.getConference();
        if (!this.hasMedia() || conference == null) {
            return VoxeetPreferences.id();
        }
        String currentSpeaker = null;
        for (DefaultConferenceUser user : conference.getConferenceUsers()) {
            if (user.getUserId() == null || user.getUserId().equals(VoxeetPreferences.id()) || !ConferenceUserStatus.ON_AIR.equals((Object)user.getConferenceStatus())) continue;
            double peerVuMeter = this.getMedia().getPeerVuMeter(user.getUserId());
            if (currentSpeaker != null && (!(peerVuMeter > 0.001) || !(this.getMedia().getPeerVuMeter(currentSpeaker) < peerVuMeter))) continue;
            currentSpeaker = user.getUserId();
        }
        return currentSpeaker;
    }

    @NonNull
    private String currentUserOrEmpty() {
        String currentUserId = VoxeetPreferences.id();
        return null != currentUserId ? currentUserId : "";
    }

    @Override
    public double getSdkPeerVuMeter(@Nullable String peerId) {
        Validate.runningOnUiThread();
        return this.hasMedia() && null != peerId ? this.getMedia().getPeerVuMeter(peerId) : 0.0;
    }

    public DefaultConferenceUser findUserById(String userId) {
        DefaultConference conference = this.getConference();
        return null != conference ? this.findUserById((Conference)conference, userId) : null;
    }

    private DefaultConferenceUser findUserById(@NonNull Conference conference, final String userId) {
        Log.d((String)TAG, (String)("findUserById: looking for USER " + userId));
        return (DefaultConferenceUser)Iterables.find((Iterable)conference.getConferenceUsers(), (Predicate)new Predicate<DefaultConferenceUser>(){

            public boolean apply(DefaultConferenceUser input) {
                return userId.equalsIgnoreCase(input.getUserId());
            }
        }, null);
    }

    @Override
    public String getAliasId() {
        DefaultConference conference = this.getConference();
        return null != conference ? conference.getConferenceAlias() : null;
    }

    @Override
    public String getConferenceId() {
        return this.mConferenceId;
    }

    @Deprecated
    public List<AudioRoute> getAvailableRoutes() {
        return this.getAudioService().getAvailableRoutes();
    }

    @Deprecated
    public AudioRoute currentRoute() {
        return this.getAudioService().currentRoute();
    }

    @Override
    @Nullable
    public EglBase.Context getEglContext() {
        return this.getMediaService().getEglContext();
    }

    @Override
    public long getTimeout() {
        return this.mTimeOutTimer;
    }

    @Override
    public void toggleRecording() {
        Promise<Boolean> promise = this.isRecording ? this.stopRecording() : this.startRecording();
        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onSuccess: toggle done " + result));
            }
        }).error(new ErrorPromise(){

            public void onError(Throwable error) {
                error.printStackTrace();
            }
        });
    }

    @Override
    public boolean muteUser(@NonNull String userId, boolean shouldMute) {
        Validate.runningOnUiThread();
        DefaultConferenceUser user = this.findUserById(userId);
        if (user != null) {
            this.getTwig().i("Setting mute property for mConference participant with id " + userId + " to " + shouldMute, new Object[0]);
            this.startTransactionConferenceUser();
            user.setMuted(shouldMute);
            this.getMedia().changePeerGain(userId, shouldMute ? 10000.0f : 1.0f);
            this.commitTransactionConferenceUser();
        }
        return user != null;
    }

    public boolean isVideoOn() {
        return this.isVideoOn;
    }

    public boolean isScreenShareOn() {
        return this.isScreenshareOn;
    }

    @Deprecated
    public boolean setAudioRoute(AudioRoute route) {
        return this.getAudioService().setAudioRoute(route);
    }

    public boolean setDefaultBuiltInSpeaker(boolean default_state) {
        this.isDefaultOnSpeaker = default_state;
        return true;
    }

    @Override
    public boolean setTimeOut(long timeout) {
        this.getTwig().i("Timeout set to " + timeout, new Object[0]);
        this.mTimeOutTimer = timeout;
        return true;
    }

    @Override
    public boolean setUserPosition(String userId, double angle, double distance) {
        if (this.hasMedia()) {
            this.getMedia().changePeerPosition(userId, angle, distance);
        }
        return this.hasMedia();
    }

    @NonNull
    public ConferenceSimpleState getConferenceType() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information || null == this.mConferenceId) {
            return ConferenceSimpleState.NONE;
        }
        return information.getConferenceType();
    }

    @Nullable
    public DefaultConference getConference() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information) {
            return null;
        }
        return information.getConference();
    }

    @NonNull
    private DefaultConference getOrSetConference(@NonNull String conferenceId) {
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        if (null != information) {
            return information.getConference();
        }
        Log.d((String)TAG, (String)("getOrSetConference: INVALID CALL FOR GET OR SET CONFERENCE WITH " + conferenceId));
        return new DefaultConference();
    }

    public boolean isInConference() {
        return this.mInConference;
    }

    protected void setIsInConference(boolean status) {
        this.mInConference = status;
    }

    public double getPeerVuMeter(@Nullable String peerId) {
        Validate.runningOnUiThread();
        if (this.hasMedia() && null != peerId) {
            return this.getMedia().getPeerVuMeter(peerId);
        }
        return 0.0;
    }

    @Override
    @NonNull
    public List<DefaultConferenceUser> getConferenceUsers() {
        DefaultConference conference = this.getConference();
        if (null == conference) {
            return new ArrayList<DefaultConferenceUser>();
        }
        return conference.getConferenceUsers();
    }

    @NonNull
    public List<DefaultConferenceUser> getLastInvitationUsers() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null == information) {
            return new ArrayList<DefaultConferenceUser>();
        }
        return information.getLastInvitationReceived();
    }

    @Override
    public boolean isLive() {
        return null != this.getConference();
    }

    @Override
    public boolean isListenerMode() {
        return this.isListenerMode;
    }

    @Nullable
    public ConferenceUser getUser(final String userId) {
        DefaultConference conference = this.getConference();
        if (null != conference && conference.getConferenceUsers() != null) {
            return (ConferenceUser)Iterables.find((Iterable)conference.getConferenceUsers(), (Predicate)new Predicate<ConferenceUser>(){

                public boolean apply(ConferenceUser input) {
                    return userId.equals(input.getUserId());
                }
            }, null);
        }
        return null;
    }

    @Deprecated
    @NonNull
    public HashMap<String, MediaStream> getMapOfStreams() {
        return this.mapOfStreams;
    }

    @Deprecated
    @NonNull
    public HashMap<String, MediaStream> getMapOfScreenShareStreams() {
        return this.mapOfScreenShareStreams;
    }

    public AbstractConferenceSdkService<T, COP, DemoEvent> cancelTimeout() {
        this.removeTimeoutCallbacks();
        return this;
    }

    protected abstract Promise<Boolean> onCreateDemoSuccess(DemoEvent var1);

    @Override
    public Promise<Boolean> listenConference(@NonNull String conferenceId) {
        this.isListenerMode = true;
        this.getTwig().i("Listener mode set to true", new Object[0]);
        this.createOrSetConferenceWithParams(conferenceId, null);
        return this.joinVoxeetConference(conferenceId);
    }

    @Override
    public Promise<DeclineConferenceResultEvent> decline(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<DeclineConferenceResultEvent>(){

            public void onCall(final @NonNull Solver<DeclineConferenceResultEvent> solver) {
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getDeclineObservable(conferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().i("IConference declined with id: " + conferenceId, new Object[0]);
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(response.code() == 200);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        solver.resolve((Object)event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable t, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e(t);
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(AbstractConferenceSdkService.this.handleError(t), false);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        solver.reject((Throwable)new PromiseDeclineConferenceResultEventException(event));
                    }
                });
            }
        });
    }

    public void sendRequestStartScreenShare() {
        this.getVoxeetSDK().getScreenShareService().sendRequestStartScreenShare();
    }

    public void onUserCanceledScreenShare() {
        if (this.hasMedia()) {
            this.getMedia().stopScreenCapturer();
        }
        this.isScreenshareOn = false;
    }

    public Promise<Boolean> startScreenShare(final Intent intent, final int width, final int height) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    if (AbstractConferenceSdkService.this.isScreenShareOn()) {
                        solver.resolve((Object)true);
                    }
                    if (!AbstractConferenceSdkService.this.hasMedia()) {
                        Log.d((String)TAG, (String)"startScreenShare: media is null");
                        throw new MediaEngineException("Media is null, invalid state");
                    }
                    AbstractConferenceSdkService.this.isScreenshareOn = true;
                    AbstractConferenceSdkService.this.getMedia().startScreenCapturer(intent, width, height);
                    Call<StartScreenSharingResponse> startScreenShare = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStartScreenShareObservable(AbstractConferenceSdkService.this.mConferenceId, VoxeetPreferences.id());
                    AbstractConferenceSdkService.this.enqueue(startScreenShare, new HttpCallback<StartScreenSharingResponse>(){

                        @Override
                        public void onSuccess(@NonNull StartScreenSharingResponse object, @NonNull Response<StartScreenSharingResponse> response) {
                            StartScreenSharingResponse body = (StartScreenSharingResponse)response.body();
                            AbstractConferenceSdkService.this.isScreenshareOn = true;
                            StartScreenShareAnswerEvent event = new StartScreenShareAnswerEvent(true);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            AbstractConferenceSdkService.this.createVideoAnswer(body.getUserId(), body.getDescription(), body.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onCall: createVideoAnswer := having result " + aBoolean));
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<StartScreenSharingResponse> response) {
                            HttpException.dumpErrorResponse(response);
                            AbstractConferenceSdkService.this.mTwig.e(e);
                            AbstractConferenceSdkService.this.isScreenshareOn = false;
                            StartScreenShareAnswerEvent event = new StartScreenShareAnswerEvent(false);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            solver.reject(e);
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Promise<Boolean> stopScreenShare() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    String conferenceId = AbstractConferenceSdkService.this.getCurrentConferenceId();
                    if (!AbstractConferenceSdkService.this.isInConference()) {
                        Log.d((String)TAG, (String)"stopScreenShare: not in conf");
                        if (AbstractConferenceSdkService.this.hasMedia()) {
                            AbstractConferenceSdkService.this.getMedia().stopScreenCapturer();
                        }
                        throw new NotInConferenceException();
                    }
                    if (AbstractConferenceSdkService.this.hasMedia()) {
                        Log.d((String)TAG, (String)"stopScreenShare: media is null");
                        throw new MediaEngineException("media is null");
                    }
                    AbstractConferenceSdkService.this.getMedia().stopScreenCapturer();
                    Call<StopScreenSharingResponse> stopVideo = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStopScreenShareObservable(conferenceId, VoxeetPreferences.id());
                    AbstractConferenceSdkService.this.enqueue(stopVideo, new HttpCallback<StopScreenSharingResponse>(){

                        @Override
                        public void onSuccess(@NonNull StopScreenSharingResponse object, @NonNull Response<StopScreenSharingResponse> response) {
                            AbstractConferenceSdkService.this.getMedia().stopScreenCapturer();
                            AbstractConferenceSdkService.this.isScreenshareOn = false;
                            StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(true);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            AbstractConferenceSdkService.this.createVideoAnswer(object.getUserId(), object.getDescription(), object.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<StopScreenSharingResponse> response) {
                            HttpException.dumpErrorResponse(response);
                            AbstractConferenceSdkService.this.getTwig().e(e);
                            AbstractConferenceSdkService.this.isScreenshareOn = false;
                            StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(false);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            solver.reject(e);
                        }
                    });
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (Exception exception) {
                    solver.reject((Throwable)exception);
                }
            }
        });
    }

    public Promise<Boolean> startVideo() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    if (!Validate.hasCameraPermissions(AbstractConferenceSdkService.this.mContext)) {
                        PermissionRefusedEvent event = new PermissionRefusedEvent(PermissionRefusedEvent.Permission.CAMERA);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        throw new PromisePermissionRefusedEventException(event);
                    }
                    if (!AbstractConferenceSdkService.this.hasMedia()) {
                        Log.d((String)TAG, (String)"startVideo: media is null");
                        throw new MediaEngineException("Media is null, invalid state");
                    }
                    if (AbstractConferenceSdkService.this.isVideoOn()) {
                        Log.d((String)"SDKMEDIA", (String)"startVideo: already started... please wait if you wanted to stop");
                        solver.resolve((Object)true);
                        return;
                    }
                    AbstractConferenceSdkService.this.getMedia().startVideo(AbstractConferenceSdkService.this.mDefaultCamera);
                    Call<StartVideoResponse> startVideo = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStartVideoObservable(AbstractConferenceSdkService.this.mConferenceId, VoxeetPreferences.id());
                    AbstractConferenceSdkService.this.enqueue(startVideo, new HttpCallback<StartVideoResponse>(){

                        @Override
                        public void onSuccess(@NonNull StartVideoResponse object, @NonNull Response<StartVideoResponse> response) {
                            AbstractConferenceSdkService.this.isVideoOn = true;
                            StartVideoAnswerEvent event = new StartVideoAnswerEvent(true);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            AbstractConferenceSdkService.this.createVideoAnswer(object.getUserId(), object.getDescription(), object.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<StartVideoResponse> response) {
                            HttpException.dumpErrorResponse(response);
                            AbstractConferenceSdkService.this.mTwig.e(e);
                            AbstractConferenceSdkService.this.isVideoOn = false;
                            StartVideoAnswerEvent event = new StartVideoAnswerEvent(false);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            solver.reject(e);
                        }
                    });
                }
                catch (PromisePermissionRefusedEventException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (Exception exception) {
                    solver.reject((Throwable)exception);
                }
            }
        });
    }

    public Promise<Boolean> stopVideo() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    String conferenceId = AbstractConferenceSdkService.this.getCurrentConferenceId();
                    if (!AbstractConferenceSdkService.this.isInConference()) {
                        Log.d((String)TAG, (String)"stopVideo: not in conf");
                        if (AbstractConferenceSdkService.this.hasMedia()) {
                            AbstractConferenceSdkService.this.getMedia().stopVideo();
                        }
                        throw new NotInConferenceException();
                    }
                    if (!AbstractConferenceSdkService.this.hasMedia()) {
                        Log.d((String)TAG, (String)"startVideo: media is null");
                        throw new MediaEngineException("media is null");
                    }
                    AbstractConferenceSdkService.this.getMedia().stopVideo();
                    Call<StopVideoResponse> stopVideo = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStopVideoObservable(conferenceId, VoxeetPreferences.id());
                    AbstractConferenceSdkService.this.enqueue(stopVideo, new HttpCallback<StopVideoResponse>(){

                        @Override
                        public void onSuccess(@NonNull StopVideoResponse object, @NonNull Response<StopVideoResponse> response) {
                            AbstractConferenceSdkService.this.getMedia().stopVideo();
                            AbstractConferenceSdkService.this.isVideoOn = false;
                            StopVideoAnswerEvent event = new StopVideoAnswerEvent(true);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            AbstractConferenceSdkService.this.createVideoAnswer(object.getUserId(), object.getDescription(), object.getCandidates()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    error.printStackTrace();
                                    solver.resolve((Object)true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable t, @Nullable Response<StopVideoResponse> response) {
                            solver.reject(t);
                        }
                    });
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                }
                catch (Exception exception) {
                    solver.reject((Throwable)exception);
                }
            }
        });
    }

    private Promise<Boolean> createVideoAnswer(final String userId, final OfferDescription offerDescription, final List<OfferCandidate> offerCandidates) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)("createVideoAnswer: " + userId + " " + offerDescription.getSdp() + " " + offerDescription.getType()));
                Log.d((String)"SDKMEDIA", (String)("createVideoAnswer: " + userId + " " + offerDescription.getSdp() + " " + offerDescription.getType()));
                try {
                    if (!AbstractConferenceSdkService.this.hasMedia()) {
                        throw new MediaEngineException("media is null");
                    }
                }
                catch (MediaEngineException exception) {
                    solver.reject((Throwable)exception);
                }
                SdpDescription description = new SdpDescription(offerDescription.getType(), offerDescription.getSdp());
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                if (offerCandidates != null) {
                    for (OfferCandidate candidate : offerCandidates) {
                        candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                    }
                }
                try {
                    AbstractConferenceSdkService.this.getMedia().createAnswerForPeer(userId, description.getSsrc(), description, candidates, VoxeetPreferences.id().equalsIgnoreCase(userId), new PendingPeerCallback(){

                        public void onMessage(@Nullable SdpMessage message) {
                            Log.d((String)TAG, (String)("onMessage: having a message " + message));
                            AbstractConferenceSdkService.this.answer(userId, message).then((PromiseExec)new PromiseExec<Integer, Object>(){

                                public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onSuccess: " + result));
                                    solver.resolve((Object)true);
                                }
                            }).error(new ErrorPromise(){

                                public void onError(Throwable error) {
                                    if (error instanceof PromiseParticipantAddedErrorEventException) {
                                        AbstractConferenceSdkService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                    } else {
                                        error.printStackTrace();
                                    }
                                    solver.resolve((Object)false);
                                }
                            });
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }

    @Override
    public Promise<ConferenceResponse> create() {
        return this.create(null, null, null);
    }

    public Promise<ConferenceResponse> create(@Nullable MetadataHolder metadata, @Nullable ParamsHolder params) {
        return this.create(null, metadata, params);
    }

    public Promise<ConferenceResponse> create(@Nullable String conferenceAlias) {
        return this.create(conferenceAlias, null, null);
    }

    public Promise<ConferenceResponse> create(final @Nullable String conferenceAlias, final @Nullable MetadataHolder metadata, final @Nullable ParamsHolder paramsholder) {
        final Promise promise = new Promise((PromiseSolver)new PromiseSolver<ConferenceResponse>(){

            public void onCall(@NonNull Solver<ConferenceResponse> solver) {
                AbstractConferenceSdkService.this.getEventBus().post((Object)new ConferenceCreatingEvent(conferenceAlias, null));
                Log.d((String)TAG, (String)("Attempting to create mConferene alias:=" + conferenceAlias));
                CreateConferenceParams params = new CreateConferenceParams().setMetadataHolder(metadata).setParamsHolder(paramsholder);
                if (null != conferenceAlias) {
                    params.setConferenceAlias(conferenceAlias);
                }
                AbstractConferenceSdkService.this.internalCreate(true, params, (Solver<ConferenceResponse>)solver);
            }
        });
        if (this.mInstance.isSocketOpen()) {
            return promise;
        }
        return new Promise((PromiseSolver)new PromiseSolver<ConferenceResponse>(){

            public void onCall(final @NonNull Solver<ConferenceResponse> solver) {
                AbstractConferenceSdkService.this.mInstance.logCurrentlySelectedUserWithChain().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                        promise.then((PromiseExec)new PromiseExec<ConferenceResponse, Object>(){

                            public void onCall(@Nullable ConferenceResponse result, @NonNull Solver<Object> internal_solver) {
                                solver.resolve((Object)result);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(@NonNull Throwable error) {
                                solver.reject(error);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    private void internalCreate(final boolean retry, final CreateConferenceParams params, final Solver<ConferenceResponse> solver) {
        Call<ConferenceResponse> observable = this.mConferenceObservableProvider.getCreateConferenceObservable(params);
        this.enqueue(observable, new HttpCallback<ConferenceResponse>(){

            @Override
            public void onSuccess(@NonNull ConferenceResponse object, @NonNull Response<ConferenceResponse> response) {
                Log.d((String)TAG, (String)"onNext: having conference");
                AbstractConferenceSdkService.this.createOrSetConferenceWithParams(object.getConfId(), object.getConfAlias());
                AbstractConferenceSdkService.this.getConferenceInformation(object.getConfId()).setConferenceState(ConferenceState.CREATED);
                ConferenceInformation information = AbstractConferenceSdkService.this.getCurrentConferenceInformation();
                information.setConferenceType(ConferenceSimpleState.CONFERENCE);
                Log.d((String)TAG, (String)("internalCreate onNext: join with := " + object.getConfId() + " " + object.getConfAlias()));
                solver.resolve((Object)object);
            }

            @Override
            public void onFailure(@NonNull Throwable e, @Nullable Response<ConferenceResponse> response) {
                HttpException.dumpErrorResponse(response);
                e.printStackTrace();
                AbstractConferenceSdkService.this.mTwig.e(e);
                if (!retry) {
                    Log.d((String)TAG, (String)"internalCreate onFailure: conference creation failed ! but no retry... quit...");
                    AbstractConferenceSdkService.this.setIsInConference(false);
                    AbstractConferenceSdkService.this.closeMedia();
                    AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreatedError(AbstractConferenceSdkService.this.handleError(e)));
                    solver.reject(e);
                } else {
                    Log.d((String)TAG, (String)"internalCreate onFailure: conference creation failed ! but retry... now...");
                    AbstractConferenceSdkService.this.internalCreate(false, params, (Solver<ConferenceResponse>)solver);
                }
            }
        });
    }

    @Override
    public Promise<Boolean> join(final @NonNull String conferenceId) {
        final Promise promise = new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                boolean init_done;
                AbstractConferenceSdkService.this.joinLock();
                String currentConferenceId = AbstractConferenceSdkService.this.getConferenceId();
                ConferenceInformation holder = AbstractConferenceSdkService.this.getConferenceInformation(conferenceId);
                boolean bl = init_done = null != holder && (ConferenceState.JOINING.equals((Object)holder.getConferenceState()) || ConferenceState.JOINED.equals((Object)holder.getConferenceState()));
                if (null != currentConferenceId && currentConferenceId.equals(conferenceId) && init_done) {
                    Log.d((String)TAG, (String)("onCall: join the conference " + conferenceId + " // invalid call ! already calling it"));
                    Log.d((String)TAG, (String)("onCall: btw, the current " + conferenceId + " state is := " + (Object)((Object)holder.getConferenceState())));
                    solver.resolve((Object)true);
                    return;
                }
                AbstractConferenceSdkService.this.setIsInConference(true);
                DefaultConference conference = holder.getConference();
                AbstractConferenceSdkService.this.getEventBus().post((Object)new ConferencePreJoinedEvent(conferenceId, conference.getConferenceAlias()));
                Log.d((String)TAG, (String)("Attempting to join conference alias:=" + conference.getConferenceAlias() + " conferenceId:=" + conferenceId));
                Log.d((String)TAG, (String)"onNext: having conference");
                AbstractConferenceSdkService.this.createOrSetConferenceWithParams(conference.getConferenceId(), conference.getConferenceAlias());
                AbstractConferenceSdkService.this.getCurrentConferenceInformation().setConferenceState(ConferenceState.JOINING);
                ConferenceInformation information = AbstractConferenceSdkService.this.getCurrentConferenceInformation();
                information.setConferenceType(ConferenceSimpleState.CONFERENCE);
                Log.d((String)TAG, (String)("onNext: join with := " + conference.getConferenceId() + " " + conference.getConferenceAlias()));
                AbstractConferenceSdkService.this.joinUnlock();
                AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreationSuccess(conferenceId, conference.getConferenceAlias()));
                AbstractConferenceSdkService.this.joinVoxeetConference(conferenceId).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve((Object)false);
                    }
                });
            }
        });
        if (this.mInstance.isSocketOpen()) {
            return promise;
        }
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Log.d((String)TAG, (String)"onCall: joining but the socket is disconnected");
                AbstractConferenceSdkService.this.mInstance.logCurrentlySelectedUserWithChain().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver internal_solver) {
                        Log.d((String)TAG, (String)("onCall: connection ? " + result));
                        promise.then((PromiseExec)new PromiseExec<Boolean, Object>(){

                            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                                Log.d((String)TAG, (String)("onCall: join ok? " + result));
                                solver.resolve((Object)result);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(@NonNull Throwable error) {
                                Log.d((String)TAG, (String)"onError: join ko");
                                solver.reject(error);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        solver.reject(error);
                    }
                });
            }
        });
    }

    protected Promise<ResumeConference> extendedJoin(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<ResumeConference>(){

            public void onCall(final @NonNull Solver<ResumeConference> solver) {
                Call<ResumeConference> observable = AbstractConferenceSdkService.this.mConferenceObservableProvider.joinConference(conferenceId, new DeviceEvent(DeviceType.ANDROID, AbstractConferenceSdkService.this.isListenerMode()));
                AbstractConferenceSdkService.this.enqueue(observable, new HttpCallback<ResumeConference>(){

                    @Override
                    public void onSuccess(@NonNull ResumeConference object, @NonNull Response<ResumeConference> response) {
                        solver.resolve((Object)object);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable t, @Nullable Response<ResumeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        solver.reject(t);
                    }
                });
            }
        });
    }

    protected Promise<Boolean> onConferenceCreated(final @NonNull String conferenceId, final @NonNull String conferenceAlias, @Nullable NormalConferenceResponse other) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.createOrSetConferenceWithParams(conferenceId, conferenceAlias);
                AbstractConferenceSdkService.this.getConferenceInformation(conferenceId).setConferenceState(ConferenceState.CREATED);
                AbstractConferenceSdkService.this.getTwig().i("IConference created with id: " + AbstractConferenceSdkService.this.mConferenceId, new Object[0]);
                AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreationSuccess(conferenceId, conferenceAlias));
                AbstractConferenceSdkService.this.joinVoxeetConference(conferenceId).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                    public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                        solver.resolve((Object)result);
                    }
                }).error(new ErrorPromise(){

                    public void onError(Throwable error) {
                        error.printStackTrace();
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> demo() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.getTwig().i("Attempting to create demo mConference", new Object[0]);
                Call user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getCreateDemoObservable();
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<DemoEvent>(){

                    @Override
                    public void onSuccess(@NonNull DemoEvent object, @NonNull Response<DemoEvent> response) {
                        AbstractConferenceSdkService.this.onCreateDemoSuccess(object).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                            public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                ConferenceInformation information = AbstractConferenceSdkService.this.getCurrentConferenceInformation();
                                information.setConferenceType(ConferenceSimpleState.CONFERENCE);
                                solver.resolve((Object)true);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(Throwable error) {
                                solver.reject(error);
                            }
                        });
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<DemoEvent> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e(e);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceCreatedError(AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Override
    @NonNull
    public Promise<List<ConferenceRefreshedEvent>> invite(final List<String> ids) {
        return new Promise((PromiseSolver)new PromiseSolver<List<ConferenceRefreshedEvent>>(){

            public void onCall(final @NonNull Solver<List<ConferenceRefreshedEvent>> solver) {
                AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                AbstractConferenceSdkService.this.sendTimeoutCallbacks();
                boolean sdk = AbstractConferenceSdkService.this.isSDK();
                ArrayList<String> voxeetIds = sdk ? null : new ArrayList<String>();
                final ArrayList<String> externalIds = new ArrayList<String>();
                externalIds.addAll(ids);
                if (!sdk) {
                    voxeetIds.addAll(ids);
                }
                if (null == AbstractConferenceSdkService.this.mConferenceId) {
                    try {
                        throw new IllegalStateException("You're not in a conference");
                    }
                    catch (Exception e) {
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new AddConferenceParticipantResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.reject((Throwable)e);
                        return;
                    }
                }
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getInviteObservable(AbstractConferenceSdkService.this.mConferenceId, new SdkConferenceInvitation(voxeetIds, externalIds));
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        ArrayList<ConferenceRefreshedEvent> list = new ArrayList<ConferenceRefreshedEvent>();
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new AddConferenceParticipantResultEvent(response.code() == 200));
                        try {
                            String body = ((ResponseBody)response.body()).string();
                            Log.d((String)TAG, (String)("onNext: " + body));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (response.code() == 200) {
                            for (String userId : externalIds) {
                                if (userId.equals(VoxeetPreferences.id())) continue;
                                AbstractConferenceSdkService.this.getTwig().i("Conference participant with id: " + userId + " invited", new Object[0]);
                                ConferenceRefreshedEvent event = new ConferenceRefreshedEvent(userId, AbstractConferenceSdkService.this.updateConferenceParticipants(userId, ConferenceUserStatus.IN_PROGRESS));
                                AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                                list.add(event);
                            }
                        }
                        solver.resolve(list);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e(e);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new AddConferenceParticipantResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> logout() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                final String id = VoxeetPreferences.id();
                if (null != id) {
                    AbstractConferenceSdkService.this.mTwig.i("Attempting to logout", new Object[0]);
                    Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getLogOutObservable(VoxeetPreferences.token());
                    AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200) {
                                String message = "Logout success";
                                AbstractConferenceSdkService.this.getTwig().i(message, new Object[0]);
                                VoxeetPreferences.onLogout();
                                AbstractConferenceSdkService.this.getVoxeetSDK().closeSocket();
                                AbstractConferenceSdkService.this.getVoxeetSDK().cleanUserSession(id);
                                AbstractConferenceSdkService.this.mEventBus.post((Object)new SdkLogoutSuccessEvent(message));
                                solver.resolve((Object)true);
                            } else {
                                String message = "Logout failed";
                                AbstractConferenceSdkService.this.getTwig().e(message, new Object[0]);
                                VoxeetPreferences.onLogout();
                                AbstractConferenceSdkService.this.getVoxeetSDK().closeSocket();
                                AbstractConferenceSdkService.this.getVoxeetSDK().cleanUserSession(id);
                                AbstractConferenceSdkService.this.mEventBus.post((Object)new SdkLogoutErrorEvent(message));
                                solver.resolve((Object)false);
                            }
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            AbstractConferenceSdkService.this.getTwig().e(e);
                            String message = "Logout failed";
                            AbstractConferenceSdkService.this.getTwig().e(message, new Object[0]);
                            VoxeetPreferences.onLogout();
                            AbstractConferenceSdkService.this.getVoxeetSDK().closeSocket();
                            AbstractConferenceSdkService.this.getVoxeetSDK().cleanUserSession(id);
                            AbstractConferenceSdkService.this.mEventBus.post((Object)new SdkLogoutErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                            solver.reject(e);
                        }
                    });
                } else {
                    String message = "Already logged out";
                    AbstractConferenceSdkService.this.getTwig().e("Already logged out", new Object[0]);
                    AbstractConferenceSdkService.this.mEventBus.post((Object)new SdkLogoutSuccessEvent("Already logged out"));
                    solver.resolve((Object)true);
                }
            }
        });
    }

    @Override
    public Promise<Boolean> replay(final String conferenceId, final long offset) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                AbstractConferenceSdkService.this.isListenerMode = true;
                AbstractConferenceSdkService.this.setListenerMode(false);
                Call<ReplayConferenceEvent> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getReplayObservable(conferenceId, new SdkConferenceReplayBody(offset));
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ReplayConferenceEvent>(){

                    @Override
                    public void onSuccess(@NonNull ReplayConferenceEvent object, @NonNull Response<ReplayConferenceEvent> response) {
                        AbstractConferenceSdkService.this.getTwig().i("Success server answer for replaying mConference with id: " + conferenceId + "at offset: " + offset + " given := " + object.getConferenceId(), new Object[0]);
                        ConferenceInformation information = AbstractConferenceSdkService.this.getConferenceInformation(object.getConferenceId());
                        information.setConferenceType(ConferenceSimpleState.REPLAY);
                        AbstractConferenceSdkService.this.joinVoxeetConference(object.getConferenceId()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> internal_solver) {
                                solver.resolve((Object)result);
                            }
                        }).error(new ErrorPromise(){

                            public void onError(Throwable error) {
                                error.printStackTrace();
                                solver.resolve((Object)false);
                            }
                        });
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ReplayConferenceEvent> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Failed to replay mConference", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ReplayConferenceErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                        e.printStackTrace();
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    public Promise<Boolean> startRecording() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull(AbstractConferenceSdkService.this.mConferenceId, "mConference Id");
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStartRecordingObservable(AbstractConferenceSdkService.this.mConferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        if (response.code() == 200) {
                            AbstractConferenceSdkService.this.getTwig().i("IConference recording started ", new Object[0]);
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new StartRecordingResultEvent(response.code() == 200));
                        try {
                            Log.d((String)TAG, (String)("onNext: " + object.string()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        solver.resolve((Object)(response.code() == 200 ? 1 : 0));
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Failed to start mConference recording", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new StartRecordingResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    public Promise<Boolean> stopRecording() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull(AbstractConferenceSdkService.this.mConferenceId, "mConference Id");
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getStopRecordingObservable(AbstractConferenceSdkService.this.mConferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        if (response.code() == 200) {
                            AbstractConferenceSdkService.this.getTwig().i("Conference recording stopped", new Object[0]);
                        }
                        try {
                            Log.d((String)TAG, (String)("onNext: " + ((ResponseBody)response.body()).string()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new StopRecordingResultEvent(response.code() == 200));
                        solver.resolve((Object)(response.code() == 200 ? 1 : 0));
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Failed to cancel mConference recording", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new StopRecordingResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Override
    public Promise<GetConferenceStatusEvent> getConferenceStatus(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<GetConferenceStatusEvent>(){

            public void onCall(final @NonNull Solver<GetConferenceStatusEvent> solver) {
                Call<GetConferenceStatusEvent> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getConferenceStatusObservable(conferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<GetConferenceStatusEvent>(){

                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        try {
                            if (null != response && null != object.getConferenceUsers()) {
                                for (DefaultConferenceUser conferenceUser : object.getConferenceUsers()) {
                                    AbstractConferenceSdkService.this.getTwig().e(conferenceUser.getUserId() + " / " + conferenceUser.getStatus(), new Object[0]);
                                }
                                AbstractConferenceSdkService.this.getTwig().i("Dispatching mConference status result", new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)object);
                        solver.resolve((Object)object);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Error while getting mConference history", new Object[0]);
                        e.printStackTrace();
                        try {
                            GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(AbstractConferenceSdkService.this.handleError(e));
                            AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                            throw new PromiseGetConferenceStatusErrorEventException(event, e);
                        }
                        catch (PromiseGetConferenceStatusErrorEventException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    @Override
    public Promise<GetConferenceHistoryEvent> conferenceHistory(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<GetConferenceHistoryEvent>(){

            public void onCall(final @NonNull Solver<GetConferenceHistoryEvent> solver) {
                Call<List<HistoryConference>> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getConferenceHistoryObservable(conferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<List<HistoryConference>>(){

                    @Override
                    public void onSuccess(@NonNull List<HistoryConference> object, @NonNull Response<List<HistoryConference>> response) {
                        AbstractConferenceSdkService.this.getTwig().i("Dispatching mConference history response", new Object[0]);
                        GetConferenceHistoryEvent event = new GetConferenceHistoryEvent(object);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        solver.resolve((Object)event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<List<HistoryConference>> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Error while retrieving mConference history", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new GetConferenceHistoryErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> switchCamera() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull(AbstractConferenceSdkService.this.getMedia(), "media");
                AbstractConferenceSdkService.this.getMedia().switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                    public void onCameraSwitchDone(boolean isFrontCamera) {
                        AbstractConferenceSdkService.this.getTwig().i("Successfully switched camera", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new CameraSwitchSuccessEvent(isFrontCamera));
                        solver.resolve((Object)true);
                    }

                    public void onCameraSwitchError(String errorDescription) {
                        AbstractConferenceSdkService.this.getTwig().e("Failed to switch camera " + errorDescription, new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new CameraSwitchErrorEvent(errorDescription));
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> subscribe(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<SubscribeConference> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getSubscribeObservable(conferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<SubscribeConference>(){

                    @Override
                    public void onSuccess(@NonNull SubscribeConference object, @NonNull Response<SubscribeConference> response) {
                        AbstractConferenceSdkService.this.getTwig().i("You are no subscribed to this mConference's events", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SubscribeConferenceEvent(object));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<SubscribeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Failed to subscribe to this mConference's events", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SubscribeConferenceErrorEvent(AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> unSubscribe() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<ResponseBody> call = AbstractConferenceSdkService.this.mConferenceObservableProvider.getUnSubscribeObservable(AbstractConferenceSdkService.this.mConferenceId);
                AbstractConferenceSdkService.this.enqueue(call, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().i("You are no longer subscribed to this mConference's events", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new UnSubscribeConferenceAnswerEvent(response.code() == 200));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Failed to unsubscribe from this mConference's events", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new UnSubscribeConferenceAnswerEvent(false, AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> subscribeForCall(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<ResponseBody> call = AbstractConferenceSdkService.this.mConferenceObservableProvider.getSubscribeForCallObservable(conferenceId);
                AbstractConferenceSdkService.this.enqueue(call, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().i("You are no subscribed to receive events when this conf starts", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SubscribeForCallConferenceAnswerEvent(conferenceId));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Failed to subscribe to this mConference's start", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SubscribeForCallConferenceErrorEvent(conferenceId, AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> unSubscribeFromCall(final String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getUnSubscribeFromCallObservable(conferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<Response<ResponseBody>>(){

                    @Override
                    public void onSuccess(@NonNull Response<ResponseBody> object, @NonNull Response<Response<ResponseBody>> response) {
                        AbstractConferenceSdkService.this.getTwig().i("You are no longer subscribed to this mConference's start", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new UnSubscribeFromConferenceAnswerEvent(conferenceId));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<Response<ResponseBody>> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Failed to unsubscribe from this mConference's start", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new UnsubscribeFromCallConferenceErrorEvent(conferenceId, AbstractConferenceSdkService.this.handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Deprecated
    @NonNull
    public Promise<Boolean> joinUsingConferenceId(@NonNull String conferenceId) {
        return this.joinVoxeetConference(conferenceId);
    }

    @Override
    @Deprecated
    @NonNull
    public Promise<Boolean> joinVoxeetConference(final @NonNull String conferenceId) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                String existingConferenceId = AbstractConferenceSdkService.this.getConferenceId();
                Log.d((String)TAG, (String)("onCall: " + AbstractConferenceSdkService.this.mInConference + " " + existingConferenceId + " " + conferenceId));
                if (AbstractConferenceSdkService.this.mInConference && (null == existingConferenceId || !existingConferenceId.equals(conferenceId))) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject((Throwable)exception);
                        return;
                    }
                }
                AbstractConferenceSdkService.this.getCurrentConferenceInformation().setConferenceState(ConferenceState.JOINING);
                AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                AbstractConferenceSdkService.this.setIsInConference(true);
                AbstractConferenceSdkService.this.mConferenceId = conferenceId;
                AbstractConferenceSdkService.this.initMedia();
                AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferencePreJoinedEvent(AbstractConferenceSdkService.this.getConferenceId(), AbstractConferenceSdkService.this.getAliasId()));
                Call<ResumeConference> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.joinConference(conferenceId, new DeviceEvent(DeviceType.ANDROID, AbstractConferenceSdkService.this.isListenerMode));
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResumeConference>(){

                    @Override
                    public void onSuccess(@NonNull ResumeConference object, @NonNull Response<ResumeConference> response) {
                        AbstractConferenceSdkService.this.createOrSetConferenceWithParams(object.getConferenceId(), object.getConferenceAlias());
                        AbstractConferenceSdkService.this.initMedia();
                        ConferenceInformation information = AbstractConferenceSdkService.this.getCurrentConferenceInformation();
                        information.setConferenceState(ConferenceState.JOINED);
                        AbstractConferenceSdkService.this.onConferenceResumedInternal(object, (Solver<Boolean>)solver);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResumeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        try {
                            e.printStackTrace();
                            AbstractConferenceSdkService.this.getTwig().e("Failed to Join mConference with id " + conferenceId, new Object[0]);
                            AbstractConferenceSdkService.this.setIsInConference(false);
                            AbstractConferenceSdkService.this.closeMedia();
                            ConferenceJoinedError error = new ConferenceJoinedError(AbstractConferenceSdkService.this.handleError(e));
                            AbstractConferenceSdkService.this.mEventBus.post((Object)error);
                            throw new PromiseConferenceJoinedErrorException(error, e);
                        }
                        catch (PromiseConferenceJoinedErrorException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    protected void onConferenceResumedInternal(ResumeConference response, Solver<Boolean> solver) {
        this.mConferenceId = response.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        DefaultConference conference = information.getConference();
        conference.setConferenceId(response.getConferenceId());
        conference.setConferenceAlias(response.getConferenceId());
        if (response.getConferenceAlias() != null) {
            conference.setConferenceAlias(response.getConferenceAlias());
        }
        this.participantsToConferenceUsers(information, response.getParticipants());
        this.setIsInConference(true);
        this.setAudioRoute(AudioRoute.ROUTE_PHONE);
        this.getTwig().i("Joined mConference with id " + this.getConferenceId(), new Object[0]);
        this.mEventBus.post((Object)new ConferenceJoinedSuccessEvent(this.getConferenceId(), this.getAliasId()));
        solver.resolve((Object)true);
    }

    @Override
    public Promise<ConferenceUsersInvitedEvent> getInvitedUsers() {
        return new Promise((PromiseSolver)new PromiseSolver<ConferenceUsersInvitedEvent>(){

            public void onCall(final @NonNull Solver<ConferenceUsersInvitedEvent> solver) {
                Call<GetConferenceStatusEvent> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.getConferenceStatusObservable(AbstractConferenceSdkService.this.mConferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<GetConferenceStatusEvent>(){

                    @Override
                    public void onSuccess(@NonNull GetConferenceStatusEvent object, @NonNull Response<GetConferenceStatusEvent> response) {
                        Iterable users = Iterables.filter(object.getConferenceUsers(), (Predicate)new Predicate<DefaultConferenceUser>(){

                            public boolean apply(DefaultConferenceUser input) {
                                return input.getStatus().equalsIgnoreCase(ConferenceUserStatus.CONNECTING.toString());
                            }
                        });
                        AbstractConferenceSdkService.this.mTwig.i("Successfully retrieved connecting users", new Object[0]);
                        ConferenceUsersInvitedEvent event = new ConferenceUsersInvitedEvent(users);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)event);
                        solver.resolve((Object)event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<GetConferenceStatusEvent> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("Error while retrieving connecting users", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceUsersInvitedEvent(null));
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> sendBroadcastMessage(final @NonNull String message) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    if (null == AbstractConferenceSdkService.this.mConferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                    return;
                }
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.broadcastMessage(AbstractConferenceSdkService.this.mConferenceId, new BroadcastEvent(message));
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().i("The broadcast message has been sent", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SendBroadcastResultEvent(response.code() == 200));
                        solver.resolve((Object)true);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        AbstractConferenceSdkService.this.getTwig().e("The broadcast message has not been sent", new Object[0]);
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new SendBroadcastResultEvent(AbstractConferenceSdkService.this.handleError(e), false));
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @Override
    public Promise<Boolean> leave() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                final String conferenceId = AbstractConferenceSdkService.this.mConferenceId;
                final ConferenceInformation infos = AbstractConferenceSdkService.this.getConferenceInformation(conferenceId);
                if (null != infos) {
                    infos.setConferenceState(ConferenceState.LEAVING);
                }
                final String conferenceAlias = null != infos ? infos.getConference().getConferenceAlias() : "";
                AbstractConferenceSdkService.this.getTwig().i("Attempting to leave mConference with mConference id " + conferenceId, new Object[0]);
                AbstractConferenceSdkService.this.closeMedia();
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.leaveConference(conferenceId);
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                        AbstractConferenceSdkService.this.getTwig().i("Conference left successfully", new Object[0]);
                        int leftInConference = 0;
                        DefaultConference conference = AbstractConferenceSdkService.this.getConference();
                        if (conference != null) {
                            leftInConference = AbstractConferenceSdkService.this.getConference().getConferenceUsers().size() - 1;
                        }
                        if (null != infos) {
                            infos.setConferenceState(ConferenceState.LEFT);
                        }
                        if (response.code() == 200 || response.code() == 404) {
                            AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceLeftSuccessEvent(conferenceId, conferenceAlias, leftInConference));
                            solver.resolve((Object)true);
                        } else {
                            AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceLeftError(conferenceId, conferenceAlias, response.code() + ""));
                            solver.resolve((Object)false);
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        e.printStackTrace();
                        AbstractConferenceSdkService.this.removeTimeoutCallbacks();
                        AbstractConferenceSdkService.this.getTwig().e("Something went wrong while leaving the mConference", new Object[0]);
                        if (null != infos) {
                            infos.setConferenceState(ConferenceState.LEFT);
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new ConferenceLeftError(conferenceId, conferenceAlias, AbstractConferenceSdkService.this.handleError(e)));
                        solver.resolve((Object)false);
                    }
                });
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceStatsEvent event) {
        ConferenceStats stats = event.getEvent();
        if (stats.getConference_id() != null && stats.getConference_id().equals(this.getConferenceId())) {
            float mos = stats.getScore(VoxeetPreferences.id());
            this.mEventBus.post((Object)new QualityIndicators(mos));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUpdatedEvent event) {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceived invitation) {
        try {
            this.onEvent(invitation.getEvent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceivedEvent invitation) {
        String conferenceId = invitation.getConferenceId();
        if (null == conferenceId) {
            conferenceId = invitation.getConferenceId();
        }
        if (null == conferenceId && null != invitation.getConference()) {
            conferenceId = invitation.getConference().getConferenceId();
        }
        Log.d((String)TAG, (String)("onEvent: current mConferenceId " + this.mConferenceId + " vs " + invitation.getConferenceId() + " vs " + conferenceId));
        if (null != this.mConferenceId && this.mConferenceId.equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for our conference, we prevent this");
            return;
        }
        final ConferenceInformation information = this.getConferenceInformation(conferenceId);
        DefaultConference conference = invitation.getConference();
        boolean is_own_user = invitation.getUserId().equals(VoxeetPreferences.id());
        ConferenceType type = ConferenceType.fromId(conference.getConferenceType());
        if (this.isLive() && null != this.getConferenceId() && this.getConferenceId().equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for the same conference, invalidate the call");
            return;
        }
        if (!is_own_user || ConferenceType.SCHEDULED.equals((Object)type)) {
            InvitationReceivedEvent.UserInviter inviter = invitation.getInviter();
            List<DefaultInvitation> invitations = invitation.getInvitations();
            if (null == information) {
                Log.d((String)TAG, (String)"onEvent: INVALID INFORMATION FOR THE CONFERENCE");
            }
            if (null != inviter && null != inviter.externalId && null != inviter.userId) {
                this.safeUserManagementStarted();
                Log.d((String)TAG, (String)("onEvent: Invitation with inviter " + inviter.userId + " " + inviter.externalId));
                UserInfo info = this.createUserInfo(inviter.nickName, inviter.externalId, inviter.externalAvatarUrl);
                DefaultConferenceUser inviter_user = new DefaultConferenceUser(inviter.userId, "", info);
                information.getLastInvitationReceived().add(inviter_user);
                information.getUserIdsCached().put(inviter.userId, inviter.externalId);
                this.safeUserManagementEnded();
            } else {
                Log.d((String)TAG, (String)"onEvent: Invitation with invalid inviter");
            }
            final String finalConferenceId = conferenceId;
            this.getConferenceStatus(conference.getConferenceId()).then((PromiseExec)new PromiseExec<GetConferenceStatusEvent, Object>(){

                public void onCall(@Nullable GetConferenceStatusEvent result, @NonNull Solver<Object> internal_solver) {
                    Log.d((String)TAG, (String)("onSuccess: " + result));
                    if (result.getConferenceUsers().size() > 0) {
                        Log.d((String)TAG, (String)("onEvent: users " + result.getConferenceUsers().size()));
                        DefaultConferenceUser foundUser = null;
                        String foundExternalId = null;
                        ArrayList<DefaultConferenceUser> merged_list = new ArrayList<DefaultConferenceUser>();
                        merged_list.addAll(result.getConferenceUsers());
                        merged_list.addAll(AbstractConferenceSdkService.this.getLastInvitationUsers());
                        Iterable list = Iterables.filter(merged_list, (Predicate)new Predicate<DefaultConferenceUser>(){

                            public boolean apply(@Nullable DefaultConferenceUser input) {
                                return !AbstractConferenceSdkService.this.currentUserOrEmpty().equals(input.getUserId());
                            }
                        });
                        for (DefaultConferenceUser conferenceUser : list) {
                            String userId = conferenceUser.getUserId();
                            if (null != foundExternalId) continue;
                            String externalId = conferenceUser.getUserInfo().getExternalId();
                            String cachedExternalId = information.getUserIdsCached().get(userId);
                            Log.d((String)TAG, (String)("onEvent: " + userId + " " + externalId + " " + cachedExternalId));
                            foundUser = conferenceUser;
                            if (null == userId || null != externalId && !userId.equals(externalId) || null == (externalId = cachedExternalId)) continue;
                            foundExternalId = cachedExternalId;
                        }
                        if (foundUser != null && null == foundExternalId) {
                            foundExternalId = foundUser.getUserId();
                            Log.d((String)TAG, (String)"externalId is null, setting it to userId");
                        }
                        HashMap<String, String> infos = new HashMap<String, String>();
                        infos.put("UserId", foundUser.getUserId());
                        infos.put("DisplayName", foundUser.getUserInfo().getName());
                        infos.put("NotifType", result.getType());
                        infos.put("ExternalId", foundExternalId);
                        infos.put("AvatarUrl", foundUser.getUserInfo().getAvatarUrl());
                        infos.put("ConfId", result.getConferenceId());
                        AbstractConferenceSdkService.this.getTwig().i("Starting default incoming view " + finalConferenceId + " " + result.getConferenceId(), new Object[0]);
                        Intent intent = VoxeetIntentFactory.buildFrom(AbstractConferenceSdkService.this.mContext, VoxeetPreferences.getDefaultActivity(), infos);
                        if (intent != null) {
                            AbstractConferenceSdkService.this.mContext.startActivity(intent);
                        }
                        AbstractConferenceSdkService.this.mEventBus.post((Object)new IncomingCallEvent());
                    }
                }
            }).error(new ErrorPromise(){

                public void onError(Throwable error) {
                    error.printStackTrace();
                }
            });
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OwnConferenceStartedEvent ownConferenceStartedEvent) {
        if (null != ownConferenceStartedEvent.event().getConferenceInfos()) {
            this.mConferenceId = ownConferenceStartedEvent.event().getConferenceInfos().getConferenceId();
        }
        DefaultConference conference = this.getConference();
        this.getTwig().i("Own mConference started :: " + this.mConferenceId + " " + conference, new Object[0]);
        conference.setConferenceInfos(ownConferenceStartedEvent.event().getConferenceInfos());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(StartVideoAnswerEvent event) {
        Log.d((String)TAG, (String)("onEvent: start video event " + event.isSuccess() + " " + event.message()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RenegociationUpdate event) {
        RenegociationEndedEvent renego = event.getEvent();
        Log.d((String)TAG, (String)("onEvent: Renegociation " + renego.getConferenceId() + " " + renego.getType() + " " + renego.getAnswerReceived() + " " + renego.getOfferSent()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(final OfferCreatedEvent event) {
        Log.d((String)TAG, (String)("onEvent: OfferCreatedEvent " + event.message()));
        try {
            this.handleAnswer(event.offer()).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + event.offer().getUserId() + " " + VoxeetPreferences.id()));
                }
            }).error(new ErrorPromise(){

                public void onError(Throwable error) {
                    error.printStackTrace();
                }
            });
        }
        catch (MediaEngineException e) {
            e.printStackTrace();
            this.getTwig().e(e);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceUserAddedEvent event) {
        if (!this.mConferenceId.equals(event.getEvent().getConferenceId())) {
            Log.d((String)TAG, (String)"onEvent: USER ADDED FOR ANOTHER CONFERENCE");
        }
        DefaultConference conference = this.getOrSetConference(event.getEvent().getConferenceId());
        ConferenceUserAdded content = event.getEvent();
        if (null != content) {
            HashMap<String, MediaStream> streams;
            ConferenceUserStatus status;
            Log.d((String)TAG, (String)("onEvent: ParticipantAdded " + content + " " + content.getUserId() + " " + conference.getConferenceUsers().size()));
            DefaultConferenceUser user = this.findUserById(content.getUserId());
            if (null == user) {
                Log.d((String)TAG, (String)("onEvent: participant " + content.getUserId() + " " + content.getName() + " created"));
                user = new DefaultConferenceUser(content.getUserId(), null);
                user.setIsOwner(false);
                user.setUserInfo(new UserInfo(content.getName(), content.getExternalId(), content.getAvatarUrl()));
                conference.getConferenceUsers().add(user);
            }
            if (null == user.getUserInfo()) {
                Log.d((String)TAG, (String)"onEvent: existing user info are invalid, refreshing");
                user.setUserInfo(new UserInfo(content.getName(), content.getExternalId(), content.getAvatarUrl()));
            }
            if (null != (status = ConferenceUserStatus.fromString((String)content.getStatus()))) {
                user.setConferenceStatus(status);
                user.setStatus(content.getStatus());
            }
            this.mTwig.i("from Event ConferenceUserAddedEvent, user joined with id := " + user.getUserId() + " " + (user.getUserInfo() != null ? user.getUserInfo().getExternalId() : "no external id"), new Object[0]);
            MediaStream stream = null;
            if (this.hasMedia() && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                stream = streams.get(user.getUserId());
            }
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdatedEvent event) {
        boolean timeout_managed;
        DefaultConferenceUser user = this.findUserById(event.getUserId());
        ConferenceUserStatus status = ConferenceUserStatus.valueOf((String)event.getStatus());
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setStatus(event.getStatus());
            this.commitTransactionConferenceUser();
        } else {
            this.getTwig().i("Not in mConference user with id: " + event.getUserId() + " status updated to " + event.getStatus(), new Object[0]);
        }
        this.updateConferenceFromUsers();
        switch (status) {
            case CONNECTING: {
                if (null == user || user.getUserId().equals(VoxeetPreferences.id())) break;
                this.mTwig.i("Cancelling timeout timer from user connecting", new Object[0]);
                this.removeTimeoutCallbacks();
                break;
            }
            case LEFT: 
            case DECLINE: {
                if (!this.hasMedia() || user == null) break;
                this.getTwig().i("In mConference user with id: " + event.getUserId() + " status updated to " + event.getStatus(), new Object[0]);
                this.getMedia().removePeer(event.getUserId());
                break;
            }
            default: {
                this.getTwig().i("status not managed updated to " + event.getStatus(), new Object[0]);
            }
        }
        boolean bl = timeout_managed = this.timeoutRunnable != null && this.timeoutRunnable.isTriggered();
        if (!timeout_managed) {
            switch (status) {
                case DECLINE: {
                    if (event.getUserId().equals(VoxeetPreferences.id())) break;
                    this.getTwig().i("Conference user with id: " + event.getUserId() + " declined the call", new Object[0]);
                    this.mEventBus.post((Object)new ConferenceUserCallDeclinedEvent(event.getConfId(), event.getUserId(), event.getStatus()));
                    break;
                }
                case LEFT: {
                    this.onUserLeft(event.getUserId());
                    break;
                }
                default: {
                    HashMap<String, MediaStream> streams;
                    MediaStream stream = null;
                    if (this.hasMedia() && null != user && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                        stream = streams.get(user.getUserId());
                    }
                    if (null == user) break;
                    this.mEventBus.post((Object)new ConferenceUserUpdatedEvent(user, stream));
                }
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantAddedEvent event) {
        DefaultConferenceUser user = event.getUser();
        if (user != null) {
            HashMap<String, MediaStream> streams;
            this.mTwig.i("Conference user joined with id: " + user.getUserId(), new Object[0]);
            MediaStream stream = null;
            if (this.hasMedia() && (streams = this.getMapOfStreams()).containsKey(user.getUserId())) {
                stream = streams.get(user.getUserId());
            }
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new ConferenceUserJoinedEvent(user, stream));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPushEvent event) {
        if (null == this.mConferenceId || this.mConferenceId.equals(event.getPush().getConferenceId())) {
            this.closeMedia();
            this.getTwig().i("Conference has ended", new Object[0]);
            this.mEventBus.post((Object)event.getPush());
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceEndedEvent event) {
        if (null == this.mConferenceId || this.mConferenceId.equals(event.getEvent().getConferenceId())) {
            this.closeMedia();
            this.getTwig().i("Conference has ended", new Object[0]);
            this.mEventBus.post((Object)event.getEvent());
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(QualityUpdatedEvent event) {
        for (DefaultConferenceUser conferenceUser : event.getEvent().getUser()) {
            DefaultConferenceUser user = this.findUserById(conferenceUser.getUserId());
            if (user == null) continue;
            this.mTwig.i("Quality updated for " + user.getUserId(), new Object[0]);
            this.startTransactionConferenceUser();
            user.setQuality(conferenceUser.getQuality());
            this.commitTransactionConferenceUser();
            this.mEventBus.post((Object)new ConferenceUserQualityUpdatedEvent(user));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RecordingStatusUpdate event) {
        String conferenceId = event.getEvent().getConferenceId();
        Log.d((String)TAG, (String)("onEvent: eevnt for " + conferenceId));
        DefaultConference conference = this.getConferenceInformation(conferenceId).getConference();
        RecordingStatusUpdateEvent recordingStatusUpdateEvent = event.getEvent();
        DefaultConferenceUser user = this.findUserById(recordingStatusUpdateEvent.getUserId());
        if (user != null) {
            RecordingStatus status = RecordingStatus.valueOf((String)recordingStatusUpdateEvent.getRecordingStatus());
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                conference.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.getTimeStamp()));
                conference.setRecordingStatus(RecordingStatus.RECORDING);
                conference.setRecordingUser(recordingStatusUpdateEvent.getUserId());
                user.setIsRecordingOwner(true);
            } else {
                this.isRecording = false;
                conference.setStartRecordTimestamp(null);
                conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                conference.setRecordingUser(null);
                user.setIsRecordingOwner(false);
            }
        }
        this.getTwig().i("Conference's recording status has changed to: " + event.getEvent().getRecordingStatus(), new Object[0]);
        this.mEventBus.post((Object)recordingStatusUpdateEvent);
    }

    protected abstract DefaultConference createConference();

    protected abstract DefaultConferenceUser createConferenceUser(String var1, String var2, UserInfo var3);

    protected abstract UserInfo createUserInfo(String var1, String var2, String var3);

    protected Twig getTwig() {
        return this.mTwig;
    }

    protected void setConference(@NonNull DefaultConference conference) {
        this.mConferenceId = conference.getConferenceId();
        ConferenceInformation information = this.getCurrentConferenceInformation();
        information.setConference(conference);
    }

    protected void setConferenceAlias(String alias) {
        DefaultConference conference = this.getConference();
        conference.setConferenceAlias(alias);
    }

    @Override
    protected EventBus getEventBus() {
        return this.mEventBus;
    }

    protected ConferenceListener getConferenceListener() {
        return this.mListener;
    }

    protected MediaSDK getMedia() {
        return this.getMediaService().getMedia();
    }

    protected abstract void startTransactionConferenceUser();

    protected abstract void commitTransactionConferenceUser();

    protected abstract boolean isSDK();

    protected Promise<Integer> answer(final String peer, final SdpMessage message) {
        return new Promise((PromiseSolver)new PromiseSolver<Integer>(){

            public void onCall(final @NonNull Solver<Integer> solver) {
                try {
                    if (null == AbstractConferenceSdkService.this.mConferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject((Throwable)exception);
                    return;
                }
                Log.d((String)"SDKMEDIA", (String)("answer: peer := " + peer + " message := " + message));
                Call<ResponseBody> user = AbstractConferenceSdkService.this.mConferenceObservableProvider.answerConference(AbstractConferenceSdkService.this.mConferenceId, peer, message.getDescription());
                AbstractConferenceSdkService.this.enqueue(user, new HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        if (response.code() != 200) {
                            AbstractConferenceSdkService.this.getTwig().i("Offer created for " + peer + " : KO", new Object[0]);
                            try {
                                ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(response.code() + "");
                                throw new PromiseParticipantAddedErrorEventException(event);
                            }
                            catch (PromiseParticipantAddedErrorEventException exception) {
                                solver.reject((Throwable)exception);
                            }
                        } else {
                            AbstractConferenceSdkService.this.getTwig().i("Offer created for " + peer + " : OK", new Object[0]);
                            solver.resolve((Object)response.code());
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        AbstractConferenceSdkService.this.getTwig().e("Offer created for " + peer + " : KO", new Object[0]);
                        HttpException.dumpErrorResponse(response);
                        try {
                            ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(AbstractConferenceSdkService.this.handleError(e));
                            throw new PromiseParticipantAddedErrorEventException(event);
                        }
                        catch (PromiseParticipantAddedErrorEventException exception) {
                            solver.reject((Throwable)exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    protected Promise<Boolean> handleAnswer(final OfferCreated offer) throws MediaEngineException {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                String conferenceId;
                if (!AbstractConferenceSdkService.this.hasMedia()) {
                    try {
                        throw new MediaEngineException("handleAnswer media is null");
                    }
                    catch (MediaEngineException exception) {
                        solver.reject((Throwable)exception);
                    }
                }
                if (!(conferenceId = offer.getConferenceId()).equals(AbstractConferenceSdkService.this.mConferenceId)) {
                    Log.d((String)TAG, (String)"onCall: CONFERENCE IS NOT THE SAME ! ANSWER SHALL BE DISCARDED");
                }
                SdpDescription description = new SdpDescription(offer.getDescription().getType(), offer.getDescription().getSdp());
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                for (OfferCandidate candidate : offer.getCandidates()) {
                    Log.d((String)TAG, (String)("onCall: sdpcandidate " + candidate.getMid() + " " + candidate.getmLine()));
                    candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                }
                String userId = offer.getUserId();
                Log.d((String)TAG, (String)("handleAnswer: offer := " + offer.getUserId() + " " + offer.getExternalId()));
                Log.d((String)"SDKMEDIA", (String)("handleAnswer: " + offer.getUserId() + " " + offer.getExternalId() + " " + description.getSsrc()));
                try {
                    AbstractConferenceSdkService.this.getMedia().createAnswerForPeer(userId, description.getSsrc(), description, candidates, offer.isMaster(), new PendingPeerCallback(){

                        public void onMessage(@Nullable SdpMessage message) {
                            try {
                                if (null == AbstractConferenceSdkService.this.mConferenceId) {
                                    Log.d((String)TAG, (String)"onMessage: INVALID CONFERENCE ID WHEN OFFER IS RECEIVED");
                                    AbstractConferenceSdkService.this.mConferenceId = offer.getConferenceId();
                                }
                                DefaultConference conference = AbstractConferenceSdkService.this.getConference();
                                DefaultConferenceUser user = null;
                                for (DefaultConferenceUser in_conf : conference.getConferenceUsers()) {
                                    if (in_conf.getUserId() == null || !in_conf.getUserId().equals(offer.getUserId())) continue;
                                    user = in_conf;
                                }
                                UserInfo infos = offer.getUserId().contains("11111") ? AbstractConferenceSdkService.this.createUserInfo("Julie", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_1.png") : (offer.getUserId().contains("22222") ? AbstractConferenceSdkService.this.createUserInfo("Sophie", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_2.png") : (offer.getUserId().contains("33333") ? AbstractConferenceSdkService.this.createUserInfo("Mike", offer.getExternalId(), "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_3.png") : AbstractConferenceSdkService.this.createUserInfo(offer.getName(), offer.getExternalId(), offer.getAvatarUrl())));
                                if (user == null) {
                                    user = AbstractConferenceSdkService.this.createConferenceUser(offer.getUserId(), offer.getDevice(), infos);
                                    conference.getConferenceUsers().add(user);
                                } else {
                                    user.setUserInfo(infos);
                                }
                                AbstractConferenceSdkService.this.setUserPosition(offer.getUserId(), 0.0, 0.5);
                                AbstractConferenceSdkService.this.answer(offer.getUserId(), message).then((PromiseExec)new PromiseExec<Integer, Object>(){

                                    public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                        Log.d((String)TAG, (String)("onSuccess: " + result));
                                        solver.resolve((Object)true);
                                    }
                                }).error(new ErrorPromise(){

                                    public void onError(Throwable error) {
                                        if (error instanceof PromiseParticipantAddedErrorEventException) {
                                            AbstractConferenceSdkService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                        } else {
                                            error.printStackTrace();
                                        }
                                        solver.resolve((Object)false);
                                    }
                                });
                            }
                            catch (Exception e) {
                                Log.d((String)TAG, (String)("onMessage: unlockPeerOperation" + e.getMessage()));
                                solver.resolve((Object)false);
                            }
                        }
                    });
                }
                catch (MediaEngineException e) {
                    e.printStackTrace();
                    solver.reject((Throwable)e);
                }
            }
        });
    }

    protected void safeUserManagementStarted() {
    }

    protected void safeUserManagementEnded() {
    }

    protected void safeConferenceManagementStarted() {
    }

    protected void safeConferenceManagementEnded() {
    }

    protected DefaultConferenceUser updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        DefaultConferenceUser user = this.findUserById(userId);
        DefaultConference conference = this.getConference();
        if (null != user && null != conference) {
            this.startTransactionConferenceUser();
            user.setIsOwner(conference.getOwnerProfile() == null || conference.getOwnerProfile().getUserId().equals(user.getProfile().getUserId())).setConferenceStatus(status).setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
            this.commitTransactionConferenceUser();
            return user;
        }
        return null;
    }

    protected void initMedia() {
        Validate.notNull(this.mContext, "mContext");
        Validate.notNull(VoxeetPreferences.id(), "user id");
        if (!this.hasMedia()) {
            try {
                this.getMediaService().createMedia(this.context, VoxeetPreferences.id(), this.mediaStreamListener, this.isVideoOn(), Validate.hasMicrophonePermissions(this.context));
                this.getAudioService().setSpeakerMode(this.isDefaultOnSpeaker);
                this.getAudioService().requestAudioFocus();
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getTwig().i("the app does not seem to have mic permission, disabling mic", new Object[0]);
                    this.mute(true);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                }
            }
            catch (MediaEngineException e) {
                this.getTwig().e(e);
            }
        }
    }

    protected void closeMedia() {
        if (this.hasMedia()) {
            MediaSDK media = this.getMedia();
            DefaultConference conference = this.getConference();
            try {
                if (null != conference) {
                    for (DefaultConferenceUser user : conference.getConferenceUsers()) {
                        if (user == null || user.getUserId() == null) continue;
                        media.removePeer(user.getUserId());
                    }
                }
            }
            catch (Exception ex) {
                this.mTwig.e(ex);
            }
            this.getAudioService().abandonAudioFocusRequest();
            this.getMediaService().releaseMedia();
            this.getTwig().i("Microphone value restored to true", new Object[0]);
            this.isVideoOn = false;
            this.mTwig.i("Video value restored to false", new Object[0]);
            this.isListenerMode = false;
            this.getTwig().i("Listener mode set back to false", new Object[0]);
        }
        this.getTwig().i("Media closed", new Object[0]);
        this.setIsInConference(false);
        this.mConferenceId = null;
    }

    private void removeTimeoutCallbacks() {
        if (this.timeoutRunnable != null) {
            this.timeoutRunnable.setCanceled(true);
            handler.removeCallbacks((Runnable)this.timeoutRunnable);
        }
    }

    private void sendTimeoutCallbacks() {
        if (this.mTimeOutTimer != -1L) {
            this.timeoutRunnable = new TimeoutRunnable(this, this.getTwig(), this.mEventBus, this.mTimeOutTimer);
            this.getTwig().i("scheduling timer to leave the mConference in " + this.mTimeOutTimer, new Object[0]);
            handler.postDelayed((Runnable)this.timeoutRunnable, this.mTimeOutTimer);
        }
    }

    private void onUserLeft(@NonNull String peer) {
        DefaultConferenceUser user = this.findUserById(peer);
        if (user != null) {
            this.startTransactionConferenceUser();
            user.setConferenceStatus(ConferenceUserStatus.LEFT);
            if (this.getConferenceUsers().contains(user)) {
                this.getConferenceUsers().remove(user);
            }
            this.getTwig().i("Conference user left with id: " + user.getUserId(), new Object[0]);
            this.commitTransactionConferenceUser();
            if (this.mapOfStreams.containsKey(user.getUserId())) {
                this.mapOfStreams.remove(user.getUserId());
            }
            if (this.mapOfScreenShareStreams.containsKey(user.getUserId())) {
                this.mapOfScreenShareStreams.remove(user.getUserId());
            }
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new ConferenceUserLeftEvent(user));
        } else {
            Log.d((String)TAG, (String)"run: unknown user in stream left");
        }
    }

    protected VoxeetSdkTemplate getVoxeetSDK() {
        return this.mSDK;
    }

    public void setStatEnabled(boolean stats) {
        this.mEnableStats = stats;
    }

    private AudioService getAudioService() {
        return this.getVoxeetSDK().getAudioService();
    }

    private void createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        this.mConferenceId = conferenceId;
        Log.d((String)TAG, (String)("createOrSetConferenceWithParams: set conference id := " + this.mConferenceId));
        DefaultConference conference = this.getCurrentConferenceInformation().getConference();
        conference.setConferenceId(this.mConferenceId);
        conference.setConferenceAlias(conferenceAlias);
    }

    @Nullable
    public ConferenceInformation getCurrentConferenceInformation() {
        return this.getConferenceInformation(this.mConferenceId);
    }

    @Nullable
    private ConferenceInformation getConferenceInformation(@Nullable String conferenceId) {
        if (null == conferenceId) {
            return null;
        }
        return this.mConferenceInformationHolder.getInformation(conferenceId);
    }

    private void updateConferenceFromUsers() {
        ConferenceInformation information = this.getCurrentConferenceInformation();
        if (null != information) {
            ConferenceState state = information.getState();
            Log.d((String)TAG, (String)("updateConferenceFromUsers: updating conference status from users " + (Object)((Object)state)));
            switch (state) {
                case JOINED: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
                case FIRST_PARTICIPANT: {
                    if (this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.NO_MORE_PARTICIPANT);
                    break;
                }
                case NO_MORE_PARTICIPANT: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
            }
            state = information.getState();
            Log.d((String)TAG, (String)("updateConferenceFromUsers: new state of conference from users " + (Object)((Object)state)));
        }
    }

    public boolean hasParticipants() {
        List<DefaultConferenceUser> users = this.getConferenceUsers();
        for (DefaultConferenceUser user : users) {
            ConferenceUserStatus status = user.getConferenceStatus();
            if (null == user.getUserId() || user.getUserId().equals(VoxeetPreferences.id()) || !ConferenceUserStatus.ON_AIR.equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    private <T> void enqueue(Call<T> call, final HttpCallback<T> callback) {
        call.enqueue(new Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
                if (response.isSuccessful() && null != response.body()) {
                    callback.onSuccess(response.body(), response);
                } else {
                    callback.onFailure(HttpException.throwResponse(response), response);
                }
            }

            public void onFailure(Call<T> call, Throwable t) {
                callback.onFailure(t, null);
            }
        });
    }

    private boolean hasMedia() {
        return null != this.getMedia();
    }

    @NonNull
    private MediaService getMediaService() {
        return this.mInstance.getMediaService();
    }

    private void participantsToConferenceUsers(@Nullable ConferenceInformation information, @Nullable List<DefaultParticipant> participants) {
        if (null != information && null != participants) {
            Map<String, String> cache = information.getUserIdsCached();
            for (DefaultParticipant participant : participants) {
                cache.put(participant.getExternalId(), participant.getExternalId());
            }
            DefaultConference conference = information.getConference();
            for (DefaultParticipant participant : participants) {
                this.updateParticipantToConferenceUsers(conference, participant);
            }
        }
    }

    private boolean updateParticipantToConferenceUsers(@NonNull DefaultConference conference, @NonNull DefaultParticipant participant) {
        boolean found;
        DefaultConferenceUser user = this.findUserById((Conference)conference, participant.getParticipantId());
        boolean bl = found = null != user;
        if (null == user) {
            user = new DefaultConferenceUser(participant.getParticipantId(), participant.getDeviceType(), new UserInfo(participant.getName(), participant.getExternalId(), participant.getAvatarUrl()));
            conference.getConferenceUsers().add(user);
            found = false;
        }
        ConferenceUserStatus status = ConferenceUserStatus.fromString((String)participant.getStatus());
        user.setConferenceStatus(status);
        return !found;
    }

    private void joinLock() {
        try {
            this.joinLock.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void joinUnlock() {
        try {
            if (this.joinLock.isLocked()) {
                this.joinLock.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static interface HttpCallback<T> {
        public void onSuccess(@NonNull T var1, @NonNull Response<T> var2);

        public void onFailure(@NonNull Throwable var1, @Nullable Response<T> var2);
    }
}

