package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import voxeet.com.sdk.models.impl.DefaultConferenceUser;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.OFFER_CREATED)
public class QualityUpdated extends Event {

    @JsonProperty("conference_id")
    private String conferenceId;

    @JsonProperty("quality_indicators")
    private List<DefaultConferenceUser> user;

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public List<DefaultConferenceUser> getUser() {
        return user;
    }

    public void setUser(List<DefaultConferenceUser> user) {
        this.user = user;
    }

    @Override
    public String getType() {
        return EventNames.QUALITY_UPDATED;
    }
}
