package voxeet.com.sdk.core.network;


import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import rx.Observable;
import voxeet.com.sdk.core.http.RefreshTokenBody;
import voxeet.com.sdk.json.GrandTypeEvent;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.TokenResponse;
import voxeet.com.sdk.models.UserTokenResponse;

/**
 * Created by ROMMM on 4/4/16.
 */
public interface IVoxeetRService {

    @POST("v2/users/identify")
    @Headers( "Content-Type: application/json")
    Observable<UserTokenResponse> identify(@Body UserInfo info);

    @POST("v1/oauth2/token")
    @Headers("Content-Type: application/json")
    Observable<TokenResponse> getToken(@Header("Authorization") String authorization, @Body GrandTypeEvent grandType);

    @POST("v1/oauth2/refresh")
    @Headers("Content-Type: application/json")
    Observable<TokenResponse> refreshToken(@Body RefreshTokenBody body);
}
