/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.app.Activity;
import android.content.Intent;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;

public class ScreenShareService
extends AbstractVoxeetService {
    private static final int REQUEST_SCREEN_CAPTURE = 672;
    private static final String TAG = ScreenShareService.class.getSimpleName();
    private VoxeetSdkTemplate mInstance;
    private int mLastResultCode;
    private Intent mLastData;

    public ScreenShareService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.mInstance = instance;
    }

    public void toggleScreenShare() {
        ((AbstractConferenceSdkService)this.mInstance.getConferenceService()).toggleScreenShare();
    }

    public Promise<Boolean> startScreenShare(Intent intent) {
        Object service = this.mInstance.getConferenceService();
        return ((AbstractConferenceSdkService)service).startScreenShare(intent);
    }

    public Promise<Boolean> stopScreenShare() {
        return ((AbstractConferenceSdkService)this.mInstance.getConferenceService()).stopScreenShare();
    }

    public void sendRequestStartScreenShare() {
        this.getEventBus().post((Object)new RequestScreenSharePermissionEvent());
    }

    public boolean sendUserPermissionRequest(@NonNull Activity activity) {
        if (21 <= Build.VERSION.SDK_INT) {
            MediaProjectionManager manager = (MediaProjectionManager)activity.getSystemService("media_projection");
            Intent request = manager.createScreenCaptureIntent();
            activity.startActivityForResult(request, 672);
            return true;
        }
        return false;
    }

    public void consumeRightsToScreenShare() {
        if (this.mLastResultCode == -1 && null != this.mLastData) {
            this.startScreenShare(this.mLastData).then((PromiseExec)new PromiseExec<Boolean, Object>(){

                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)"onCall: starting screen share");
                }
            }).error(new ErrorPromise(){

                public void onError(@NonNull Throwable error) {
                    Log.d((String)TAG, (String)"onError: error while starting screen share");
                    error.printStackTrace();
                }
            });
            this.mLastData = null;
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 672) {
            if (-1 != resultCode) {
                ((AbstractConferenceSdkService)this.mInstance.getConferenceService()).onUserCanceledScreenShare();
            } else {
                this.mLastResultCode = resultCode;
                this.mLastData = data;
            }
        }
        return false;
    }

    public static class RequestScreenSharePermissionEvent {
    }
}

