/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.firebase.iid.FirebaseInstanceId;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import voxeet.com.sdk.converter.JacksonConverterFactory;
import voxeet.com.sdk.core.FirebaseController;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.http.RefreshTokenBody;
import voxeet.com.sdk.core.network.IVoxeetRService;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.json.GrandTypeEvent;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.TokenResponse;
import voxeet.com.sdk.models.UserTokenResponse;
import voxeet.com.sdk.networking.DeviceType;
import voxeet.com.sdk.utils.Auth64;

public class VoxeetHttp {
    private final VoxeetSdkTemplate sdk;
    @NonNull
    protected IVoxeetRService service;
    @Nullable
    private final String appId;
    @Nullable
    private final String password;
    @Nullable
    private final String tokenAccess;
    @Nullable
    private final Callable<String> tokenRefresh;
    @Nullable
    private TokenResponse tokenResponse;
    private Application appContext;
    private String serverUrl;
    private String serverPort;
    public Retrofit retrofit;
    private OkHttpClient client;
    private TokenResponseProvider tokenResponseProvider;
    private VoxeetServiceListener listener;
    private boolean debug = false;
    private final HashMap<String, List<Cookie>> cookieStore = new HashMap();
    private UserTokenResponse mUserTokenResponse;

    private VoxeetHttp(Application appContext, VoxeetSdkTemplate sdk, String serverUrl, String serverPort, String appId, String password, VoxeetServiceListener listener, String tokenAccess, final Callable<String> tokenRefresh, boolean debug) {
        this.sdk = sdk;
        this.tokenResponse = null;
        this.serverUrl = serverUrl;
        this.serverPort = serverPort;
        this.appContext = appContext;
        this.tokenAccess = tokenAccess;
        this.tokenRefresh = tokenRefresh;
        this.debug = debug;
        this.listener = listener;
        this.appId = appId;
        this.password = password;
        this.initClient();
        this.initRetrofit();
        this.initService();
        if (null != appId && null != password) {
            this.tokenResponseProvider = new TokenResponseProvider(){

                @Override
                @Nullable
                public TokenResponse refreshTokenResponse() {
                    TokenResponse previous = VoxeetHttp.this.tokenResponse;
                    Observable<TokenResponse> token = null;
                    try {
                        if (null != previous && null != previous.getRefreshToken()) {
                            token = VoxeetHttp.this.service.refreshToken(new RefreshTokenBody(previous.getRefreshToken()));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (null == token) {
                            token = VoxeetHttp.this.service.getToken(Auth64.serialize(VoxeetHttp.this.appId, VoxeetHttp.this.password), new GrandTypeEvent("client_credentials"));
                        }
                        return (TokenResponse)token.toBlocking().single();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        } else if (null != tokenAccess && null != tokenRefresh) {
            this.tokenResponse = new TokenResponse(tokenAccess, null);
            this.tokenResponseProvider = new TokenResponseProvider(){

                @Override
                @Nullable
                public TokenResponse refreshTokenResponse() {
                    try {
                        String tokenAccess = (String)tokenRefresh.call();
                        return new TokenResponse(tokenAccess, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
    }

    private void initClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                String base = url.scheme() + "://" + url.host() + ":" + url.port();
                VoxeetHttp.this.cookieStore.put(base, Lists.newArrayList((Iterable)Iterables.filter(cookies, (Predicate)new Predicate<Cookie>(){

                    public boolean apply(Cookie input) {
                        return input != null && !input.value().equalsIgnoreCase("deleted") && new Date().before(new Date(input.expiresAt()));
                    }
                })));
            }

            public List<Cookie> loadForRequest(HttpUrl url) {
                String base = url.scheme() + "://" + url.host() + ":" + url.port();
                List cookies = (List)VoxeetHttp.this.cookieStore.get(base);
                return cookies != null ? cookies : new ArrayList();
            }
        }).addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                try {
                    Request.Builder builder = chain.request().newBuilder();
                    if (null != VoxeetHttp.this.tokenResponse) {
                        VoxeetHttp.this.sdk.getTwig().i("intercept: having tokenResponse accessToken := " + VoxeetHttp.this.tokenResponse.getAccessToken(), new Object[0]);
                        builder.addHeader("Authorization", "bearer " + VoxeetHttp.this.tokenResponse.getAccessToken());
                    }
                    if (null != VoxeetHttp.this.mUserTokenResponse) {
                        VoxeetHttp.this.sdk.getTwig().i("authenticator: having userTokenResponse := " + VoxeetHttp.this.mUserTokenResponse, new Object[0]);
                        builder = builder.addHeader("X-Token", VoxeetHttp.this.mUserTokenResponse.getJwtUserToken());
                    }
                    return chain.proceed(builder.build());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                TokenResponse tokenResponse = VoxeetHttp.this.tokenResponseProvider.refreshTokenResponse();
                String accessToken = tokenResponse != null ? tokenResponse.getAccessToken() : "";
                VoxeetHttp.this.sdk.getTwig().i("authenticator: having tokenResponse := " + tokenResponse + " // accessToken := " + accessToken, new Object[0]);
                if (null == tokenResponse) {
                    throw new IllegalStateException("Invalid credentials");
                }
                VoxeetHttp.this.tokenResponse = tokenResponse;
                return response.request().newBuilder().addHeader("Authorization", "bearer " + tokenResponse.getAccessToken()).build();
            }
        }).connectionPool(new ConnectionPool(5, 45L, TimeUnit.SECONDS)).retryOnConnectionFailure(true).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS);
        this.client = builder.build();
    }

    private void initRetrofit() {
        this.retrofit = new Retrofit.Builder().addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.client).build();
    }

    private void initService() {
        this.service = (IVoxeetRService)this.retrofit.create(IVoxeetRService.class);
    }

    @SuppressLint(value={"HardwareIds"})
    void identify(final UserInfo userInfo) {
        userInfo.setDeviceIdentifier(Settings.Secure.getString((ContentResolver)this.appContext.getContentResolver(), (String)"android_id"));
        if (FirebaseController.getInstance().isTokenUploadAllowed()) {
            String token = FirebaseController.getInstance().getToken();
            if (token != null) {
                this.sdk.getTwig().i("FirebaseInstanceId.getInstance().getAccessToken(): " + FirebaseInstanceId.getInstance().getToken(), new Object[0]);
                userInfo.setDevicePushToken(token);
            } else {
                this.sdk.getTwig().e("FirebaseInstanceId.getInstance().getAccessToken() returned an IllegalStateException, you have an issue with your project configuration (google-services.json for instance)", new Object[0]);
            }
        } else {
            this.sdk.getTwig().i("FirebaseApp is not initialized. Make sure to call FirebaseApp.initializeApp(Context) before initializing the VoxeetSDK if you are planning on using FCM.", new Object[0]);
        }
        userInfo.setDeviceType(DeviceType.ANDROID);
        this.retrieveTokenResponse().then((PromiseExec)new PromiseExec<TokenResponse, UserTokenResponse>(){

            public void onCall(@Nullable TokenResponse result, @NonNull Solver<UserTokenResponse> solver) {
                VoxeetHttp.this.sdk.getTwig().i("validated access with the servers ; authenticating user...", new Object[0]);
                VoxeetHttp.this.tokenResponse = result;
                solver.resolve(VoxeetHttp.this.retrieveUserTokenResponse(userInfo));
            }
        }).then((PromiseExec)new PromiseExec<UserTokenResponse, Object>(){

            public void onCall(@Nullable UserTokenResponse result, @NonNull Solver<Object> solver) {
                VoxeetHttp.this.mUserTokenResponse = result;
                VoxeetHttp.this.sdk.getTwig().i("Successful login with id " + result.getId(), new Object[0]);
                VoxeetPreferences.setId(result.getId());
                VoxeetPreferences.saveLoginCookie(result.getUserToken());
                VoxeetHttp.this.listener.onIdentifySuccess(result, VoxeetHttp.this.tokenResponse);
                List cookies = VoxeetHttp.this.getCookies(VoxeetHttp.this.getBuiltServerUrl());
                if (cookies != null && cookies.size() > 0) {
                    VoxeetPreferences.saveLoginCookie(((Cookie)cookies.get(0)).toString());
                }
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
                if (error instanceof UnknownHostException) {
                    VoxeetHttp.this.listener.onNetworkError((UnknownHostException)error);
                } else {
                    VoxeetHttp.this.listener.onIdentifyError(error.getMessage());
                }
            }
        });
    }

    private List<Cookie> getCookies(String url) {
        for (Map.Entry<String, List<Cookie>> o : this.cookieStore.entrySet()) {
            Map.Entry<String, List<Cookie>> pair = o;
            if (!pair.getKey().contains(url)) continue;
            return this.cookieStore.get(pair.getKey());
        }
        return null;
    }

    private String createCookie(String value) {
        String url = this.getBuiltServerUrl();
        Cookie cookie = Cookie.parse((HttpUrl)HttpUrl.parse((String)url), (String)value);
        if (cookie != null && cookie.toString().length() > 0) {
            this.cookieStore.put(url, Collections.singletonList(cookie));
            return cookie.value();
        }
        return null;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public String retrieveCookie() {
        String cookie = VoxeetPreferences.getLoginCookie();
        if (cookie != null && cookie.length() > 0) {
            cookie = this.createCookie(cookie);
        } else {
            List<Cookie> cookies = this.getCookies(this.getBuiltServerUrl());
            if (cookies != null && cookies.size() > 0) {
                cookie = cookies.get(0).value();
                VoxeetPreferences.saveLoginCookie(cookies.get(0).toString());
            }
        }
        return cookie;
    }

    Retrofit getRetrofit() {
        return this.retrofit;
    }

    String getToken() {
        return this.mUserTokenResponse != null ? this.mUserTokenResponse.getUserToken() : null;
    }

    String getJwtToken() {
        return this.mUserTokenResponse != null ? this.mUserTokenResponse.getJwtUserToken() : null;
    }

    String getBuiltServerUrl() {
        String port = this.serverPort;
        if (!port.startsWith(":")) {
            port = ":" + port;
        }
        return this.serverUrl + port;
    }

    @NonNull
    private Promise<TokenResponse> retrieveTokenResponse() {
        return new Promise((PromiseSolver)new PromiseSolver<TokenResponse>(){

            public void onCall(final @NonNull Solver<TokenResponse> solver) {
                if (null != VoxeetHttp.this.tokenAccess && null != VoxeetHttp.this.tokenRefresh) {
                    solver.resolve((Object)new TokenResponse(VoxeetHttp.this.tokenAccess, null));
                } else if (null != VoxeetHttp.this.appId && null != VoxeetHttp.this.password) {
                    Observable<TokenResponse> token = VoxeetHttp.this.service.getToken(Auth64.serialize(VoxeetHttp.this.appId, VoxeetHttp.this.password), new GrandTypeEvent("client_credentials"));
                    token.subscribeOn(Schedulers.newThread()).subscribe((Subscriber)new Subscriber<TokenResponse>(){

                        public void onCompleted() {
                        }

                        public void onError(Throwable e) {
                            solver.reject(e);
                        }

                        public void onNext(TokenResponse response) {
                            solver.resolve((Object)response);
                        }
                    });
                } else {
                    try {
                        throw new Exception("Invalid mode, issue with SDK compilation?");
                    }
                    catch (Exception e) {
                        solver.reject((Throwable)e);
                    }
                }
            }
        });
    }

    @NonNull
    private Promise<UserTokenResponse> retrieveUserTokenResponse(final @NonNull UserInfo userInfo) {
        return new Promise((PromiseSolver)new PromiseSolver<UserTokenResponse>(){

            public void onCall(final @NonNull Solver<UserTokenResponse> solver) {
                Observable<UserTokenResponse> user = VoxeetHttp.this.service.identify(userInfo);
                user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<UserTokenResponse>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        solver.reject(e);
                    }

                    public void onNext(@NonNull UserTokenResponse userTokenResponse) {
                        solver.resolve((Object)userTokenResponse);
                    }
                });
            }
        });
    }

    private static interface TokenResponseProvider {
        @Nullable
        public TokenResponse refreshTokenResponse();
    }

    public static final class Builder {
        private Application _application;
        private VoxeetSdkTemplate _sdk;
        private String _server_url;
        private String _server_port;
        private String _app_id;
        private String _password;
        private String _tokenAccess;
        private Callable<String> _tokenRefresh;
        private VoxeetServiceListener _listener;
        private boolean _debug;

        public Builder setApplication(Application application) {
            this._application = application;
            return this;
        }

        public Builder setVoxeetSDK(VoxeetSdkTemplate sdk) {
            this._sdk = sdk;
            return this;
        }

        public Builder setServerUrl(String serverUrl) {
            this._server_url = serverUrl;
            return this;
        }

        public Builder setServerPort(String serverPort) {
            this._server_port = serverPort;
            return this;
        }

        public Builder setAppId(String appId) {
            this._app_id = appId;
            return this;
        }

        public Builder setPassword(String password) {
            this._password = password;
            return this;
        }

        public Builder setVoxeetServiceListener(VoxeetServiceListener listener) {
            this._listener = listener;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this._debug = debug;
            return this;
        }

        public Builder setTokenAccess(String tokenAccess) {
            this._tokenAccess = tokenAccess;
            return this;
        }

        public Builder setTokenRefresh(Callable<String> tokenRefresh) {
            this._tokenRefresh = tokenRefresh;
            return this;
        }

        public VoxeetHttp build() {
            return new VoxeetHttp(this._application, this._sdk, this._server_url, this._server_port, this._app_id, this._password, this._listener, this._tokenAccess, this._tokenRefresh, this._debug);
        }
    }

    public static interface VoxeetServiceListener {
        public void onIdentifySuccess(UserTokenResponse var1, TokenResponse var2);

        public void onIdentifyError(String var1);

        public void onNetworkError(UnknownHostException var1);
    }
}

