/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.preferences;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.kernel.R;
import java.util.Date;
import voxeet.com.sdk.core.preferences.SharedPreferencesCacheWrapper;

public class VoxeetPreferences {
    private static final String TAG = VoxeetPreferences.class.getSimpleName();
    public static final String ACCOUNT_TYPE = "acct_type";
    public static final String ID = "id";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String UPLOAD_TOKEN = "upload_token";
    public static final String LOGIN = "login";
    public static final String COOKIE = "cookie";
    public static final String PASSWORD = "password";
    public static final String MINIMAL_VERSION = "minimal_version";
    public static final String APP_VERSION = "app_version";
    public static final String REFERRAL_ENABLED = "referral_enabled";
    public static final String REFERRAL_URL = "referral_url";
    public static final String REFERRAL_IMAGE_URL = "referral_image_url";
    public static final String FACEBOOK_ENABLED = "facebook_enabled";
    public static final String FACEBOOK_CONNECTED = "facebook_connected";
    public static final String AUTOLOGIN = "autologin";
    public static final String PREMIUM = "premium";
    public static final String GOOGLE_CONNECTED = "google_connected";
    public static final String ADDRESS_BOOK_SYNCED = "adress_book_synced";
    public static final String DEFAULT_ACTIVITY = "default_activity";
    public static final String MANIFEST_URL = "manifest_url";
    public static final String CONFERENCE_TIMEOUT = "conference_timeout";
    public static final String DELAY_ESTIMATION = "delay_estimation_new";
    private static SharedPreferencesCacheWrapper preferences;
    private static String deviceIdentifier;
    private static AccountType sCurrentAccountType;

    private VoxeetPreferences() {
    }

    public static void init(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("main", 0);
        preferences = new SharedPreferencesCacheWrapper(prefs);
        deviceIdentifier = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        int version = 0;
        try {
            version = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Error accessing application version number", (Throwable)e);
        }
        preferences.edit().putString(MANIFEST_URL, context.getString(R.string.manifestUrl)).putInt(APP_VERSION, version).apply();
    }

    public static String id() {
        if (preferences != null && preferences.contains(ID)) {
            return preferences.getString(ID, null);
        }
        return null;
    }

    @NonNull
    public static AccountType accountType() {
        if (preferences != null && preferences.contains(ACCOUNT_TYPE)) {
            return AccountType.fromName(preferences.getString(ACCOUNT_TYPE, null));
        }
        return AccountType.SDK;
    }

    public static boolean isLoggedIn() {
        if (preferences != null) {
            String cookie = preferences.getString(COOKIE, null);
            if (cookie == null || cookie.length() == 0) {
                return false;
            }
            return AccountType.CONNECTED.equals((Object)VoxeetPreferences.accountType());
        }
        return false;
    }

    public static void setId(String id) {
        VoxeetPreferences.setId(id, sCurrentAccountType);
    }

    public static void setId(String id, AccountType type) {
        if (preferences != null) {
            preferences.edit().putString(ID, id).putString(ACCOUNT_TYPE, type.name()).apply();
        }
    }

    public static String login() {
        if (preferences == null) {
            return null;
        }
        return preferences.getString(LOGIN, null);
    }

    public static String password() {
        if (preferences == null) {
            return null;
        }
        return preferences.getString(PASSWORD, null);
    }

    public static String token() {
        if (preferences == null) {
            return null;
        }
        return preferences.getString(ACCESS_TOKEN, null);
    }

    public static long conferenceTimeout() {
        if (preferences == null) {
            return -1L;
        }
        return preferences.getLong(CONFERENCE_TIMEOUT, -1L);
    }

    public static String uploadToken() {
        if (preferences == null) {
            return null;
        }
        return preferences.getString(UPLOAD_TOKEN, null);
    }

    public static String deviceIdentifier() {
        if (deviceIdentifier == null) {
            return null;
        }
        return deviceIdentifier;
    }

    public static boolean isFacebookConnected() {
        if (preferences == null) {
            return false;
        }
        return preferences.getBoolean(FACEBOOK_CONNECTED, false);
    }

    public static boolean isGoogleConnected() {
        if (preferences == null) {
            return false;
        }
        return preferences.getBoolean(GOOGLE_CONNECTED, false);
    }

    public static int delayMs() {
        if (preferences == null) {
            return 0;
        }
        return preferences.getInt(DELAY_ESTIMATION, -1);
    }

    public static boolean getAutoLogin() {
        return preferences.getBoolean(AUTOLOGIN, false);
    }

    public static void setAutoLogin(boolean value) {
        if (preferences != null) {
            preferences.edit().putBoolean(AUTOLOGIN, value).apply();
        }
    }

    public static void setLogin(String login) {
        if (preferences != null) {
            preferences.edit().putString(LOGIN, login).apply();
        }
    }

    public static void setConferenceTimeout(long timeout) {
        if (preferences != null) {
            preferences.edit().putLong(CONFERENCE_TIMEOUT, timeout).apply();
        }
    }

    public static void setPassword(String password) {
        if (preferences != null) {
            preferences.edit().putString(PASSWORD, password).apply();
        }
    }

    public static void onLogout() {
        if (preferences != null) {
            SharedPreferencesCacheWrapper.Editor editor = preferences.edit();
            editor.putString(LOGIN, "").putString(PASSWORD, "").putString(ACCESS_TOKEN, "").putString(UPLOAD_TOKEN, "").putString(COOKIE, "").putString(ID, "").putBoolean(FACEBOOK_CONNECTED, false).putBoolean(GOOGLE_CONNECTED, false).apply();
        }
    }

    public static String getLoginCookie() {
        return preferences.getString(COOKIE, null);
    }

    public static void saveLoginCookie(String cookie) {
        preferences.edit().putString(COOKIE, cookie).apply();
    }

    public static String getUploadToken() {
        if (preferences != null) {
            return preferences.getString(UPLOAD_TOKEN, null);
        }
        return null;
    }

    public static boolean isPremium() {
        if (preferences != null) {
            return preferences.getBoolean(PREMIUM, false);
        }
        return false;
    }

    public static void setIsPremium(boolean isPremium) {
        if (preferences != null) {
            preferences.edit().putBoolean(PREMIUM, isPremium).apply();
        }
    }

    public static void setUploadToken(String uploadToken) {
        if (preferences != null) {
            preferences.edit().putString(UPLOAD_TOKEN, uploadToken).apply();
        }
    }

    public static void setLastAddressBookImport(Date date) {
        if (preferences != null) {
            preferences.edit().putLong(ADDRESS_BOOK_SYNCED, date.getTime()).apply();
        }
    }

    public static Date getLastAddresssBookScan() {
        if (preferences != null && preferences.contains(ADDRESS_BOOK_SYNCED)) {
            return new Date(preferences.getLong(ADDRESS_BOOK_SYNCED, new Date().getTime()));
        }
        return null;
    }

    public static void setDefaultActivity(String pathActivity) {
        if (preferences != null) {
            preferences.edit().putString(DEFAULT_ACTIVITY, pathActivity).apply();
        }
    }

    public static String getDefaultActivity() {
        return preferences.getString(DEFAULT_ACTIVITY, null);
    }

    public static void setCurrentAccountType(@NonNull AccountType accountType) {
        sCurrentAccountType = accountType;
    }

    static {
        sCurrentAccountType = AccountType.SDK;
    }

    public static enum AccountType {
        SDK,
        GUEST,
        CONNECTED;


        static AccountType fromName(String name) {
            if (null == name) {
                return SDK;
            }
            switch (name) {
                case "CONNECTED": {
                    return CONNECTED;
                }
                case "GUEST": {
                    return GUEST;
                }
            }
            return SDK;
        }
    }
}

