/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.audio;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import java.util.ArrayList;
import java.util.List;

public class MessagingEnvironment {
    static final int defaultConnectionTimeout = 15000;
    static final int defaultKeepAliveInterval = 30000;
    static final int defaultReconnectionDelay = 1500;
    static final int defaultReconnectionLimit = 60000;
    static final int defaultMaxReconnectionAttempts = 5;
    private List<String> serverHosts = new ArrayList<String>();
    private int serverPort;
    private String stunHost;
    private int stunPort;
    private int connectionTimeout = 15000;
    private int searchPageSize;
    private int keepAliveInterval = 30000;
    private int reconnectionDelay = 1500;
    private int reconnectionLimit = 60000;
    private int maxReconnectionAttempts = 5;

    private MessagingEnvironment() {
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public int getReconnectionLimit() {
        return this.reconnectionLimit;
    }

    public int getMaxReconnectionAttempts() {
        return this.maxReconnectionAttempts;
    }

    public List<String> getServerHosts() {
        return this.serverHosts;
    }

    public void addServerHost(String address) {
        this.serverHosts.add(address);
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setStunHost(String stunHost) {
        this.stunHost = stunHost;
    }

    public String getStunHost() {
        return this.stunHost;
    }

    public void setStunPort(int stunPort) {
        this.stunPort = stunPort;
    }

    public int getStunPort() {
        return this.stunPort;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSearchPageSize() {
        return this.searchPageSize;
    }

    public void setSearchPageSize(int searchPageSize) {
        this.searchPageSize = searchPageSize;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public static class Builder {
        private Context _context;
        private MessagingEnvironment _messaging_environment = new MessagingEnvironment();

        private Builder() {
        }

        public Builder(@NonNull Context context) {
            this();
            this._context = context;
        }

        public Builder setServerHost(@StringRes int host) {
            this._messaging_environment.addServerHost(this._context.getString(host));
            return this;
        }

        public Builder setServerPort(@StringRes int port) {
            int server_port = Integer.parseInt(this._context.getString(port));
            this._messaging_environment.setServerPort(server_port);
            return this;
        }

        public Builder setStunHost(@StringRes int stun_host) {
            this._messaging_environment.setStunHost(this._context.getString(stun_host));
            return this;
        }

        public Builder setStunPort(@StringRes int stun_port) {
            int stun_server_port = Integer.parseInt(this._context.getString(stun_port));
            this._messaging_environment.setStunPort(stun_server_port);
            return this;
        }

        public MessagingEnvironment build() {
            return this._messaging_environment;
        }
    }
}

