package voxeet.com.sdk.audio;

public class PendingUserState implements AudioUserState {
	
	AudioPosition position;
	
	public PendingUserState() {
		position = DEFAULT_POSITION;
	}
	
	@Override
	public void updatePosition(double angle, double distance) {
		position = new AudioPosition(angle, distance);
	}
	
	@Override
	public void updateGain(float gain) {
		position = new AudioPosition(position.angle(), position.distance(), gain);
	}
	
	@Override
	public AudioPosition position() {
		return position;
	}

}
