/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.content.Context;
import android.os.Handler;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import com.neovisionaries.ws.client.WebSocketState;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.greenrobot.eventbus.EventBus;
import voxeet.com.sdk.core.VoxeetDispatcher;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.events.error.SocketConnectErrorEvent;
import voxeet.com.sdk.utils.DeviceStateUtils;
import voxeet.com.sdk.utils.Twig;

public class VoxeetWebSocket {
    private static final String TAG = VoxeetWebSocket.class.getSimpleName();
    private static Twig twig;
    public static final String SOCKET_ERROR = "SOCKET_ERROR";
    public static final String SOCKET_MESSAGE = "SOCKET_TEXT";
    public static final String SOCKET_CONNECTED = "SOCKET_CONNECTED";
    public static final String SOCKET_DISCONNECTED = "SOCKET_DISCONNECTED";
    public static final String SOCKET_STATE_CHANGE = "SOCKET_STATE_CHANGE";
    private static long SOCKET_RETRY_DEFAULT;
    private static long SOCKET_RETRY_MAX;
    private static long SOCKET_RETRY_CURRENT;
    private final int TIMEOUT = 5000;
    private final Context context;
    private final EventBus eventBus;
    private final VoxeetSdkTemplate sdk;
    private String socketUrl;
    private WebSocket webSocket;
    private ExecutorService es;
    private Handler handler = new Handler();
    private Runnable runnable;
    private String userToken;
    private static boolean shouldDisconnect;
    private WebSocketAdapter listener = new WebSocketAdapter(){

        public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
            super.onConnected(websocket, headers);
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_CONNECTED, "Connected");
        }

        public void onTextMessage(WebSocket websocket, String message) throws Exception {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_MESSAGE, message);
        }

        public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
            super.onError(websocket, cause);
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_ERROR, "Error " + cause.getMessage());
        }

        public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
            super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
            twig.e("Websocket disconnect", new Object[0]);
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_DISCONNECTED, "on Disconnected by server: " + closedByServer);
            VoxeetWebSocket.this.webSocket.removeListener((WebSocketListener)VoxeetWebSocket.this.listener);
            VoxeetWebSocket.this.webSocket = null;
            if (!shouldDisconnect) {
                VoxeetWebSocket.this.handler.postDelayed(VoxeetWebSocket.this.runnable, SOCKET_RETRY_CURRENT);
            }
        }

        public void onStateChanged(WebSocket websocket, WebSocketState newState) throws Exception {
            super.onStateChanged(websocket, newState);
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_STATE_CHANGE, newState.name());
        }
    };

    public VoxeetWebSocket(final Context context, VoxeetSdkTemplate sdk, String socketUrl) {
        this.context = context;
        this.sdk = sdk;
        twig = sdk.getTwig();
        this.socketUrl = socketUrl;
        this.es = Executors.newSingleThreadExecutor();
        this.eventBus = EventBus.getDefault();
        this.runnable = new Runnable(){

            @Override
            public void run() {
                if (DeviceStateUtils.isNetworkAvailable(context)) {
                    VoxeetWebSocket.this.connect(VoxeetWebSocket.this.userToken, new SocketListener(){

                        @Override
                        public void onConnect() {
                            twig.i("Socket reconnected successfully", new Object[0]);
                            VoxeetWebSocket.this.handler.removeCallbacks(VoxeetWebSocket.this.runnable);
                            SOCKET_RETRY_CURRENT = SOCKET_RETRY_DEFAULT;
                        }

                        @Override
                        public void onError(String error) {
                            twig.e("Socket failed to reconnect", new Object[0]);
                            SOCKET_RETRY_CURRENT = Math.min(SOCKET_RETRY_CURRENT * 2L, SOCKET_RETRY_MAX);
                            VoxeetWebSocket.this.handler.postDelayed(VoxeetWebSocket.this.runnable, SOCKET_RETRY_CURRENT);
                        }
                    });
                } else {
                    twig.e("Socket failed to reconnect", new Object[0]);
                    SOCKET_RETRY_CURRENT = Math.min(SOCKET_RETRY_CURRENT * 2L, SOCKET_RETRY_MAX);
                    VoxeetWebSocket.this.handler.postDelayed(VoxeetWebSocket.this.runnable, SOCKET_RETRY_CURRENT);
                }
            }
        };
    }

    private synchronized void initWebSocket() {
        try {
            WebSocketFactory factory = new WebSocketFactory();
            factory.setConnectionTimeout(5000);
            this.webSocket = factory.createSocket(this.socketUrl);
        }
        catch (IOException e) {
            twig.e(e);
            this.webSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String userToken, SocketListener socketListener) {
        VoxeetWebSocket voxeetWebSocket = this;
        synchronized (voxeetWebSocket) {
            this.close();
            this.userToken = userToken;
            if (DeviceStateUtils.isNetworkAvailable(this.context)) {
                this.initWebSocket();
                this.webSocket.addExtension("permessage-deflate");
                this.webSocket.clearHeaders();
                this.webSocket.addHeader("Voxeet-Token", userToken.replaceAll("\"", ""));
                this.webSocket.addListener((WebSocketListener)this.listener);
                Future future = this.webSocket.connect(this.es);
                try {
                    future.get();
                    this.initPing();
                    if (socketListener != null) {
                        socketListener.onConnect();
                    }
                    shouldDisconnect = false;
                    this.sdk.getUploadToken();
                    this.sdk.resetServices();
                    twig.i("Voxeet websocket successfully opened", new Object[0]);
                }
                catch (InterruptedException | ExecutionException e) {
                    if (socketListener != null) {
                        socketListener.onError(e.getMessage());
                    } else {
                        this.handler.postDelayed(this.runnable, SOCKET_RETRY_CURRENT);
                    }
                    this.close();
                    twig.e(e);
                    this.eventBus.post((Object)new SocketConnectErrorEvent(e.getMessage()));
                }
            } else {
                this.eventBus.post((Object)new SocketConnectErrorEvent("No network"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        VoxeetWebSocket voxeetWebSocket = this;
        synchronized (voxeetWebSocket) {
            if (this.webSocket != null) {
                shouldDisconnect = true;
                this.webSocket.disconnect();
            }
        }
    }

    public boolean isOpen() {
        return this.webSocket != null && this.webSocket.isOpen();
    }

    private boolean sendPing() {
        return this.webSocket != null && this.webSocket.sendPing().getState() == WebSocketState.OPEN;
    }

    public boolean isInit() {
        return this.webSocket != null && this.sendPing();
    }

    private void initPing() {
        if (this.webSocket != null) {
            this.webSocket.setPingInterval(30000L);
        }
    }

    static {
        SOCKET_RETRY_DEFAULT = 250L;
        SOCKET_RETRY_MAX = 8000L;
        SOCKET_RETRY_CURRENT = SOCKET_RETRY_DEFAULT;
        shouldDisconnect = false;
    }

    public static interface SocketListener {
        public void onConnect();

        public void onError(String var1);
    }
}

