package voxeet.com.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import voxeet.com.sdk.models.abs.UserProfile;
import voxeet.com.sdk.models.impl.DefaultOwnProfile;
import voxeet.com.sdk.models.impl.DefaultUserProfile;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OwnProfileRetrievedEvent {

    private DefaultOwnProfile user;

    public OwnProfileRetrievedEvent(UserProfile profile) {
        setUser(profile);
    }

    public UserProfile getUser() {
        return user;
    }

    public void setUser(UserProfile user) {
        this.user = new DefaultOwnProfile(user);
    }
}
