/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketState;
import java.util.ArrayList;
import java.util.List;
import voxeet.com.sdk.core.VoxeetDispatcher;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.network.websocket.ConnectListener;
import voxeet.com.sdk.core.network.websocket.SocketListener;
import voxeet.com.sdk.core.network.websocket.WebSocketProxy;
import voxeet.com.sdk.utils.Twig;

public class VoxeetWebSocket {
    private static final String TAG = VoxeetWebSocket.class.getSimpleName();
    private Twig twig;
    static final String SOCKET_ERROR = "SOCKET_ERROR";
    static final String SOCKET_MESSAGE = "SOCKET_TEXT";
    static final String SOCKET_CONNECTED = "SOCKET_CONNECTED";
    static final String SOCKET_DISCONNECTED = "SOCKET_DISCONNECTED";
    static final String SOCKET_STATE_CHANGE = "SOCKET_STATE_CHANGE";
    private Context context;
    private String socketUrl;
    private WebSocketProxy mWebSocketProxy;
    private List<ConnectListener> mConnectListeners;
    private ConnectListener mConnectListener;
    private SocketListener listener = new SocketListener(){

        @Override
        public void onConnect(WebSocket webSocket) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_CONNECTED, "Connected");
        }

        @Override
        public void onTextMessage(String message) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_MESSAGE, message);
        }

        @Override
        public void onError(WebSocketException exception) {
            exception.printStackTrace();
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_ERROR, "Error " + exception.getMessage());
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onStateChanged(WebSocketState newState) {
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_STATE_CHANGE, newState.name());
        }

        @Override
        public void onDisconnected() {
            VoxeetWebSocket.this.twig.e("Websocket disconnect by server", new Object[0]);
            VoxeetDispatcher.dispatch(VoxeetWebSocket.SOCKET_DISCONNECTED, "on Disconnected by server: ");
        }
    };

    public VoxeetWebSocket(Context context, VoxeetSdkTemplate sdk, String socketUrl) {
        this.context = context;
        this.twig = sdk.getTwig();
        this.socketUrl = socketUrl;
        this.mConnectListeners = new ArrayList<ConnectListener>();
        this.mConnectListener = new ConnectListener(){

            @Override
            public void onConnect(WebSocket websocket) {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onConnect(websocket);
                }
            }

            @Override
            public void onConnectError(Exception e) {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onConnectError(e);
                }
            }

            @Override
            public void onNoNetwork() {
                for (ConnectListener listener : VoxeetWebSocket.this.mConnectListeners) {
                    listener.onNoNetwork();
                }
            }
        };
    }

    public void connect(String userToken) {
        this.connect(userToken, null);
    }

    public void connect(@NonNull String userToken, @Nullable ConnectListener otherSocketListener) {
        if (this.mWebSocketProxy == null) {
            if (otherSocketListener != null) {
                this.mConnectListeners.add(otherSocketListener);
            }
            this.createProxy();
            this.mWebSocketProxy.connect(userToken, this.mConnectListener);
        } else {
            switch (this.mWebSocketProxy.getState()) {
                case CONNECTED: {
                    if (otherSocketListener == null) break;
                    otherSocketListener.onConnect(this.mWebSocketProxy.getWebSocket());
                    break;
                }
                case CONNECTING: {
                    if (otherSocketListener == null || this.mConnectListeners.contains(otherSocketListener)) break;
                    this.mConnectListeners.add(otherSocketListener);
                    break;
                }
                case CLOSED: {
                    this.clear();
                    this.createProxy();
                    this.mWebSocketProxy.connect(userToken, this.mConnectListener);
                }
            }
        }
    }

    private void clear() {
        this.mWebSocketProxy.disconnect();
        this.mWebSocketProxy.removeListener(this.listener);
        this.mWebSocketProxy.removeListeners();
        this.mWebSocketProxy.cancel();
        this.mWebSocketProxy = null;
    }

    private void createProxy() {
        this.mWebSocketProxy = new WebSocketProxy(this.context, null, this.socketUrl);
        this.mWebSocketProxy.addListener(this.listener);
    }

    public void close(boolean set_disconnect) {
        if (this.mWebSocketProxy != null) {
            this.clear();
        }
    }

    public boolean isOpen() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.isOpen();
    }

    private boolean sendPing() {
        return this.mWebSocketProxy != null && this.mWebSocketProxy.sendPing();
    }

    public boolean isInit() {
        return this.mWebSocketProxy != null && this.sendPing();
    }
}

