/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.network;

import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import rx.Observable;
import voxeet.com.sdk.events.success.GetTokenUploadSuccessEvent;
import voxeet.com.sdk.events.success.GetUserProfileSuccessEvent;
import voxeet.com.sdk.events.success.LoginSuccessResponseEvent;
import voxeet.com.sdk.events.success.OwnProfileSuccessEvent;
import voxeet.com.sdk.json.EmailEvent;
import voxeet.com.sdk.json.LoginEvent;
import voxeet.com.sdk.json.ResendActivationEvent;
import voxeet.com.sdk.json.ResetPasswordEvent;
import voxeet.com.sdk.json.SignUpEvent;
import voxeet.com.sdk.json.SocialLoginEvent;
import voxeet.com.sdk.json.UpdatePasswordEvent;
import voxeet.com.sdk.json.UpdatePresenceEvent;
import voxeet.com.sdk.json.UpdateProfileEvent;

public interface IUserRService {
    @POST(value="users/login")
    public Observable<LoginSuccessResponseEvent> login(@Body LoginEvent var1);

    @POST(value="mobile/loginValidated")
    public Observable<LoginSuccessResponseEvent> socialLogin(@Body SocialLoginEvent var1);

    @POST(value="users/logout")
    public Observable<Response<ResponseBody>> logout();

    @POST(value="users/resetPassword")
    public Observable<Response<ResponseBody>> resetPassword(@Body ResetPasswordEvent var1);

    @POST(value="users/create")
    public Observable<Response<ResponseBody>> signup(@Body SignUpEvent var1);

    @PUT(value="users/me")
    public Observable<Response<ResponseBody>> updateProfile(@Body UpdateProfileEvent var1);

    @PUT(value="users/me/updatePresence")
    public Observable<Response<ResponseBody>> updatePresence(@Body UpdatePresenceEvent var1);

    @GET(value="users/me")
    @Headers(value={"Content-Type: application/json"})
    public Observable<OwnProfileSuccessEvent> getOwnProfile();

    @GET(value="users/me/getUploadToken")
    @Headers(value={"Content-Type: application/json"})
    public Observable<GetTokenUploadSuccessEvent> getUploadToken();

    @GET(value="users/{userId}")
    public Observable<GetUserProfileSuccessEvent> getUserProfile(@Path(value="userId") String var1);

    @POST(value="users/resendActivation")
    public Observable<Response<ResponseBody>> resendActivation(@Body ResendActivationEvent var1);

    @POST(value="users/resendValidation")
    public Observable<Response<ResponseBody>> resendValidation(@Body ResendActivationEvent var1);

    @PUT(value="users/me/addEmail")
    public Observable<Response<ResponseBody>> addEmail(@Body EmailEvent var1);

    @PUT(value="users/me/removeEmail")
    public Observable<Response<ResponseBody>> removeEmail(@Body EmailEvent var1);

    @PUT(value="users/me/setDefaultEmail")
    public Observable<Response<ResponseBody>> setDefaultEmail(@Body EmailEvent var1);

    @PUT(value="/users/me/updatePassword")
    public Observable<Response<ResponseBody>> updatePassword(@Body UpdatePasswordEvent var1);
}

