/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.network.websocket;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import com.neovisionaries.ws.client.WebSocketState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import voxeet.com.sdk.core.network.websocket.ConnectListener;
import voxeet.com.sdk.core.network.websocket.SocketListener;
import voxeet.com.sdk.core.network.websocket.WebSocketProxyState;
import voxeet.com.sdk.utils.DeviceStateUtils;

public class WebSocketProxy
implements Runnable {
    private static final Handler HANDLER = new Handler();
    private static final int TIMEOUT = 5000;
    private static final int MAXIMUM_RETRY = 5;
    private static final long SOCKET_RETRY_MAX = 60000L;
    private WebSocketProxyState mState = WebSocketProxyState.CLOSED;
    private Context mContext;
    private ExecutorService mExecutorService;
    private String mSocketUrl;
    private int mCount = 0;
    private boolean mShouldRetry = true;
    private WebSocketAdapter mAdapter;
    private WebSocketAdapter mAdapterListener;
    private List<SocketListener> mListeners;
    private long mSocketCurrentRetryDelay;
    private String mUserToken;
    private WebSocketFactory mFactory;
    private WebSocket mWebSocket;
    private ConnectListener mConnectListener;
    private boolean mCanceled = false;

    public WebSocketProxy(Context context, WebSocketAdapter adapter, String socketUrl) {
        this.mSocketUrl = socketUrl;
        this.mFactory = new WebSocketFactory();
        this.mFactory.setConnectionTimeout(5000);
        this.mContext = context;
        this.mExecutorService = Executors.newSingleThreadExecutor();
        this.mListeners = new ArrayList<SocketListener>();
        this.mCount = 0;
        this.mAdapterListener = adapter;
        this.mAdapter = new WebSocketAdapter(){

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                if (WebSocketProxy.this.mCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                WebSocketProxy.this.mWebSocket = websocket;
                websocket.sendPing();
                websocket.setPingInterval(30000L);
                super.onConnected(websocket, headers);
                WebSocketProxy.this.mState = WebSocketProxyState.CONNECTED;
                WebSocketProxy.this.mCount = 0;
                WebSocketProxy.this.mShouldRetry = true;
                WebSocketProxy.this.attemptConnectListenerConnected(websocket);
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    listener.onConnect(websocket);
                }
            }

            public void onTextMessage(WebSocket websocket, String message) throws Exception {
                if (WebSocketProxy.this.mCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    listener.onTextMessage(message);
                }
            }

            public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
                if (WebSocketProxy.this.mCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                super.onError(websocket, cause);
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    listener.onError(cause);
                }
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                if (WebSocketProxy.this.mCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
                if (WebSocketProxy.this.mShouldRetry) {
                    if (WebSocketProxy.this.mCount < 5) {
                        WebSocketProxy.this.mState = WebSocketProxyState.CONNECTING;
                        WebSocketProxy.this.mCount++;
                        HANDLER.postDelayed((Runnable)WebSocketProxy.this, WebSocketProxy.this.mSocketCurrentRetryDelay);
                    } else {
                        WebSocketProxy.this.mState = WebSocketProxyState.CLOSED;
                        WebSocketProxy.this.attemptConnectListenerDisconnected();
                        WebSocketProxy.this.onDisconnected();
                    }
                } else {
                    WebSocketProxy.this.mState = WebSocketProxyState.CLOSED;
                    WebSocketProxy.this.onDisconnected();
                }
            }

            public void onStateChanged(WebSocket websocket, WebSocketState newState) throws Exception {
                if (WebSocketProxy.this.mCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                super.onStateChanged(websocket, newState);
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    listener.onStateChanged(newState);
                }
            }
        };
    }

    private void attemptConnectListenerDisconnected() {
        if (this.mCanceled) {
            this.checkCancel();
            return;
        }
        if (this.mConnectListener != null) {
            this.mConnectListener.onConnectError(new Exception("Socket disconnected" + this.mWebSocket));
            this.mConnectListener = null;
        }
    }

    private void attemptConnectListenerConnected(WebSocket webSocket) {
        if (this.mCanceled) {
            this.checkCancel();
            return;
        }
        if (this.mConnectListener != null) {
            this.mConnectListener.onConnect(webSocket);
            this.mConnectListener = null;
        }
    }

    private void initWebSocket() {
        if (this.mCanceled) {
            this.checkCancel();
            return;
        }
        try {
            this.mWebSocket = this.mFactory.createSocket(this.mSocketUrl);
        }
        catch (IOException e) {
            this.mWebSocket = null;
        }
    }

    public void connect(String userToken, ConnectListener connectListener) {
        if (this.mCanceled) {
            this.checkCancel();
            return;
        }
        this.mConnectListener = connectListener;
        this.mUserToken = userToken;
        if (DeviceStateUtils.isNetworkAvailable(this.mContext)) {
            this.mState = WebSocketProxyState.CONNECTING;
            this.initWebSocket();
            this.mWebSocket.setPingInterval(30000L);
            this.mWebSocket.addExtension("permessage-deflate");
            this.mWebSocket.clearHeaders();
            if (this.mUserToken != null) {
                this.mWebSocket.addHeader("Voxeet-Token", this.mUserToken.replaceAll("\"", ""));
            }
            this.mWebSocket.addListener((WebSocketListener)this.mAdapter);
            if (this.mAdapterListener != null) {
                this.mWebSocket.addListener((WebSocketListener)this.mAdapterListener);
            }
            this.mWebSocket.connect(this.mExecutorService);
        } else {
            this.mState = WebSocketProxyState.CLOSED;
            this.mConnectListener.onNoNetwork();
        }
    }

    private void onDisconnected() {
        if (this.mCanceled) {
            this.checkCancel();
            return;
        }
        for (SocketListener listener : this.mListeners) {
            listener.onDisconnected();
        }
    }

    public void addListener(@NonNull SocketListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(@NonNull SocketListener listener) {
        if (this.mListeners.contains(listener)) {
            this.mListeners.remove(listener);
        }
    }

    @Override
    public void run() {
        if (this.mCanceled) {
            this.checkCancel();
            return;
        }
        if (DeviceStateUtils.isNetworkAvailable(this.mContext)) {
            this.connect(this.mUserToken, this.mConnectListener);
        } else {
            this.mSocketCurrentRetryDelay = Math.min(this.mSocketCurrentRetryDelay * 2L, 60000L);
            HANDLER.postDelayed((Runnable)this, this.mSocketCurrentRetryDelay);
        }
    }

    public boolean isOpen() {
        return this.mWebSocket != null && this.mWebSocket.isOpen();
    }

    public boolean sendPing() {
        return this.mWebSocket != null && this.mWebSocket.sendPing().getState() == WebSocketState.OPEN;
    }

    public void disconnect() {
        this.mState = WebSocketProxyState.CLOSED;
        this.mCount = 5;
        this.mShouldRetry = false;
        this.mWebSocket.sendClose();
        this.mWebSocket.disconnect();
        for (SocketListener listener : this.mListeners) {
            listener.onClose();
        }
        this.mExecutorService.shutdown();
    }

    public void removeListeners() {
        this.mAdapterListener = null;
        this.mListeners.clear();
        this.mAdapter = null;
    }

    public WebSocketProxyState getState() {
        return this.mState;
    }

    public WebSocket getWebSocket() {
        return this.mWebSocket;
    }

    private void checkCancel() {
        if (this.mCanceled && this.isOpen()) {
            this.disconnect();
        }
    }

    public void cancel() {
        this.removeListeners();
        this.mCanceled = true;
    }
}

