package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultInvitation;
import voxeet.com.sdk.models.impl.DefaultUserProfile;

/**
 * Created by RomainB on 5/23/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.INVITATION_RECEIVED)
public class InvitationReceivedEvent extends Event {

    private String userId;

    private String conferenceId;

    private String meetingId;

    private DefaultUserProfile ownerProfile;

    private String title;

    private String description;

    private List<DefaultInvitation> invitations;

    private String conferenceHost;

    private String conferencePort;

    private String conferenceSecurityToken;

    @JsonProperty("conferenceInfo")
    private DefaultConference conference;

    public List<DefaultInvitation> getInvitations() {
        return invitations;
    }

    public void setInvitations(List<DefaultInvitation> invitations) {
        this.invitations = invitations;
    }

    public String getConferenceHost() {
        return conferenceHost;
    }

    public void setConferenceHost(String conferenceHost) {
        this.conferenceHost = conferenceHost;
    }

    public String getConferencePort() {
        return conferencePort;
    }

    public void setConferencePort(String conferencePort) {
        this.conferencePort = conferencePort;
    }

    public String getConferenceSecurityToken() {
        return conferenceSecurityToken;
    }

    public void setConferenceSecurityToken(String conferenceSecurityToken) {
        this.conferenceSecurityToken = conferenceSecurityToken;
    }

    public DefaultConference getConference() {
        return conference;
    }

    public void setConference(DefaultConference conference) {
        this.conference = conference;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public DefaultUserProfile getOwnerProfile() {
        return ownerProfile;
    }

    public void setOwnerProfile(DefaultUserProfile ownerProfile) {
        this.ownerProfile = ownerProfile;
    }

    @Override
    public String getType() {
        return EventNames.INVITATION_RECEIVED;
    }
}
