/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.factories;

import android.content.Context;
import android.content.Intent;
import java.util.Map;

public class VoxeetIntentFactory {
    private static final String defaultError = "Default activity to be triggered when receiving a notification has not been set. Please use setPathToActivity() with the path of the desired activity.";
    public static final String CONF_ID = "ConfId";
    public static final String INVITER_NAME = "DisplayName";
    public static final String INVITER_ID = "ExternalId";
    public static final String INVITER_URL = "AvatarUrl";
    public static final String NOTIF_TYPE = "NotifType";

    private static Class<?> createClass(String path) {
        if (path == null) {
            throw new IllegalStateException(defaultError);
        }
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Intent buildFrom(Context context, String path, Map<String, String> data) {
        Class<?> newClass = VoxeetIntentFactory.createClass(path);
        if (newClass != null) {
            Intent intent = new Intent();
            intent.setClass(context, newClass);
            if (data.containsKey(CONF_ID)) {
                intent.putExtra("conferenceId", data.get(CONF_ID));
            }
            if (data.containsKey(INVITER_URL)) {
                intent.putExtra("avatarUrl", data.get(INVITER_URL));
            }
            if (data.containsKey(INVITER_NAME)) {
                intent.putExtra("inviterName", data.get(INVITER_NAME));
            }
            if (data.containsKey(INVITER_ID)) {
                intent.putExtra("inviterId", data.get(INVITER_ID));
            }
            intent.putExtra("join", true);
            intent.putExtra("callMode", 1);
            intent.addFlags(4);
            intent.addFlags(0x10000000);
            return intent;
        }
        return null;
    }
}

