/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import android.widget.Toast;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.android.media.Media;
import com.voxeet.kernel.R;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import okhttp3.OkHttpClient;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Retrofit;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetHttp;
import voxeet.com.sdk.core.VoxeetPreferences;
import voxeet.com.sdk.core.VoxeetWebSocket;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.services.ConferenceService;
import voxeet.com.sdk.core.services.UserService;
import voxeet.com.sdk.events.success.SocketStateChangeEvent;
import voxeet.com.sdk.factories.EventsFactory;
import voxeet.com.sdk.json.Event;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.TokenResponse;
import voxeet.com.sdk.models.UserTokenResponse;
import voxeet.com.sdk.utils.ConferenceListener;
import voxeet.com.sdk.utils.Twig;
import voxeet.com.sdk.utils.VoxeetServerUrl;

public abstract class VoxeetSdkTemplate<T extends AbstractConferenceSdkService>
implements ConferenceListener {
    static final long DEFAULT_TIMEOUT_MS = 10000L;
    private UserInfo _user_info;
    private VoxeetWebSocket _voxeet_websocket;
    private VoxeetHttp _voxeet_http;
    protected Context _application_context;
    protected EventBus _event_bus;
    private Twig _twig;
    private VoxeetServerUrl _voxeet_server_url;
    private HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> _services;

    private VoxeetSdkTemplate() {
    }

    protected VoxeetSdkTemplate(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo, boolean debug) {
        this();
        this._application_context = application_context;
        this._event_bus = EventBus.getDefault();
        this.onSdkPreinit();
        this._user_info = userInfo;
        this._twig = new Twig(2, "VoxeetSDK :: " + this.getTag(), false);
        this._voxeet_server_url = new VoxeetServerUrl(this);
        this._voxeet_websocket = new VoxeetWebSocket((Context)application_context, this, this._voxeet_server_url.getSocketUrl());
        this._voxeet_http = new VoxeetHttp.Builder().setApplication(application_context).setVoxeetSDK(this).setServerUrl(this._voxeet_server_url.getServerUrl()).setServerPort(this._voxeet_server_url.getServerPort()).setAppId(appId).setPassword(password).setVoxeetServiceListener(new VoxeetHttp.VoxeetServiceListener(){

            @Override
            public void onIdentifySuccess(UserTokenResponse userToken, TokenResponse tokenResponse) {
                VoxeetSdkTemplate.this._twig.d("onIdentifySuccess " + userToken + " " + tokenResponse, new Object[0]);
                VoxeetSdkTemplate.this._voxeet_websocket.connect(userToken.getUserToken());
            }

            @Override
            public void onIdentifyError(String error) {
                Log.e((String)VoxeetSdkTemplate.this.getTag(), (String)error);
            }

            @Override
            public void onNetworkError(UnknownHostException error) {
                VoxeetSdkTemplate.this._event_bus.post((Object)new SocketStateChangeEvent("CLOSED"));
            }
        }).setDebug(debug).build();
        this._services = new HashMap();
        VoxeetPreferences.init(this.getApplicationContext());
        this.initServices();
    }

    public void logUser(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        this.openSdkSession();
    }

    public abstract void logout();

    public abstract void onSdkPreinit();

    protected abstract void initServices();

    protected HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> getServices() {
        return this._services;
    }

    public T getConferenceService() {
        return (T)this.getServiceForKlass(AbstractConferenceSdkService.class);
    }

    public void sendConferenceReminder(List<String> ids) {
        ConferenceService service = this.getServiceForKlass(ConferenceService.class);
        if (service != null) {
            service.sendReminder(ids);
        }
    }

    protected <T extends AbstractVoxeetService> T getServiceForKlass(Class<T> klass) {
        AbstractVoxeetService service = null;
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService item = this._services.get(next);
            if (!klass.isInstance(item)) continue;
            service = item;
        }
        if (service == null) {
            this.getTwig().e(klass.getSimpleName() + " not found in the list of services", new Object[0]);
        }
        return (T)service;
    }

    public void sendConferenceMessage(String message) {
        ConferenceService service = this.getServiceForKlass(ConferenceService.class);
        if (service != null) {
            service.sendMessage(message);
        }
    }

    public void getUploadToken() {
        UserService service = this.getServiceForKlass(UserService.class);
        if (service != null) {
            service.getUploadToken();
        }
    }

    public void send(Event command) {
        ObjectMapper om = new ObjectMapper();
        try {
            this.sendConferenceMessage(om.writeValueAsString((Object)command));
        }
        catch (JsonProcessingException e) {
            Log.e((String)Event.TAG, (String)"failed to send command", (Throwable)e);
        }
    }

    public Event decode(String message) {
        return EventsFactory.decode(message);
    }

    public Twig getTwig() {
        return this._twig;
    }

    public Retrofit getRetrofit() {
        return this._voxeet_http.getRetrofit();
    }

    public OkHttpClient getClient() {
        return this._voxeet_http.getClient();
    }

    public Context getApplicationContext() {
        return this._application_context;
    }

    public VoxeetServerUrl getVoxeetServerUrl() {
        return this._voxeet_server_url;
    }

    public void resetServices() {
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            this._services.get(next).resetService();
        }
    }

    public EventBus getEventBus() {
        return this._event_bus;
    }

    protected VoxeetWebSocket getSocket() {
        return this._voxeet_websocket;
    }

    protected VoxeetHttp getVoxeetHttp() {
        return this._voxeet_http;
    }

    public void closeSocket() {
        this._voxeet_websocket.close(true);
    }

    public boolean isSocketOpen() {
        return this._voxeet_websocket.isOpen();
    }

    public void openSdkSession() {
        this._voxeet_http.identify(this._user_info);
    }

    @Override
    public void onCreationSuccess(String conferenceId) {
        AbstractConferenceSdkService service = this.getServiceForKlass(AbstractConferenceSdkService.class);
        if (service != null) {
            service.join(conferenceId);
        }
    }

    protected abstract String getTag();

    public boolean register(Context context, Object subscriber) {
        try {
            Media.Register((Context)context);
            if (!this.getEventBus().isRegistered(subscriber)) {
                this.getEventBus().register(subscriber);
            }
        }
        catch (UnsatisfiedLinkError error) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)context.getString(R.string.register_conf_error), (int)0).show();
            return false;
        }
        return true;
    }

    public void unregister(Object subscriber) {
        Media.UnRegister();
        if (this.getEventBus().isRegistered(subscriber)) {
            this.getEventBus().unregister(subscriber);
        }
    }
}

