package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultInvitation;
import voxeet.com.sdk.models.impl.DefaultUserProfile;

/**
 * Created by rreynaud on 06/04/16.
 */

@JsonIgnoreProperties(ignoreUnknown = true)
public class GuestAccessResponse {

    private String userId;

    private DefaultUserProfile owner;

    private long startDate;

    private long endDate;

    private String meetingId;

    @JsonProperty("conference")
    private DefaultConference conference;

    private List<DefaultInvitation> invitations;

    public List<DefaultInvitation> getInvitations() {
        return invitations;
    }

    public void setInvitations(List<DefaultInvitation> invitations) {
        this.invitations = invitations;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DefaultConference getConference() {
        return conference;
    }

    public void setConference(DefaultConference conference) {
        this.conference = conference;
    }

    public DefaultUserProfile getOwner() {
        return owner;
    }

    public void setOwner(DefaultUserProfile owner) {
        this.owner = owner;
    }

    public long getStartDate() {
        return startDate;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public long getEndDate() {
        return endDate;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }
}
