package voxeet.com.sdk.core;

import android.support.annotation.NonNull;
import android.util.Log;

import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;

/**
 * Simple Firebase wrapper
 *
 * Note that when the app is awaken from a killed-state (notifications), don't forget to init it in your
 * own Application override
 *
 * note : in the current version, the isEnabled() method has been renamed to
 * isTokenUploadAllowed(), in a future release it can switch back to its "normal" behaviour
 */
public class FirebaseController {
    private final static FirebaseController _sinstance = new FirebaseController();

    public final static FirebaseController getInstance() {
        return _sinstance;
    }

    private boolean _enabled;
    private boolean _can_log;

    private FirebaseController() {
        _enabled = false;
        _can_log = false;
    }

    /**
     * Define if the current workflow is enabled
     *
     * Note : enabling the controller will only tell if the user's device token will
     * be uploaded.
     *
     * @param is_enable true or false
     * @return the current controller to chain
     */
    public FirebaseController enable(boolean is_enable) {
        _enabled = is_enable;
        return this;
    }

    /**
     * Defined if the current controller will log incoming strings
     * @param can_log true or false
     * @return the current controller to chain
     */
    public FirebaseController log(boolean can_log) {
        _can_log = can_log;
        return this;
    }

    /**
     *
     * @return if the user token will be uploaded
     */
    public boolean isTokenUploadAllowed() {
        return _enabled;
    }

    public FirebaseController log(@NonNull String string) {
        if (_can_log) Log.d(getClass().getSimpleName(), string);
        return this;
    }

    public String getToken() {
        try {
            return FirebaseInstanceId.getInstance().getToken();
        } catch(IllegalStateException e){
            return null;
        }
    }
}
