/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.audio;

import android.content.Context;
import android.telecom.Conference;
import android.util.Log;
import com.voxeet.android.media.Media;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.settings.AudioSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class AudioSession {
    static final String TAG = AudioSession.class.getSimpleName();
    private final Context context;
    private final String localUser;
    private final Conference conference;
    private final Map<UUID, String> activeUsers = new HashMap<UUID, String>();
    private Media media;

    public AudioSession(Context context, Conference conference) {
        this.context = context;
        this.conference = conference;
        this.localUser = null;
    }

    public synchronized boolean isStarted() {
        return this.media != null;
    }

    public synchronized void start(AudioSettings settings) {
    }

    public synchronized void stop() {
        if (this.media != null) {
            // empty if block
        }
    }

    public void registerListener(Media.MediaStateListener listener) {
        if (this.media != null) {
            this.media.registerListener(listener);
        }
    }

    public void unregisterListener() {
        if (this.media != null) {
            this.media.unregisterListener();
        }
    }

    public void addSource(String userId, long ssrc) {
    }

    public void removeSource(String userId) {
    }

    public SdpMessage createOffer(UUID userId, boolean master) {
        return null;
    }

    public void setAnswer(UUID userId, SdpMessage answer) {
    }

    public SdpMessage createAnswer(UUID userId, SdpMessage offer, boolean isMaster) {
        return null;
    }

    public boolean isBluetoothHeadsetOn() {
        return this.media != null ? this.media.isBluetoothHeadsetOn() : false;
    }

    public boolean isWiredHeadsetOn() {
        return this.media != null ? this.media.isWiredHeadsetOn() : false;
    }

    public void setBluetooth(boolean isEnabled) {
        if (this.media != null) {
            this.media.setBluetooth(isEnabled);
        }
    }

    public void setSpeakerMode(boolean value) {
        if (this.media != null) {
            this.media.setSpeakerMode(value);
        }
    }

    public void setOutputRoute(Media.AudioRoute route) {
        if (this.media != null) {
            this.media.setOutputRoute(route);
        }
    }

    public Media.AudioRoute outputRoute() {
        Media.AudioRoute route = Media.AudioRoute.ROUTE_PHONE;
        if (this.media != null) {
            route = this.media.outputRoute();
        }
        return route;
    }

    public List<Media.AudioRoute> availableRoutes() {
        return this.media != null ? this.media.availableRoutes() : new ArrayList();
    }

    public int audioReporting(int[] data) {
        return 0;
    }

    public void networkReporting(int[] data) {
        if (this.media != null) {
            // empty if block
        }
    }

    public void mute() {
        if (this.media != null) {
            this.media.muteRecording();
        }
    }

    public void unMute() {
        if (this.media != null) {
            this.media.unMuteRecording();
        }
    }

    public boolean isMuted() {
        return this.media != null ? this.media.isMuted() : false;
    }

    public synchronized int getLocalVuMeter() {
        return this.media != null ? this.media.getLocalVuMeter() : 0;
    }

    public synchronized int getPeerVuMeter(String peer) {
        return this.media != null ? this.media.getPeerVuMeter(peer) : 0;
    }

    public void updatePosition(UUID userId, double angle, double distance) {
        Log.e((String)TAG, (String)(angle + " _ " + distance));
        if (this.media != null && this.activeUsers.containsKey(userId)) {
            this.media.changePeerPosition(userId.toString(), angle, distance);
        }
    }

    public void updatePosition(UUID userId, double angle, double distance, float gain) {
        if (this.media != null && this.activeUsers.containsKey(userId)) {
            this.media.changePeerPosition(userId.toString(), angle, distance, gain);
        }
    }

    public void updateGain(UUID userId, float gain) {
        if (this.media != null && this.activeUsers.containsKey(userId)) {
            this.media.changePeerGain(userId.toString(), gain);
        }
    }

    public void setCodecQuality(int quality) {
        if (this.media != null) {
            this.media.setCodecQuality(quality);
        }
    }

    public void upgradeQuality() {
    }

    public void downgradeQuality() {
    }

    public boolean pstnNeeded() {
        if (this.media != null) {
            return this.media.pstnNeeded();
        }
        return false;
    }

    private void doAddSource(String userId, long ssrc) {
    }

    private void doRemoveSource(String userId) {
    }
}

