package voxeet.com.sdk.promise;

/**
 * Created by kevinleperf on 06/04/2018.
 */

public abstract class SuccessPromise<TYPE, RESULT> extends AbstractPromiseCallbackImpl<TYPE, RESULT> {

    /**
     * Success method, called from Promise's then()
     *
     * @param result
     */
    public abstract void onSuccess(TYPE result);

    /**
     * Final method, only forward the given error
     *
     * @param error
     */
    @Override
    public final void onError(Throwable error) {
        reject(error);
    }
}
