package voxeet.com.sdk.promise;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * Class used as a main entry point for the Promise
 */

public abstract class PromiseSolver<TYPE> {
    // parent of this solver
    private Promise mParent;

    /**
     * No parameters, used to force implementation
     */
    public PromiseSolver() {

    }

    /**
     * Call resolve or reject in this method implementation
     *
     * Warning : if you use an async call, the library does not make sure
     * for now, if your call stays in any specific thread/looper...
     */
    public abstract void onCall();

    /**
     * Make the call resolve
     *
     * @param result
     */
    public final void resolve(@Nullable TYPE result) {
        mParent.resolve(result);
    }

    /**
     * Reject the current branch
     *
     * @param error the error to send
     */
    public void reject(@NonNull Throwable error) {
        mParent.reject(error);
    }

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
     * Internal methods
     * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

    /**
     *
     * @param parent
     */
    void setParent(Promise<TYPE> parent) {
        mParent = parent;
    }
}
