package voxeet.com.sdk.core.abs;

import com.voxeet.android.media.peer.SdpDescription;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Response;
import rx.Observable;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.DeviceEvent;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.SubscribeConference;

/**
 * Created by kevinleperf on 13/11/2017.
 */

public abstract class AbstractConferenceSdkObservableProvider<T, DemoEvent> {

    protected abstract T getService();

    public abstract void setRetrofitInstantiatedProvider(T service);

    public abstract Class getRetrofitInjectedClass();

    public abstract Observable<Response<ResponseBody>> leaveConference(String conferenceId);

    public abstract Observable<Response<ResponseBody>> getDeclineObservable(String conferenceId);

    public abstract Observable<StartVideoResponse> getStartVideoObservable(String conferenceId, String id);

    public abstract Observable<StopVideoResponse> getStopVideoObservable(String conferenceId, String id);

    public abstract Observable<ConferenceResponse> getCreateConferenceObservable();

    public abstract Observable<DemoEvent> getCreateDemoObservable();

    public abstract Observable<Response<ResponseBody>> getInviteObservable(String conferenceId, SdkConferenceInvitation sdkConferenceInvitation);

    public abstract Observable<ReplayConferenceEvent> getReplayObservable(String conferenceId, SdkConferenceReplayBody sdkConferenceReplayBody);

    public abstract Observable<Response<ResponseBody>> getStartRecordingObservable(String conferenceId);

    public abstract Observable<Response<ResponseBody>> getStopRecordingObservable(String conferenceId);

    public abstract Observable<Response<ResponseBody>> getLogOutObservable(String token);

    public abstract Observable<GetConferenceStatusEvent> getConferenceStatusObservable(String conferenceId);

    public abstract Observable<List<HistoryConference>> getConferenceHistoryObservable(String conferenceId);

    public abstract Observable<SubscribeConference> getSubscribeObservable(String conferenceId);

    public abstract Observable<Response<ResponseBody>> getUnSubscribeObservable(String conferenceId);

    public abstract Observable<Response<ResponseBody>> getSubscribeForCallObservable(String conferenceId);

    public abstract Observable<Response<ResponseBody>> getUnSubscribeFromCallObservable(String conferenceId);

    public abstract Observable<ResumeConference> joinConference(String conferenceId, DeviceEvent deviceEvent);

    public abstract Observable<Response<ResponseBody>> answerConference(String conferenceId, String peer, SdpDescription description);

    public abstract Observable<Response<ResponseBody>> broadcastMessage(String conferenceId, BroadcastEvent broadcastEvent);
}
