/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.promise;

import android.os.Handler;
import android.support.annotation.NonNull;
import voxeet.com.sdk.promise.AbstractPromiseCallbackImpl;
import voxeet.com.sdk.promise.ErrorPromise;
import voxeet.com.sdk.promise.IllegalPromiseStateException;
import voxeet.com.sdk.promise.PromiseSolver;
import voxeet.com.sdk.promise.SuccessPromise;

public class Promise<TYPE> {
    private final Handler mHandler = new Handler();
    private AbstractPromiseCallbackImpl mPromiseCallback;
    private PromiseSolver<TYPE> mPromiseSolver;
    private Promise mParent;
    private Promise mChild;
    private TYPE mResult;
    private boolean mDone;
    private boolean mRejected = false;
    private boolean mPosted = false;
    private boolean mIsSync;

    public Promise() {
    }

    public Promise(PromiseSolver<TYPE> solver) {
        this();
        solver.setParent(this);
        this.mPromiseSolver = solver;
    }

    private Promise(Promise<TYPE> parent) {
        this();
        this.mParent = parent;
    }

    public Promise(Promise parent, AbstractPromiseCallbackImpl success_promise) {
        this(parent);
        success_promise.setPromise(this);
        this.mPromiseCallback = success_promise;
    }

    public <TYPE_RESULT> Promise<TYPE_RESULT> then(@NonNull SuccessPromise<TYPE, TYPE_RESULT> success_promise) {
        this.mChild = new Promise<TYPE>(this, success_promise);
        return this.mChild.setResolveBlock(this.mIsSync);
    }

    public void error(@NonNull ErrorPromise error_promise) {
        this.mChild = new Promise<TYPE>(this, error_promise).setResolveBlock(this.mIsSync);
        this.execute();
    }

    public void execute() {
        if (this.mParent != null) {
            this.mParent.execute();
        } else if (null != this.mPromiseSolver) {
            this.mPromiseSolver.onCall();
        }
    }

    public Promise<TYPE> setResolveBlock(boolean is_sync) {
        this.mIsSync = is_sync;
        return this;
    }

    void resolve(TYPE result) {
        if (this.mRejected) {
            return;
        }
        if (this.mDone) {
            this.throwError();
        }
        this.mDone = true;
        this.setResult(result);
    }

    void reject(Throwable error) {
        this.mRejected = true;
        if (this.mDone) {
            this.throwError();
        }
        this.mDone = true;
        if (this.mChild != null) {
            this.mChild.reject(error);
        } else if (this.mPromiseCallback != null) {
            this.mPromiseCallback.onError(error);
        } else {
            error.printStackTrace();
        }
    }

    private void execute(TYPE result) {
        if (this.mPromiseCallback != null) {
            this.mPromiseCallback.onSuccess(result);
        }
    }

    private void setResult(TYPE result) {
        this.mPosted = true;
        this.mResult = result;
        if (this.mRejected) {
            return;
        }
        this.tryNext();
    }

    private void throwError() {
        throw new IllegalPromiseStateException("The promise has already been resolved/rejected");
    }

    private void tryNext() {
        if (this.mIsSync) {
            if (this.mPosted && this.mChild != null) {
                this.mChild.execute(this.mResult);
            }
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (Promise.this.mPosted && Promise.this.mChild != null) {
                        Promise.this.mChild.execute(Promise.this.mResult);
                    }
                }
            });
        }
    }
}

