/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.impl;

import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.impl.ConferenceSdkObservableProvider;
import voxeet.com.sdk.core.network.ISdkConferenceRService;
import voxeet.com.sdk.events.success.ConferenceCreationSuccess;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.ConferenceType;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

public class ConferenceSdkService
extends AbstractConferenceSdkService<ISdkConferenceRService, ConferenceSdkObservableProvider, ConferenceResponse> {
    public ConferenceSdkService(VoxeetSdkTemplate instance, long timeout) {
        super(instance, new ConferenceSdkObservableProvider(), timeout, instance.getRetrofit().create(ISdkConferenceRService.class));
    }

    @Override
    protected void onCreateDemoSuccess(ConferenceResponse response) {
        DefaultConference conference = this.createConference();
        conference.setConferenceId(response.getConfId());
        conference.setConferenceType(ConferenceType.DEMO.value());
        String conferenceAlias = response.getConfAlias();
        this.setConference(conference);
        this.setConferenceAlias(conferenceAlias);
        this.getTwig().i("Demo conference created with id: " + conference.getConferenceId(), new Object[0]);
        this.getEventBus().post((Object)new ConferenceCreationSuccess(response.getConfId(), response.getConfAlias()));
        this.onCreationSuccess(response.getConfId());
    }

    @Override
    protected DefaultConference createConference() {
        return new DefaultConference();
    }

    @Override
    protected DefaultConferenceUser createConferenceUser(String userId, String device, UserInfo userInfo) {
        return new DefaultConferenceUser(userId, device, userInfo);
    }

    @Override
    protected void startTransactionConferenceUser() {
    }

    @Override
    protected void commitTransactionConferenceUser() {
    }

    @Override
    protected boolean isSDK() {
        return true;
    }
}

