/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.HttpException;
import voxeet.com.sdk.core.VoxeetJsonError;

public abstract class AbstractVoxeetService<T> {
    private static final String TAG = AbstractVoxeetService.class.getSimpleName();
    protected OkHttpClient client;
    protected EventBus eventBus = EventBus.getDefault();
    protected Retrofit retrofit;
    private T service;
    private Date lastUpdate = null;
    private boolean isLoaded = false;
    private int UPDATE_TIME = 300000;
    protected static final Handler handler = new Handler(Looper.getMainLooper());
    protected ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected Context context;

    private AbstractVoxeetService() {
    }

    protected AbstractVoxeetService(@NonNull Context context, @Nullable OkHttpClient client, @Nullable Retrofit retrofit, @Nullable Class<T> service_klass) {
        this(context, client, retrofit, (service_klass != null ? retrofit.create(service_klass) : null));
    }

    protected AbstractVoxeetService(@NonNull Context context, @Nullable OkHttpClient client, @Nullable Retrofit retrofit, @Nullable T service_klass_instantiated) {
        this();
        this.retrofit = retrofit;
        this.context = context;
        this.client = client;
        this.service = service_klass_instantiated;
    }

    protected void updateTimeStamp() {
        this.lastUpdate = new Date();
    }

    protected boolean isLoaded() {
        return this.isLoaded;
    }

    protected void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    protected boolean shouldUpdate() {
        if (this.lastUpdate == null) {
            return true;
        }
        return new Date().getTime() - this.lastUpdate.getTime() > (long)this.UPDATE_TIME;
    }

    protected final T getService() {
        return this.service;
    }

    protected String handleError(Throwable e) {
        if (e instanceof HttpException) {
            try {
                ResponseBody body = ((HttpException)e).response().errorBody();
                return body.string();
            }
            catch (IOException exception) {
                Log.e((String)TAG, (String)("error: " + exception.getMessage()));
            }
        }
        return e.getMessage();
    }

    protected static VoxeetJsonError getErrorBody(String message) {
        ObjectMapper om = new ObjectMapper();
        VoxeetJsonError command = null;
        try {
            command = (VoxeetJsonError)om.readValue(message, VoxeetJsonError.class);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"failed to get error body", (Throwable)e);
        }
        return command;
    }

    public void resetService() {
        this.lastUpdate = null;
        this.isLoaded = false;
    }

    protected void registerEventBus() {
        if (!this.eventBus.isRegistered((Object)this)) {
            this.eventBus.register((Object)this);
        }
    }

    protected void unRegisterEventBus() {
        if (this.eventBus.isRegistered((Object)this)) {
            this.eventBus.unregister((Object)this);
        }
    }

    protected void postOnMainThread(@NonNull Runnable runnable) {
        handler.post(runnable);
    }
}

