package voxeet.com.sdk.events.success;

import voxeet.com.sdk.events.SuccessEvent;

/**
 * Created by RomainBenmansour on 4/18/16.
 */
public class ConferenceLeftSuccessEvent extends SuccessEvent {
    private boolean remainInConferenceRoom;

    private int remainingUsers;

    public ConferenceLeftSuccessEvent(boolean remainInConferenceRoom) {
        this.remainInConferenceRoom = remainInConferenceRoom;

        this.remainingUsers = -1;
    }

    public ConferenceLeftSuccessEvent() {
        remainInConferenceRoom = false;
    }

    public ConferenceLeftSuccessEvent(int usersLeft) {
        remainingUsers = usersLeft;
    }

    public int getRemainingUsers() {
        return remainingUsers;
    }

    public boolean isRemainInConferenceRoom() {
        return remainInConferenceRoom;
    }

    public void setRemainInConferenceRoom(boolean remainInConferenceRoom) {
        this.remainInConferenceRoom = remainInConferenceRoom;
    }
}
