/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.preferences;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;

public class SharedPreferencesCacheWrapper {
    @NonNull
    private HashMap<String, String> _strings = new HashMap();
    @NonNull
    private HashMap<String, Boolean> _booleans = new HashMap();
    @NonNull
    private HashMap<String, Long> _longs = new HashMap();
    @NonNull
    private HashMap<String, Integer> _ints = new HashMap();
    private SharedPreferences _preferences;

    private SharedPreferencesCacheWrapper() {
    }

    public SharedPreferencesCacheWrapper(SharedPreferences preferences) {
        this();
        this._preferences = preferences;
    }

    @NonNull
    public Editor edit() {
        return new Editor(this);
    }

    @Nullable
    public String getString(@NonNull String key, @Nullable String def) {
        if (this._strings.containsKey(key)) {
            return this._strings.get(key);
        }
        String result = this._preferences.getString(key, def);
        return result;
    }

    public boolean getBoolean(@NonNull String key, boolean def) {
        if (this._booleans.containsKey(key)) {
            return this._booleans.get(key);
        }
        return this._preferences.getBoolean(key, def);
    }

    public int getInt(@NonNull String key, int def) {
        if (this._ints.containsKey(key)) {
            return this._ints.get(key);
        }
        return this._preferences.getInt(key, def);
    }

    public long getLong(@NonNull String key, long def) {
        if (this._longs.containsKey(key)) {
            return this._longs.get(key);
        }
        return this._preferences.getLong(key, def);
    }

    public boolean contains(@NonNull String key) {
        if (this._strings.containsKey(key)) {
            return true;
        }
        if (this._booleans.containsKey(key)) {
            return true;
        }
        if (this._longs.containsKey(key)) {
            return true;
        }
        return this._preferences.contains(key);
    }

    public class Editor {
        private SharedPreferencesCacheWrapper _wrapper;
        private SharedPreferences.Editor _editor;

        private Editor() {
        }

        protected Editor(SharedPreferencesCacheWrapper wrapper) {
            this();
            this._wrapper = wrapper;
            this._editor = wrapper._preferences.edit();
        }

        public Editor putString(@NonNull String key, @Nullable String value) {
            this._wrapper._strings.put(key, value);
            this._editor.putString(key, value);
            return this;
        }

        public Editor putLong(@NonNull String key, long value) {
            this._wrapper._longs.put(key, value);
            this._editor.putLong(key, value);
            return this;
        }

        public Editor putBoolean(@NonNull String key, boolean value) {
            this._wrapper._booleans.put(key, value);
            this._editor.putBoolean(key, value);
            return this;
        }

        public Editor putInt(@NonNull String key, int value) {
            this._wrapper._ints.put(key, value);
            this._editor.putInt(key, value);
            return this;
        }

        public void apply() {
            this._editor.apply();
        }
    }
}

