package voxeet.com.sdk.promise;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * Simple interface which will give success and error methods
 */

public interface IPromise<TYPE> {

    /**
     * Success method, called from Promise's then()
     *
     * @param result
     */
    void onSuccess(@Nullable TYPE result);

    /**
     * Final method, called from Promise's error()
     *
     * @param error
     */
    void onError(@NonNull Throwable error);
}
