package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.Locale;
import java.util.TimeZone;

import voxeet.com.sdk.utils.Sha1;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.SIGN_UP)
public class SignUpEvent extends Event {

    private String bytePassword;

    private String email;

    private String country;

    private String company;

    private String deviceType;

    private String password;

    private String nickName;

    private String firstName;

    private String lastName;

    private String timezone;

    private String locale;

    public SignUpEvent(String email, String password, String firstName, String lastName) {
        this.email = email;

        this.firstName = firstName;

        this.lastName = lastName;

        this.nickName = firstName + " " + lastName;

        this.nickName = firstName + " " + lastName;

        this.password = Sha1.compute(password);

        this.bytePassword = this.password;

        this.deviceType = "ANDROID";

        this.locale = Locale.getDefault().toString();

        this.timezone = TimeZone.getDefault().getID();

        this.country = Locale.getDefault().getCountry();

        this.company = null;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBytePassword() {
        return bytePassword;
    }

    public void setBytePassword(String bytePassword) {
        this.bytePassword = bytePassword;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getType() {
        return EventNames.SIGN_UP;
    }
}
