package voxeet.com.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.ArrayList;
import java.util.List;

import voxeet.com.sdk.json.Event;
import voxeet.com.sdk.json.EventNames;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.SdkParticipant;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_UPDATED)
public class ConferenceUpdated extends Event {

    private String conferenceId;

    private String conferenceAlias;

    private long startTimestamp;

    @JsonProperty("isLive")
    private boolean live;

    private List<SdkParticipant> participants;

    public List<DefaultConferenceUser> getParticipants() {
        List<DefaultConferenceUser> users = new ArrayList<>();
        for (SdkParticipant participant : participants) {
            DefaultConferenceUser user = new DefaultConferenceUser(participant.getUserId(),
                    null, new UserInfo(participant.getMetadata().getExternalName(),
                    participant.getUserId(), participant.getMetadata().getExternalPhotoUrl()));
            user.setStatus(participant.getStatus());
            users.add(user);
        }
        return users;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getConferenceAlias() {
        return conferenceAlias;
    }

    public void setConferenceAlias(String conferenceAlias) {
        this.conferenceAlias = conferenceAlias;
    }

    public long getStartTimestamp() {
        return startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public boolean isLive() {
        return live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public void setParticipants(List<SdkParticipant> participants) {
        this.participants = participants;
    }

    @Override
    public String getType() {
        return EventNames.CONFERENCE_UPDATED;
    }
}
