package voxeet.com.sdk.core.impl;

import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.network.ISdkConferenceRService;
import voxeet.com.sdk.events.success.ConferenceCreationSuccess;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.ConferenceType;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

/**
 * Created by kevinleperf on 13/11/2017.
 */

public class ConferenceSdkService extends AbstractConferenceSdkService<ISdkConferenceRService, ConferenceSdkObservableProvider, ConferenceResponse> {

    public ConferenceSdkService(VoxeetSdkTemplate instance, long timeout) {
        super(instance, new ConferenceSdkObservableProvider(), timeout, instance.getRetrofit().create(ISdkConferenceRService.class));
    }

    @Override
    protected void onCreateDemoSuccess(ConferenceResponse response) {
        DefaultConference conference = createConference();
        conference.setConferenceId(response.getConfId());
        conference.setConferenceType(ConferenceType.DEMO.value());

        String conferenceAlias = response.getConfAlias();

        setConference(conference);
        setConferenceAlias(conferenceAlias);

        getTwig().i("Demo conference created with id: " + conference.getConferenceId());

        getEventBus().post(new ConferenceCreationSuccess(response.getConfId(), response.getConfAlias()));

        onCreationSuccess(response.getConfId());
    }

    @Override
    protected DefaultConference createConference() {
        return new DefaultConference();
    }

    @Override
    protected DefaultConferenceUser createConferenceUser(String userId, String device, UserInfo userInfo) {
        return new DefaultConferenceUser(userId, device, userInfo);
    }

    @Override
    protected void startTransactionConferenceUser() {
        //starting transaction
    }

    @Override
    protected void commitTransactionConferenceUser() {
        //commiting transaction
    }

    /**
     * Return true; some methods will have a behaviour slightly different
     *
     * @return the state of this implementation
     */
    @Override
    protected boolean isSDK() {
        return true;
    }
}
