package voxeet.com.sdk.promise;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * Abstract class managing the calls to forward to the parent promise
 */

public abstract class AbstractPromiseCallbackImpl<TYPE, TYPE_RESULT> implements IPromise<TYPE> {
    // parent promise
    private Promise<TYPE_RESULT> mParent;

    /**
     * Resolve a call and forward it to the parent
     *
     * @param result a nullable result
     */
    protected final void resolve(@Nullable TYPE_RESULT result) {
        mParent.resolve(result);
    }

    /**
     * Reject a call and forward it to the parent
     *
     * @param error a non null valid error
     */
    protected final void reject(@NonNull Throwable error) {
        mParent.reject(error);
    }

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
     * Internal methods
     * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

    void setPromise(@NonNull Promise<TYPE_RESULT> parent) {
        mParent = parent;
    }
}
