package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import voxeet.com.sdk.models.impl.DefaultMeeting;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class CreateMeetingAnswerEvent {

    private DefaultMeeting meeting;

    public CreateMeetingAnswerEvent(DefaultMeeting meeting) {
        setMeeting(meeting);
    }

    public CreateMeetingAnswerEvent() {
    }

    public DefaultMeeting getMeeting() {
        return meeting;
    }

    public void setMeeting(DefaultMeeting meeting) {
        this.meeting = meeting;
    }
}
