package voxeet.com.sdk.core.network;

import com.voxeet.android.media.peer.SdpDescription;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import rx.Observable;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.DeviceEvent;
import voxeet.com.sdk.json.GrandTypeEvent;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.SubscribeConference;
import voxeet.com.sdk.models.TokenResponse;

/**
 * Created by ROMMM on 4/4/16.
 */
public interface ISdkConferenceRService {

    @POST("v1/conferences/create")
    @Headers({"Content-Type: application/json", "Accept: application/json"})
    Observable<ConferenceResponse> createConference();

    @GET("v1/conferences/demo")
    Observable<ConferenceResponse> createDemo();

    @POST("v1/conferences/{id}/replay")
    @Headers({"Content-Type: application/json", "Accept: application/json"})
    Observable<ReplayConferenceEvent> replay(@Path("id") String conferenceId, @Body SdkConferenceReplayBody body);

    @GET("v1/conferences/{id}/recording/stop")
    Observable<Response<ResponseBody>> stopRecording(@Path("id") String conferenceId);

    @GET("/v1/conferences/{id}/status")
    Observable<GetConferenceStatusEvent> conferenceStatus(@Path("id") String conferenceId);

    @DELETE("/v1/conferences/{id}/subscribe")
    Observable<Response<ResponseBody>> unSubscribe(@Path("id") String conferenceId);

    @GET("/v1/conferences/{id}/subscribe")
    Observable<SubscribeConference> subscribe(@Path("id") String conferenceId);

    @GET("/v1/conferences/{id}/history")
    Observable<List<HistoryConference>> conferenceHistory(@Path("id") String conferenceId);

    @GET("v1/conferences/{id}/recording/start")
    Observable<Response<ResponseBody>> startRecording(@Path("id") String conferenceId);

    @POST("v1/conferences/{conferenceId}/send")
    Observable<Response<ResponseBody>> broadcastMessage(@Path("conferenceId") String conferenceId, @Body BroadcastEvent device);

    @POST("v1/conferences/{conferenceId}/join")
    Observable<ResumeConference> joinConference(@Path("conferenceId") String conferenceId, @Body DeviceEvent device);

    @POST("v1/conferences/{conferenceId}/leave")
    Observable<Response<ResponseBody>> leaveConference(@Path("conferenceId") String conferenceId);

    @POST("v1/conferences/{conferenceId}/answer/{user_id}")
    Observable<Response<ResponseBody>> answerConference(@Path("conferenceId") String conferenceId, @Path("user_id") String id, @Body SdpDescription description);

    @POST("v1/conferences/{conferenceId}/invite")
    Observable<Response<ResponseBody>> invite(@Path("conferenceId") String conferenceId, @Body SdkConferenceInvitation invitation);

    @POST("v1/oauth2/token")
    Observable<TokenResponse> getToken(@Header("Authorization") String authorization, @Body GrandTypeEvent grandType);

    @POST("v1/users/logout")
    Observable<Response<ResponseBody>> logout(@Header("Authorization") String authorization);

    @GET("v1/conferences/{id}/video/{uid}/start")
    Observable<StartVideoResponse> startVideo(@Path("id") String conferenceId, @Path("uid") String userId);

    @GET("v1/conferences/{id}/video/{uid}/stop")
    Observable<StopVideoResponse> stopVideo(@Path("id") String conferenceId, @Path("uid") String userId);

    @POST("v1/conferences/{id}/decline")
    Observable<Response<ResponseBody>> decline(@Path("id") String conferenceId);

    @GET("v1/conferences/{id}/call/subscribe")
    Observable<Response<ResponseBody>> subscribeForCall(@Path("id") String conferenceId);

    @DELETE("v1/conferences/{id}/call/subscribe")
    Observable<Response<ResponseBody>> unsubscribeFromCall(@Path("id") String conferenceId);
}
