package voxeet.com.sdk.core.impl;

import com.voxeet.android.media.peer.SdpDescription;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Response;
import rx.Observable;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkObservableProvider;
import voxeet.com.sdk.core.network.ISdkConferenceRService;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.DeviceEvent;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.SubscribeConference;

/**
 * Created by kevinleperf on 13/11/2017.
 */

public class ConferenceSdkObservableProvider extends AbstractConferenceSdkObservableProvider<ISdkConferenceRService, ConferenceResponse> {

    private ISdkConferenceRService _service;

    @Override
    protected ISdkConferenceRService getService() {
        return _service;
    }

    public Class getRetrofitInjectedClass() {
        return ISdkConferenceRService.class;
    }

    public void setRetrofitInstantiatedProvider(ISdkConferenceRService service) {
        _service = service;
    }

    @Override
    public Observable<Response<ResponseBody>> leaveConference(String conferenceId) {
        return getService().leaveConference(conferenceId);
    }

    @Override
    public Observable<Response<ResponseBody>> getDeclineObservable(String conferenceId) {
        return getService().decline(conferenceId);
    }

    @Override
    public Observable<StartVideoResponse> getStartVideoObservable(String conferenceId, String id) {
        return getService().startVideo(conferenceId, id);
    }

    @Override
    public Observable<StopVideoResponse> getStopVideoObservable(String conferenceId, String id) {
        return getService().stopVideo(conferenceId, id);
    }

    @Override
    public Observable<ConferenceResponse> getCreateConferenceObservable() {
        return getService().createConference();
    }

    @Override
    public Observable<ConferenceResponse> getCreateDemoObservable() {
        return getService().createDemo();
    }

    @Override
    public Observable<Response<ResponseBody>> getInviteObservable(String conferenceId, SdkConferenceInvitation sdkConferenceInvitation) {
        return getService().invite(conferenceId, sdkConferenceInvitation);
    }

    @Override
    public Observable<ReplayConferenceEvent> getReplayObservable(String conferenceId, SdkConferenceReplayBody sdkConferenceReplayBody) {
        return getService().replay(conferenceId, sdkConferenceReplayBody);
    }

    @Override
    public Observable<Response<ResponseBody>> getStartRecordingObservable(String conferenceId) {
        return getService().startRecording(conferenceId);
    }

    @Override
    public Observable<Response<ResponseBody>> getStopRecordingObservable(String conferenceId) {
        return getService().stopRecording(conferenceId);
    }

    @Override
    public Observable<Response<ResponseBody>> getLogOutObservable(String token) {
        return getService().logout(token);
    }

    @Override
    public Observable<GetConferenceStatusEvent> getConferenceStatusObservable(String conferenceId) {
        return getService().conferenceStatus(conferenceId);
    }

    @Override
    public Observable<List<HistoryConference>> getConferenceHistoryObservable(String conferenceId) {
        return getService().conferenceHistory(conferenceId);
    }

    @Override
    public Observable<SubscribeConference> getSubscribeObservable(String conferenceId) {
        return getService().subscribe(conferenceId);
    }

    @Override
    public Observable<Response<ResponseBody>> getUnSubscribeObservable(String conferenceId) {
        return getService().unSubscribe(conferenceId);
    }

    @Override
    public Observable<Response<ResponseBody>> getSubscribeForCallObservable(String conferenceId) {
        return getService().subscribeForCall(conferenceId);
    }

    @Override
    public Observable<Response<ResponseBody>> getUnSubscribeFromCallObservable(String conferenceId) {
        return getService().unsubscribeFromCall(conferenceId);
    }

    @Override
    public Observable<ResumeConference> joinConference(String conferenceId, DeviceEvent deviceEvent) {
        return getService().joinConference(conferenceId, deviceEvent);
    }

    @Override
    public Observable<Response<ResponseBody>> answerConference(String conferenceId, String peer, SdpDescription description) {
        return getService().answerConference(conferenceId, peer, description);
    }

    @Override
    public Observable<Response<ResponseBody>> broadcastMessage(String conferenceId, BroadcastEvent broadcastEvent) {
        return getService().broadcastMessage(conferenceId, broadcastEvent);
    }
}
