/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.app.Application;
import android.content.ContentResolver;
import android.provider.Settings;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import voxeet.com.sdk.converter.JacksonConverterFactory;
import voxeet.com.sdk.core.FirebaseController;
import voxeet.com.sdk.core.VoxeetPreferences;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.network.IVoxeetRService;
import voxeet.com.sdk.json.GrandTypeEvent;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.TokenResponse;
import voxeet.com.sdk.models.UserTokenResponse;
import voxeet.com.sdk.networking.DeviceType;
import voxeet.com.sdk.utils.Auth64;

public class VoxeetHttp {
    private static final String TAG = VoxeetHttp.class.getSimpleName();
    private final VoxeetSdkTemplate sdk;
    protected IVoxeetRService service;
    protected TokenResponse tokenResponse;
    private Application appContext;
    private String serverUrl;
    private String serverPort;
    public Retrofit retrofit;
    private OkHttpClient client;
    private String appId;
    private String password;
    private VoxeetServiceListener listener;
    private boolean debug = false;
    private final HashMap<String, List<Cookie>> cookieStore = new HashMap();

    private VoxeetHttp(Application appContext, VoxeetSdkTemplate sdk, String serverUrl, String serverPort, String appId, String password, VoxeetServiceListener listener, boolean debug) {
        this.sdk = sdk;
        this.tokenResponse = null;
        this.serverUrl = serverUrl;
        this.serverPort = serverPort;
        this.appContext = appContext;
        this.debug = debug;
        this.listener = listener;
        this.appId = appId;
        this.password = password;
        this.initClient();
        this.initRetrofit();
        this.initService();
    }

    private void initClient() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                String base = url.scheme() + "://" + url.host() + ":" + url.port();
                VoxeetHttp.this.cookieStore.put(base, Lists.newArrayList((Iterable)Iterables.filter(cookies, (Predicate)new Predicate<Cookie>(){

                    public boolean apply(Cookie input) {
                        return input != null && !input.value().equalsIgnoreCase("deleted") && new Date().before(new Date(input.expiresAt()));
                    }
                })));
            }

            public List<Cookie> loadForRequest(HttpUrl url) {
                String base = url.scheme() + "://" + url.host() + ":" + url.port();
                List cookies = (List)VoxeetHttp.this.cookieStore.get(base);
                return cookies != null ? cookies : new ArrayList();
            }
        }).addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                try {
                    if (VoxeetHttp.this.tokenResponse == null) {
                        return chain.proceed(chain.request());
                    }
                    return chain.proceed(chain.request().newBuilder().addHeader("Authorization", "bearer " + VoxeetHttp.this.tokenResponse.getToken()).build());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                try {
                    Observable<TokenResponse> token = VoxeetHttp.this.service.getToken(Auth64.serialize(VoxeetHttp.this.appId, VoxeetHttp.this.password), new GrandTypeEvent("client_credentials"));
                    VoxeetHttp.this.tokenResponse = (TokenResponse)token.toBlocking().single();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Invalid credentials");
                }
                return response.request().newBuilder().addHeader("Authorization", "bearer " + VoxeetHttp.this.tokenResponse.getToken()).build();
            }
        }).retryOnConnectionFailure(true).readTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS);
        if (this.debug) {
            builder = builder.addInterceptor((Interceptor)interceptor);
        }
        this.client = builder.build();
    }

    private void initRetrofit() {
        this.retrofit = new Retrofit.Builder().addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.client).build();
    }

    private void initService() {
        this.service = (IVoxeetRService)this.retrofit.create(IVoxeetRService.class);
    }

    public void identify(UserInfo userInfo) {
        userInfo.setDeviceIdentifier(Settings.Secure.getString((ContentResolver)this.appContext.getContentResolver(), (String)"android_id"));
        if (FirebaseController.getInstance().isEnabled()) {
            this.sdk.getTwig().i("FirebaseInstanceId.getInstance().getToken(): " + FirebaseInstanceId.getInstance().getToken(), new Object[0]);
            userInfo.setDevicePushToken(FirebaseInstanceId.getInstance().getToken());
        } else {
            this.sdk.getTwig().i("FirebaseApp is not initialized. Make sure to call FirebaseApp.initializeApp(Context) before initializing the VoxeetSDK if you are planning on using FCM.", new Object[0]);
        }
        userInfo.setDeviceType(DeviceType.ANDROID);
        Observable<UserTokenResponse> user = this.service.identify(userInfo);
        user.subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<UserTokenResponse>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                e.printStackTrace();
                if (e instanceof UnknownHostException) {
                    VoxeetHttp.this.listener.onNetworkError((UnknownHostException)e);
                } else {
                    VoxeetHttp.this.listener.onIdentifyError(e.getMessage());
                }
            }

            public void onNext(UserTokenResponse userTokenResponse) {
                VoxeetHttp.this.sdk.getTwig().i("Successful login with id " + userTokenResponse.getId(), new Object[0]);
                VoxeetPreferences.setId(userTokenResponse.getId());
                VoxeetPreferences.saveLoginCookie(userTokenResponse.getUserToken());
                VoxeetHttp.this.listener.onIdentifySuccess(userTokenResponse, VoxeetHttp.this.tokenResponse);
                List<Cookie> cookies = VoxeetHttp.this.getCookies(VoxeetHttp.this.getBuiltServerUrl());
                if (cookies != null && cookies.size() > 0) {
                    VoxeetPreferences.saveLoginCookie(cookies.get(0).toString());
                }
            }
        });
    }

    public List<Cookie> getCookies(String url) {
        for (Map.Entry<String, List<Cookie>> o : this.cookieStore.entrySet()) {
            Map.Entry<String, List<Cookie>> pair = o;
            if (!pair.getKey().contains(url)) continue;
            return this.cookieStore.get(pair.getKey());
        }
        return null;
    }

    public String createCookie(String value) {
        String url = this.getBuiltServerUrl();
        Cookie cookie = Cookie.parse((HttpUrl)HttpUrl.parse((String)url), (String)value);
        if (cookie != null && cookie.toString().length() > 0) {
            this.cookieStore.put(url, Collections.singletonList(cookie));
            return cookie.value();
        }
        return null;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public String retrieveCookie() {
        String cookie = VoxeetPreferences.getLoginCookie();
        if (cookie != null && cookie.length() > 0) {
            cookie = this.createCookie(cookie);
        } else {
            List<Cookie> cookies = this.getCookies(this.getBuiltServerUrl());
            if (cookies != null && cookies.size() > 0) {
                cookie = cookies.get(0).value();
                VoxeetPreferences.saveLoginCookie(cookies.get(0).toString());
            }
        }
        return cookie;
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    private String getBuiltServerUrl() {
        String port = this.serverPort;
        if (!port.startsWith(":")) {
            port = ":" + port;
        }
        return this.serverUrl + port;
    }

    public static final class Builder {
        private Application _application;
        private VoxeetSdkTemplate _sdk;
        private String _server_url;
        private String _server_port;
        private String _app_id;
        private String _password;
        private VoxeetServiceListener _listener;
        private boolean _debug;

        public Builder setApplication(Application application) {
            this._application = application;
            return this;
        }

        public Builder setVoxeetSDK(VoxeetSdkTemplate sdk) {
            this._sdk = sdk;
            return this;
        }

        public Builder setServerUrl(String serverUrl) {
            this._server_url = serverUrl;
            return this;
        }

        public Builder setServerPort(String serverPort) {
            this._server_port = serverPort;
            return this;
        }

        public Builder setAppId(String appId) {
            this._app_id = appId;
            return this;
        }

        public Builder setPassword(String password) {
            this._password = password;
            return this;
        }

        public Builder setVoxeetServiceListener(VoxeetServiceListener listener) {
            this._listener = listener;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this._debug = debug;
            return this;
        }

        public VoxeetHttp build() {
            return new VoxeetHttp(this._application, this._sdk, this._server_url, this._server_port, this._app_id, this._password, this._listener, this._debug);
        }
    }

    public static interface VoxeetServiceListener {
        public void onIdentifySuccess(UserTokenResponse var1, TokenResponse var2);

        public void onIdentifyError(String var1);

        public void onNetworkError(UnknownHostException var1);
    }
}

